/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension3;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension7;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.viewers.ViewerLabelUtils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.SearchPattern;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposal;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public abstract class SourceProposal<TContext extends AssistInvocationContext>
implements AssistProposal,
ICompletionProposalExtension,
ICompletionProposalExtension2,
ICompletionProposalExtension3,
ICompletionProposalExtension4,
ICompletionProposalExtension6,
ICompletionProposalExtension7 {
    private final TContext context;
    private final int replacementOffset;
    private final @Nullable SearchPattern namePattern;
    private int matchOffset;
    private String matchPattern;
    private int matchRule;
    private final int baseRelevance;
    private @Nullable StyledString styledText;
    private @Nullable Annotation rememberedOverwriteAnnotation;
    private @Nullable ApplyData applyData;

    public SourceProposal(ProposalParameters<? extends TContext> parameters) {
        this.context = parameters.context;
        this.replacementOffset = parameters.replacementOffset;
        this.namePattern = parameters.namePattern;
        this.matchOffset = ((AssistInvocationContext)this.context).getInvocationOffset();
        this.matchPattern = this.namePattern != null ? this.namePattern.getPattern() : null;
        this.matchRule = parameters.matchRule;
        this.baseRelevance = parameters.baseRelevance;
    }

    private boolean isInOverwriteMode(boolean toggle) {
        return toggle;
    }

    protected final TContext getInvocationContext() {
        return this.context;
    }

    private final SearchPattern getNamePattern(@Nullable String pattern) {
        SearchPattern namePattern = (SearchPattern)ObjectUtils.nonNullAssert((Object)this.namePattern);
        namePattern.setPattern(pattern != null ? pattern : this.matchPattern);
        return namePattern;
    }

    protected abstract String getName();

    protected final int getReplacementOffset() {
        return this.replacementOffset;
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
        int end = Math.max(caretOffset, selection.x + selection.y);
        return end - replacementOffset;
    }

    protected final ApplyData getApplyData() {
        ApplyData applyData = this.applyData;
        if (applyData == null) {
            this.applyData = applyData = this.createApplyData();
        }
        return applyData;
    }

    protected ApplyData createApplyData() {
        return new ApplyData();
    }

    @Deprecated
    public boolean isValidFor(IDocument document, int offset) {
        return false;
    }

    public boolean validate(IDocument document, int offset, @Nullable DocumentEvent event) {
        return this.doValidate(offset, event) != 0;
    }

    protected int doValidate(int offset, @Nullable DocumentEvent event) {
        if (this.namePattern != null) {
            try {
                String prefix = this.getValidationPrefix(offset);
                if (prefix != null) {
                    return this.validatePattern(offset, prefix, this.getValidationName());
                }
                return 0;
            }
            catch (BadLocationException e) {
                return 0;
            }
        }
        return offset == ((AssistInvocationContext)this.getInvocationContext()).getInvocationOffset() ? this.matchRule : 0;
    }

    protected @Nullable String getValidationPrefix(int offset) throws BadLocationException {
        int startOffset = Math.max(this.getReplacementOffset(), 0);
        if (offset >= startOffset) {
            return ((AssistInvocationContext)this.getInvocationContext()).getDocument().get(startOffset, offset - startOffset);
        }
        return null;
    }

    protected String getValidationName() {
        return this.getName();
    }

    protected int validatePattern(int offset, String pattern, String name) {
        SearchPattern namePattern = this.getNamePattern(pattern);
        int matchRule = namePattern.matches(name);
        if (matchRule != 0) {
            this.matchOffset = offset;
            this.matchPattern = pattern;
            this.matchRule = matchRule;
        }
        return matchRule;
    }

    protected final int getMatchRule(int offset) {
        if (this.matchOffset == offset) {
            return this.matchRule;
        }
        return this.doValidate(offset, null);
    }

    @Override
    public int getRelevance() {
        int relevance = this.baseRelevance;
        if ((this.matchRule & 0x18) != 0) {
            relevance -= 10;
        }
        return relevance;
    }

    @Override
    public abstract String getSortingString();

    public String getDisplayString() {
        return this.getName();
    }

    public final StyledString getStyledDisplayString() {
        StyledString styledText = this.styledText;
        if (styledText == null) {
            this.styledText = styledText = this.computeStyledText();
        }
        return styledText;
    }

    protected StyledString computeStyledText() {
        return new StyledString(this.getDisplayString());
    }

    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        int matchRule;
        if (this.namePattern != null && (matchRule = this.getMatchRule(offset)) != 0) {
            StyledString styledText = new StyledString();
            styledText.append(this.getStyledDisplayString());
            SearchPattern namePattern = this.getNamePattern(null);
            int[] matchingRegions = namePattern.getMatchingRegions(this.getValidationName(), matchRule);
            if (matchingRegions != null) {
                this.styleMatchingRegions(styledText, matchRule, matchingRegions, boldStylerProvider);
            }
            return styledText;
        }
        return this.getStyledDisplayString();
    }

    protected void styleMatchingRegions(StyledString styledText, int matchRule, int[] matchingRegions, BoldStylerProvider boldStylerProvider) {
        ViewerLabelUtils.setStyle((StyledString)styledText, (int[])matchingRegions, (StyledString.Styler)boldStylerProvider.getBoldStyler());
    }

    public Image getImage() {
        return SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy");
    }

    @Override
    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (this.isInOverwriteMode(smartToggle)) {
            this.addOverwriteStyle();
        } else {
            this.repairPresentation();
        }
    }

    @Override
    public void unselected(ITextViewer viewer) {
        this.repairPresentation();
    }

    public @Nullable String getAdditionalProposalInfo() {
        return null;
    }

    public @Nullable IInformationControlCreator getInformationControlCreator() {
        return null;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public char @Nullable [] getTriggerCharacters() {
        return null;
    }

    public int getPrefixCompletionStart(IDocument document, int offset) {
        return Math.max(this.getReplacementOffset(), 0);
    }

    public @Nullable CharSequence getPrefixCompletionText(IDocument document, int offset) {
        return this.getName();
    }

    @Deprecated
    public void apply(IDocument document, char trigger, int offset) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        assert (((AssistInvocationContext)this.getInvocationContext()).getSourceViewer() == viewer);
        boolean smartToggle = (stateMask & 0x40000) != 0;
        try {
            int replacementOffset = Math.max(this.getReplacementOffset(), 0);
            int replacementLength = this.computeReplacementLength(replacementOffset, viewer.getSelectedRange(), offset, this.isInOverwriteMode(smartToggle));
            if (this.validate(viewer.getDocument(), offset, null)) {
                this.doApply(trigger, stateMask, offset, replacementOffset, replacementLength);
                return;
            }
        }
        catch (BadLocationException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", "Failed to apply completion proposal (" + this.getClass().getName() + ").", (Throwable)e));
        }
        Display.getCurrent().beep();
    }

    protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
        TContext context = this.getInvocationContext();
        IDocument document = ((AssistInvocationContext)context).getDocument();
        ApplyData applyData = this.getApplyData();
        StringBuilder replacement = new StringBuilder(this.getName());
        int cursor = replacement.length();
        document.replace(replacementOffset, replacementLength, replacement.toString());
        applyData.setSelection(replacementOffset + cursor);
    }

    protected void reinvokeAssist() {
        SourceViewer viewer = ((AssistInvocationContext)this.getInvocationContext()).getSourceViewer();
        if (viewer instanceof ITextOperationTarget) {
            final ITextOperationTarget target = (ITextOperationTarget)viewer;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (target.canDoOperation(13)) {
                        target.doOperation(13);
                    }
                }
            });
        }
    }

    public @Nullable Point getSelection(IDocument document) {
        TextRegion selection;
        ApplyData applyData = this.applyData;
        if (applyData != null && (selection = applyData.getSelection()) != null) {
            return new Point(selection.getStartOffset(), selection.getLength());
        }
        return null;
    }

    public @Nullable IContextInformation getContextInformation() {
        ApplyData applyData = this.applyData;
        if (applyData != null) {
            return applyData.getContextInformation();
        }
        return null;
    }

    public int getContextInformationPosition() {
        return ((AssistInvocationContext)this.getInvocationContext()).getSourceViewer().getSelectedRange().x;
    }

    private void addOverwriteStyle() {
        int replacementLength;
        SourceViewer viewer = ((AssistInvocationContext)this.getInvocationContext()).getSourceViewer();
        StyledText text = viewer.getTextWidget();
        if (text == null || text.isDisposed()) {
            return;
        }
        int widgetCaret = viewer.getTextWidget().getCaretOffset();
        int modelCaret = viewer.widgetOffset2ModelOffset(widgetCaret);
        int replacementOffset = Math.max(this.getReplacementOffset(), 0);
        try {
            replacementLength = this.computeReplacementLength(replacementOffset, viewer.getSelectedRange(), modelCaret, true);
        }
        catch (BadLocationException e) {
            replacementLength = -1;
        }
        if (replacementLength < 0 || modelCaret >= replacementOffset + replacementLength) {
            this.repairPresentation();
            return;
        }
        int offset = widgetCaret;
        int length = replacementOffset + replacementLength - modelCaret;
        this.repairPresentation();
        Annotation annotation = new Annotation("org.eclipse.statet.ecommons.text.editorAnnotations.ContentAssistOverwrite", false, "");
        viewer.getAnnotationModel().addAnnotation(annotation, new Position(offset, length));
        this.rememberedOverwriteAnnotation = annotation;
    }

    private void repairPresentation() {
        Annotation rememberedOverwriteAnnotation = this.rememberedOverwriteAnnotation;
        if (rememberedOverwriteAnnotation != null) {
            SourceViewer viewer = ((AssistInvocationContext)this.getInvocationContext()).getSourceViewer();
            this.rememberedOverwriteAnnotation = null;
            viewer.getAnnotationModel().removeAnnotation(rememberedOverwriteAnnotation);
        }
    }

    public String toString() {
        ObjectUtils.ToStringBuilder sb = new ObjectUtils.ToStringBuilder(SourceProposal.class, this.getClass());
        sb.addProp("displayString", this.getDisplayString());
        sb.addProp("relevance", this.getRelevance());
        sb.addProp("sortingString", this.getSortingString());
        return sb.toString();
    }

    protected static class ApplyData {
        private @Nullable TextRegion selectionToSet;
        private @Nullable IContextInformation contextInformation;

        public void setSelection(TextRegion region) {
            this.selectionToSet = region;
        }

        public void setSelection(int offset) {
            this.selectionToSet = new BasicTextRegion(offset, offset);
        }

        public void setSelection(int offset, int length) {
            assert (length >= 0);
            this.selectionToSet = new BasicTextRegion(offset, offset + length);
        }

        public void clearSelection() {
            this.selectionToSet = null;
        }

        public @Nullable TextRegion getSelection() {
            return this.selectionToSet;
        }

        public void setContextInformation(IContextInformation info) {
            this.contextInformation = info;
        }

        public @Nullable IContextInformation getContextInformation() {
            return this.contextInformation;
        }
    }

    public static class ProposalParameters<TContext extends AssistInvocationContext> {
        public final TContext context;
        public final int replacementOffset;
        public final SearchPattern namePattern;
        public int baseRelevance;
        public int matchRule;

        public ProposalParameters(TContext context, int replacementOffset, SearchPattern namePattern, int baseRelevance) {
            this.context = (AssistInvocationContext)ObjectUtils.nonNullAssert(context);
            this.replacementOffset = replacementOffset;
            this.namePattern = (SearchPattern)ObjectUtils.nonNullAssert((Object)namePattern);
            this.baseRelevance = baseRelevance;
        }

        public ProposalParameters(TContext context, int replacementOffset, SearchPattern namePattern) {
            this(context, replacementOffset, namePattern, 0);
        }

        public ProposalParameters(TContext context, int replacementOffset, int baseRelevance) {
            this.context = (AssistInvocationContext)ObjectUtils.nonNullAssert(context);
            this.replacementOffset = replacementOffset;
            this.namePattern = null;
            this.matchRule = 0x1000000;
            this.baseRelevance = baseRelevance;
        }

        public boolean matchesNamePattern(@Nullable String name) {
            if (name == null) {
                this.matchRule = 0;
                return false;
            }
            this.matchRule = this.namePattern.matches(name);
            return this.matchRule != 0;
        }
    }
}

