/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.ui.ColorManager;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.graphics.RGB;

public class TextStyleManager
implements SettingsChangeNotifier.ManageListener {
    protected ColorManager colorManager;
    protected IPreferenceStore preferenceStore;
    protected String[] tokenNames;
    private final String stylesGroupId;
    private final Map<String, Token> tokenMap = new HashMap<String, Token>();

    public TextStyleManager(ColorManager colorManager, IPreferenceStore preferenceStore, String stylesGroupId) {
        this.colorManager = colorManager;
        this.preferenceStore = preferenceStore;
        this.stylesGroupId = stylesGroupId;
    }

    public IToken getToken(String key) {
        Token token = this.tokenMap.get(key);
        if (token == null) {
            token = new Token(this.createTextAttribute(key));
            this.tokenMap.put(key, token);
        }
        return token;
    }

    protected String resolveUsedKey(String key) {
        String use = key;
        String test;
        while ((test = this.preferenceStore.getString(String.valueOf(use) + ".use")) != null && !test.equals("") && !test.equals(use)) {
            use = test;
        }
        return use;
    }

    protected Object createTextAttribute(String rootKey) {
        int style;
        rootKey = this.resolveUsedKey(rootKey);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)(String.valueOf(rootKey) + ".color"));
        int n = style = this.preferenceStore.getBoolean(String.valueOf(rootKey) + ".bold") ? 1 : 0;
        if (this.preferenceStore.getBoolean(String.valueOf(rootKey) + ".italic")) {
            style |= 2;
        }
        if (this.preferenceStore.getBoolean(String.valueOf(rootKey) + ".underline")) {
            style |= 0x40000000;
        }
        if (this.preferenceStore.getBoolean(String.valueOf(rootKey) + ".strikethrough")) {
            style |= 0x20000000;
        }
        return new TextAttribute(this.colorManager.getColor(rgb), null, style);
    }

    public boolean affectsTextPresentation(Set<String> groupIds) {
        return groupIds.contains(this.stylesGroupId);
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        if (this.affectsTextPresentation(groupIds)) {
            for (Map.Entry<String, Token> token : this.tokenMap.entrySet()) {
                token.getValue().setData(this.createTextAttribute(token.getKey()));
            }
            if (options != null) {
                options.put("affects.Presentation", Boolean.TRUE);
            }
        }
    }

    public void beforeSettingsChangeNotification(final Set<String> groupIds) {
        if (this.affectsTextPresentation(groupIds)) {
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    TextStyleManager.this.handleSettingsChanged(groupIds, null);
                }
            });
        }
    }

    public void afterSettingsChangeNotification(Set<String> groupIds) {
    }
}

