/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell.decorator;

import java.util.List;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.painter.cell.CellPainterWrapper;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.painter.cell.ICellPainter;
import org.eclipse.statet.ecommons.waltable.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.style.CellStyleAttributes;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.statet.ecommons.waltable.style.IStyle;
import org.eclipse.statet.ecommons.waltable.swt.SWTUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class CustomLineBorderDecorator
extends CellPainterWrapper {
    public static final String TOP_LINE_BORDER_LABEL = "topLineBorderLabel";
    public static final String BOTTOM_LINE_BORDER_LABEL = "bottomLineBorderLabel";
    public static final String LEFT_LINE_BORDER_LABEL = "leftLineBorderLabel";
    public static final String RIGHT_LINE_BORDER_LABEL = "rightLineBorderLabel";
    private final BorderStyle defaultBorderStyle;

    public CustomLineBorderDecorator(ICellPainter interiorPainter) {
        this(interiorPainter, null);
    }

    public CustomLineBorderDecorator(ICellPainter interiorPainter, BorderStyle defaultBorderStyle) {
        super(interiorPainter);
        this.defaultBorderStyle = defaultBorderStyle;
    }

    @Override
    public long getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        long borderLineCount = 0L;
        List<String> labels = cell.getConfigLabels().getLabels();
        if (labels.contains(RIGHT_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        if (labels.contains(LEFT_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        return super.getPreferredWidth(cell, gc, configRegistry) + borderThickness * borderLineCount;
    }

    @Override
    public long getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        long borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        long borderLineCount = 0L;
        List<String> labels = cell.getConfigLabels().getLabels();
        if (labels.contains(TOP_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        if (labels.contains(BOTTOM_LINE_BORDER_LABEL)) {
            ++borderLineCount;
        }
        return super.getPreferredHeight(cell, gc, configRegistry) + borderThickness * borderLineCount;
    }

    private BorderStyle getBorderStyle(ILayerCell cell, IConfigRegistry configRegistry) {
        IStyle cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
        BorderStyle borderStyle = cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE);
        if (borderStyle == null) {
            borderStyle = this.defaultBorderStyle;
        }
        return borderStyle;
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, LRectangle lRectangle, IConfigRegistry configRegistry) {
        BorderStyle borderStyle = this.getBorderStyle(cell, configRegistry);
        int borderThickness = borderStyle != null ? borderStyle.getThickness() : 0;
        List<String> labels = cell.getConfigLabels().getLabels();
        long leftBorderThickness = 0L;
        long rightBorderThickness = 0L;
        long topBorderThickness = 0L;
        long bottomBorderThickness = 0L;
        if (labels.contains(LEFT_LINE_BORDER_LABEL)) {
            leftBorderThickness = borderThickness;
        }
        if (labels.contains(RIGHT_LINE_BORDER_LABEL)) {
            rightBorderThickness = borderThickness;
        }
        if (labels.contains(TOP_LINE_BORDER_LABEL)) {
            topBorderThickness = borderThickness;
        }
        if (labels.contains(BOTTOM_LINE_BORDER_LABEL)) {
            bottomBorderThickness = borderThickness;
        }
        LRectangle interiorBounds = new LRectangle(lRectangle.x + leftBorderThickness, lRectangle.y + topBorderThickness, lRectangle.width - leftBorderThickness - rightBorderThickness, lRectangle.height - topBorderThickness - bottomBorderThickness);
        super.paintCell(cell, gc, interiorBounds, configRegistry);
        if (borderStyle == null || borderThickness <= 0 || leftBorderThickness == 0L && rightBorderThickness == 0L && topBorderThickness == 0L && bottomBorderThickness == 0L) {
            return;
        }
        Color originalForeground = gc.getForeground();
        int originalLineWidth = gc.getLineWidth();
        int originalLineStyle = gc.getLineStyle();
        gc.setLineWidth(borderThickness);
        LRectangle borderArea = new LRectangle(lRectangle.x, lRectangle.y, lRectangle.width, lRectangle.height);
        if (borderThickness >= 1) {
            int shift = 0;
            int correction = 0;
            if (borderThickness % 2 == 0) {
                shift = borderThickness / 2;
            } else {
                shift = borderThickness / 2;
                correction = 1;
            }
            if (leftBorderThickness >= 1L) {
                borderArea.x += (long)shift;
                borderArea.width -= (long)shift;
            }
            if (rightBorderThickness >= 1L) {
                borderArea.width -= (long)(shift + correction);
            }
            if (topBorderThickness >= 1L) {
                borderArea.y += (long)shift;
                borderArea.height -= (long)shift;
            }
            if (bottomBorderThickness >= 1L) {
                borderArea.height -= (long)(shift + correction);
            }
        }
        gc.setLineStyle(SWTUtil.toSWT(borderStyle.getLineStyle()));
        gc.setForeground(borderStyle.getColor());
        Rectangle rect = GraphicsUtils.safe(borderArea);
        if (leftBorderThickness > 0L && rightBorderThickness > 0L && topBorderThickness > 0L && bottomBorderThickness > 0L) {
            gc.drawRectangle(rect);
        } else {
            Point topLeftPos = new Point(rect.x, rect.y);
            Point topRightPos = new Point(rect.x + rect.width, rect.y);
            Point bottomLeftPos = new Point(rect.x, rect.y + rect.height);
            Point bottomRightPos = new Point(rect.x + rect.width, rect.y + rect.height);
            if (leftBorderThickness > 0L) {
                gc.drawLine(topLeftPos.x, topLeftPos.y, bottomLeftPos.x, bottomLeftPos.y);
            }
            if (rightBorderThickness > 0L) {
                gc.drawLine(topRightPos.x, topRightPos.y, bottomRightPos.x, bottomRightPos.y);
            }
            if (topBorderThickness > 0L) {
                gc.drawLine(topLeftPos.x, topLeftPos.y, topRightPos.x, topRightPos.y);
            }
            if (bottomBorderThickness > 0L) {
                gc.drawLine(bottomLeftPos.x, bottomLeftPos.y, bottomRightPos.x, bottomRightPos.y);
            }
        }
        gc.setForeground(originalForeground);
        gc.setLineWidth(originalLineWidth);
        gc.setLineStyle(originalLineStyle);
    }
}

