/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.ecommons.databinding.core.observable.ObservableUtils;
import org.eclipse.statet.ecommons.databinding.core.observable.WritableEqualityValue;
import org.eclipse.statet.ecommons.databinding.core.validation.UpdateableErrorValidator;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigPresets;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigTabWithPresets;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariables;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.ecommons.ui.workbench.workspace.ResourceVariableUtil;
import org.eclipse.statet.ecommons.variables.core.ObservableValueVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

@NonNullByDefault
public class DocProcessingConfigMainTab
extends LaunchConfigTabWithPresets
implements IValueChangeListener<Object> {
    private static final String WORKING_DIRECTORY_DEFAULT_VALUE = "${container_path}";
    private final List<StepItem> stepItems;
    private final IObservableValue<String> workingDirectoryValue;
    private final ResourceVariableUtil resolvedSourceFileVariableUtil;
    private final Map<String, IStringVariable> resolvedSourceFileVariables = new HashMap<String, IStringVariable>();
    private IObservableValue<@Nullable IResource> resolvedWorkingDirectoryResourceValue;
    private final ObservableValueVariable<@Nullable String> resolvedWorkingDirectoryPathVariable;
    private ResourceInputComposite workingDirectoryControl;

    public DocProcessingConfigMainTab(LaunchConfigPresets presets) {
        this.stepItems = new ArrayList<StepItem>();
        Realm realm = this.getRealm();
        this.workingDirectoryValue = new WritableValue(realm, null, String.class);
        this.setPresets(presets);
        this.resolvedSourceFileVariableUtil = new ResourceVariableUtil(){

            protected @Nullable IResource fetchResource() {
                IResource resource = super.fetchResource();
                return resource instanceof IFile ? resource : null;
            }
        };
        this.resolvedWorkingDirectoryPathVariable = new ObservableValueVariable("wd_path", null, (IObservableValue)new WritableEqualityValue(realm, null, String.class));
    }

    int addStep(DocProcessingConfigStepTab stepTab) {
        StepItem item = new StepItem(stepTab);
        this.stepItems.add(item);
        return this.stepItems.size();
    }

    protected DocProcessingConfigStepTab getStepTab(int num) {
        return this.stepItems.get(num - 1).tab;
    }

    public String getName() {
        return Messages.MainTab_name;
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.initVariables(this.resolvedSourceFileVariables);
    }

    protected void initVariables(Map<String, IStringVariable> variables) {
        VariableUtils.add(variables, (Collection)ResourceVariables.getSingleResourceVariables(), (IDynamicVariableResolver)new ResourceVariableResolver((ResourceVariableResolver.Context)this.resolvedSourceFileVariableUtil));
        VariableUtils.add(variables, (IStringVariable)VariableUtils.toStaticVariable((IStringVariable)DocProcessingConfig.SOURCE_FILE_PATH_VAR, (IStringVariable)VariableUtils.getChecked(variables, (String)"resource_path")));
    }

    public @Nullable IFile getSourceFile() {
        return (IFile)this.resolvedSourceFileVariableUtil.getResource();
    }

    public ResourceVariableUtil getSourceFileVariableUtil() {
        return this.resolvedSourceFileVariableUtil;
    }

    public Map<String, IStringVariable> getSourceFileVariables() {
        return this.resolvedSourceFileVariables;
    }

    public ObservableValueVariable<@Nullable String> getWorkingDirectoryPathVariable() {
        return this.resolvedWorkingDirectoryPathVariable;
    }

    public void handleValueChange(ValueChangeEvent<?> event) {
        if (event.getObservable() == this.resolvedWorkingDirectoryResourceValue) {
            IResource resource = (IResource)ObservableUtils.typed(event, this.resolvedWorkingDirectoryResourceValue).diff.getNewValue();
            this.resolvedWorkingDirectoryPathVariable.getObservable().setValue(resource != null ? resource.getFullPath().toString() : null);
            return;
        }
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        mainComposite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
        this.addPresetsButton(mainComposite);
        Composite composite = this.createOverviewGroup(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite = this.createWorkingDirectoryGroup(mainComposite);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        Dialog.applyDialogFont((Control)parent);
        this.initBindings();
    }

    protected Composite createOverviewGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        group.setText(Messages.MainTab_Overview_label);
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_Overview_Step_header);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_Overview_Run_header);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label = new Label((Composite)group, 0);
        label.setText(Messages.MainTab_Overview_Detail_header);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Label filler = new Label((Composite)group, 0);
        filler.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(gc.getDevice().getSystemColor(19));
                gc.drawLine(e.x, 0, e.width, 0);
            }
        });
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 3;
        gd.heightHint = LayoutUtils.defaultVSpacing() / 2;
        filler.setLayoutData((Object)gd);
        for (StepItem stepItem : this.stepItems) {
            Label label2 = new Label((Composite)group, 0);
            label2.setText(String.valueOf(stepItem.tab.getNum()) + ")\u2002" + stepItem.tab.getLabel());
            label2.setLayoutData((Object)new GridData(4, 128, false, false));
            Button button = new Button((Composite)group, 32);
            button.setEnabled(false);
            button.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
            stepItem.enabledControl = button;
            Label info = new Label((Composite)group, 0);
            info.setLayoutData((Object)new GridData(4, 128, true, false));
            stepItem.infoControl = info;
            stepItem.updateInfo();
            LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        }
        return group;
    }

    protected Composite createWorkingDirectoryGroup(Composite parent) {
        ResourceInputComposite pathInput = new ResourceInputComposite(parent, 2, 26, String.valueOf(Messages.MainTab_WorkingDir_label) + " (workspace path)");
        pathInput.getValidator().setResourceLabel(MessageUtils.removeMnemonics((String)Messages.MainTab_WorkingDir_label));
        pathInput.setShowInsertVariable(true, (List)VariableFilterUtils.DEFAULT_INTERACTIVE_RESOURCE_FILTERS, null);
        HashMap<String, IStringVariable> variables = new HashMap<String, IStringVariable>();
        variables.putAll(this.getSourceFileVariables());
        pathInput.getValidator().setVariableResolver(new VariableText2(variables));
        this.workingDirectoryControl = pathInput;
        this.resolvedWorkingDirectoryResourceValue = pathInput.getValidator().getWorkspaceResourceObservable();
        this.resolvedWorkingDirectoryResourceValue.addValueChangeListener((IValueChangeListener)this);
        return pathInput;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.docmlet.base/main/WorkingDirectory.path", WORKING_DIRECTORY_DEFAULT_VALUE);
    }

    protected void addBindings(DataBindingContext dbc) {
        dbc.bindValue(this.workingDirectoryControl.getObservable(), this.workingDirectoryValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new UpdateableErrorValidator((IValidator)this.workingDirectoryControl.getValidator())), null);
    }

    protected void doInitialize(ILaunchConfiguration configuration) {
        this.workingDirectoryValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.docmlet.base/main/WorkingDirectory.path", WORKING_DIRECTORY_DEFAULT_VALUE));
    }

    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.statet.docmlet.base/main/WorkingDirectory.path", (String)this.workingDirectoryValue.getValue());
    }

    private class StepItem
    implements DocProcessingConfigStepTab.Listener {
        private final DocProcessingConfigStepTab tab;
        private Button enabledControl;
        private Label infoControl;

        public StepItem(DocProcessingConfigStepTab tab) {
            this.tab = tab;
            tab.addListener(this);
        }

        private void updateInfo() {
            if (!UIAccess.isOkToUse((Control)DocProcessingConfigMainTab.this.getControl())) {
                return;
            }
            this.enabledControl.setSelection(this.tab.isEnabled());
            this.infoControl.setText(this.tab.getInfo());
        }

        @Override
        public void changed(DocProcessingConfigStepTab source) {
            this.updateInfo();
        }
    }
}

