/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.yaml.ui.editors;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.IssueTypeSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.yaml.core.model.YamlModel;
import org.eclipse.statet.yaml.core.source.doc.YamlDocumentSetupParticipant;
import org.eclipse.statet.yaml.ui.editors.YamlEditorBuild;

@NonNullByDefault
public class YamlDocumentProvider
extends SourceDocumentProvider<SourceUnit>
implements Disposable {
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable SettingsChangeNotifier.ChangeListener editorPrefListener;
    private boolean handleTemporaryProblems;

    public YamlDocumentProvider() {
        super("Yaml", (PartitionerDocumentSetupParticipant)new YamlDocumentSetupParticipant(), YamlEditorBuild.YAML_ISSUE_TYPE_SET);
        SettingsChangeNotifier.ChangeListener editorPrefListener;
        this.editorPrefListener = editorPrefListener = new SettingsChangeNotifier.ChangeListener(){

            public void settingsChanged(Set<String> groupIds) {
                if (groupIds.contains("Yaml/editor/build")) {
                    YamlDocumentProvider.this.updateEditorPrefs();
                }
            }
        };
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener(editorPrefListener);
        PreferenceAccess access = EPreferences.getInstancePrefs();
        this.handleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)YamlEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
    }

    public void dispose() {
        SettingsChangeNotifier.ChangeListener editorPrefListener = this.editorPrefListener;
        if (editorPrefListener != null) {
            this.editorPrefListener = null;
            PreferencesUtil.getSettingsChangeNotifier().removeChangeListener(editorPrefListener);
        }
    }

    private void updateEditorPrefs() {
        PreferenceAccess access = EPreferences.getInstancePrefs();
        boolean newHandleTemporaryProblems = (Boolean)access.getPreferenceValue((Preference)YamlEditorBuild.PROBLEMCHECKING_ENABLED_PREF);
        if (this.handleTemporaryProblems != newHandleTemporaryProblems) {
            this.handleTemporaryProblems = newHandleTemporaryProblems;
            YamlModel.getYamlModelManager().refresh(Ltk.EDITOR_CONTEXT);
        }
    }

    protected IAnnotationModel createAnnotationModel(IFile file) {
        return new ThisAnnotationModel((IResource)file);
    }

    private class ThisAnnotationModel
    extends SourceAnnotationModel {
        public ThisAnnotationModel(IResource resource) {
            super(resource, YamlDocumentProvider.this.getIssueTypeSet());
        }

        protected boolean isHandlingTemporaryProblems(IssueTypeSet.ProblemCategory issueCategory) {
            return YamlDocumentProvider.this.handleTemporaryProblems;
        }
    }
}

