/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.emf.ui.forms.EFColors;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IDisposable;
import org.osgi.framework.BundleContext;

public class RtModelUIPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.rtm.base.ui";
    public static final String R_GRAPHICS_PERSPECTIVE_ID = "org.eclipse.statet.rtm.base.perspectives.RGraphics";
    public static final String R_TASK_EDITOR_CONTEXT_ID = "org.eclipse.statet.rtm.contexts.RTaskEditor";
    public static final String RUN_R_TASK_COMMAND_ID = "org.eclipse.statet.rtm.commands.RunRTask";
    public static final String OBJ_UNKOWN_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-unknown";
    public static final String OBJ_REXPR_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-expr";
    public static final String OBJ_DATAFRAME_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-dataframe";
    public static final String OBJ_COLUMN_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-column";
    public static final String OBJ_COLOR_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-color";
    public static final String OBJ_TEXT_TYPE_IMAGE_ID = "org.eclipse.statet.rtm.base.ui/obj/rtype-text";
    public static final boolean DEBUG = false;
    private static RtModelUIPlugin instance;
    private boolean started;
    private final List<IDisposable> disposables = new ArrayList<IDisposable>();
    private EFColors formColors;

    public static RtModelUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        RtModelUIPlugin plugin = RtModelUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            RtModelUIPlugin rtModelUIPlugin = this;
            synchronized (rtModelUIPlugin) {
                this.started = false;
            }
            if (this.formColors != null) {
                this.formColors.dispose();
                this.formColors = null;
            }
            for (IDisposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RtModelUIPlugin.log((IStatus)new Status(4, BUNDLE_ID, "An error occured when disposing the plug-in.", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(IDisposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        RtModelUIPlugin rtModelUIPlugin = this;
        synchronized (rtModelUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("The plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("The plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        reg.put(OBJ_UNKOWN_TYPE_IMAGE_ID, ImageDescriptor.getMissingImageDescriptor());
        util.register(OBJ_REXPR_TYPE_IMAGE_ID, "obj_16", "rtyped-expr.png");
        util.register(OBJ_DATAFRAME_TYPE_IMAGE_ID, "obj_16", "rtyped-dataframe.png");
        util.register(OBJ_COLUMN_TYPE_IMAGE_ID, "obj_16", "rtyped-column.png");
        util.register(OBJ_COLOR_TYPE_IMAGE_ID, "obj_16", "rtyped-color.png");
        util.register(OBJ_TEXT_TYPE_IMAGE_ID, "obj_16", "rtyped-text.png");
    }

    public EFColors getFormColors(Display display) {
        if (this.formColors == null) {
            if (!this.started) {
                throw new IllegalStateException("The plug-in is not started.");
            }
            this.formColors = new EFColors(display);
            this.formColors.markShared();
        }
        return this.formColors;
    }
}

