/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.graphics;

import java.util.List;
import org.eclipse.statet.ecommons.graphics.core.ColorAlphaDef;
import org.eclipse.statet.ecommons.graphics.core.ColorDef;
import org.eclipse.statet.ecommons.graphics.core.HSVColorDef;
import org.eclipse.statet.ecommons.ui.components.ColorPalette;
import org.eclipse.statet.ecommons.ui.components.DoubleText;
import org.eclipse.statet.ecommons.ui.components.HSVSelector;
import org.eclipse.statet.ecommons.ui.components.IObjValueListener;
import org.eclipse.statet.ecommons.ui.components.IntText;
import org.eclipse.statet.ecommons.ui.components.ObjValueEvent;
import org.eclipse.statet.ecommons.ui.components.RGBSelector;
import org.eclipse.statet.ecommons.ui.dialogs.ToolPopup;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.r.core.model.RGraphicFunctions;
import org.eclipse.statet.r.ui.graphics.RAlphaChooser;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RColorChooser
extends ToolPopup {
    private static final String R_COLORS = "RColors";
    private static final String R_PALETTE = "RPalette";
    private static final String RGB = "RGB";
    private static final String HSV = "HSV";
    private ColorDef fInitialValue;
    private Color fInitialSWTColor;
    private ColorDef fCurrentValue;
    private Color fCurrentSWTColor;
    private Composite fStatusControl;

    public static void drawPreview(GC gc, int x, int y, int width, int height, Color color) {
        if (color != null) {
            gc.setBackground(color);
            gc.fillRectangle(x, y, width + 1, height + 1);
        }
    }

    public static Color createPreviewColor(ColorDef colorDef) {
        return new Color(colorDef.getRed(), colorDef.getGreen(), colorDef.getBlue());
    }

    private static final int[] safeRGBIntArray(ColorDef color) {
        int[] nArray = new int[3];
        nArray[0] = 255;
        int[] rgb = nArray;
        if (color != null) {
            rgb[0] = color.getRed();
            rgb[1] = color.getGreen();
            rgb[2] = color.getBlue();
        }
        return rgb;
    }

    private static final double[] safeHSVDoubleArray(HSVColorDef color) {
        double[] hsv = new double[]{0.0, 1.0, 1.0};
        if (color != null) {
            hsv[0] = color.getHue();
            hsv[1] = color.getSaturation();
            hsv[2] = color.getValue();
        }
        return hsv;
    }

    public void open(Shell parent, Rectangle position, ColorDef initialValue) {
        this.fInitialValue = initialValue;
        this.doSetValue(initialValue != null ? initialValue : (ColorDef)RGraphicFunctions.DEFAULT.colorsMap.get("black"));
        super.open(parent, position);
    }

    protected void addTabs(CTabFolder tabFolder) {
        new PaletteTab(R_COLORS, "R Colors", "Definition by R color names", RGraphicFunctions.DEFAULT.colorsList);
        new RGBTab();
        new HSVTab();
        new PaletteTab(R_PALETTE, "R Palette", "Definition by R palette index", RGraphicFunctions.DEFAULT.defaultPalette);
        new RAlphaChooser.AlphaTab(this, "+ Alpha", "Add transparency by Alpha [0, 1]"){

            @Override
            protected void setValue(Float value) {
                RColorChooser.this.doSetAlphaValue(value);
            }

            @Override
            protected Float getValue() {
                return RColorChooser.this.doGetAlphaValue();
            }

            @Override
            protected ColorDef getBaseColor() {
                return RColorChooser.this.doGetColorValue();
            }
        };
    }

    protected ToolPopup.ToolTab getBestTab() {
        if (this.fCurrentValue.getType() == "hsv") {
            return this.getTab(HSV);
        }
        if (this.fCurrentValue.getType() == "rgb-rcolors") {
            return this.getTab(R_COLORS);
        }
        if (this.fCurrentValue.getType() == "rgb-rpalette") {
            return this.getTab(R_PALETTE);
        }
        return this.getTab(RGB);
    }

    protected void addStatusControls(Composite composite) {
        this.fStatusControl = new ToolPopup.PreviewCanvas(composite){

            protected void drawPreview(GC gc, int idx, int x, int y, int width, int height) {
                Color color = null;
                boolean alpha = false;
                switch (idx) {
                    case 0: {
                        if (RColorChooser.this.fInitialValue == null) break;
                        alpha = RColorChooser.this.fInitialValue instanceof ColorAlphaDef;
                        if (RColorChooser.this.fInitialSWTColor == null) {
                            RColorChooser.this.fInitialSWTColor = alpha ? RAlphaChooser.createPreviewColor(((ColorAlphaDef)RColorChooser.this.fInitialValue).getAlpha255(), RColorChooser.this.fInitialValue) : RColorChooser.createPreviewColor(RColorChooser.this.fInitialValue);
                        }
                        color = RColorChooser.this.fInitialSWTColor;
                        break;
                    }
                    case 1: {
                        if (RColorChooser.this.fCurrentValue == null) break;
                        alpha = RColorChooser.this.fCurrentValue instanceof ColorAlphaDef;
                        if (RColorChooser.this.fCurrentSWTColor == null) {
                            RColorChooser.this.fCurrentSWTColor = alpha ? RAlphaChooser.createPreviewColor(((ColorAlphaDef)RColorChooser.this.fCurrentValue).getAlpha255(), RColorChooser.this.fCurrentValue) : RColorChooser.createPreviewColor(RColorChooser.this.fCurrentValue);
                        }
                        color = RColorChooser.this.fCurrentSWTColor;
                        break;
                    }
                }
                if (alpha) {
                    RAlphaChooser.drawPreview(gc, x, y, width, height, color);
                } else {
                    RColorChooser.drawPreview(gc, x, y, width, height, color);
                }
            }
        };
        this.updateStatus();
    }

    private void doSetColorValue(ColorDef value) {
        Float oldAlpha = this.doGetAlphaValue();
        this.doSetValue((ColorDef)(oldAlpha.floatValue() != 1.0f ? new ColorAlphaDef(value, oldAlpha.floatValue()) : value));
    }

    private void doSetAlphaValue(Float value) {
        ColorDef oldValue = this.doGetColorValue();
        this.doSetValue((ColorDef)(value.floatValue() == 1.0f ? oldValue : new ColorAlphaDef(oldValue, value.floatValue())));
    }

    private void doSetValue(ColorDef value) {
        if (value == null || value == this.fCurrentValue) {
            return;
        }
        if (this.fCurrentSWTColor != null && !value.equals((Object)this.fCurrentValue)) {
            this.fCurrentSWTColor = null;
        }
        this.fCurrentValue = value;
        if (this.fStatusControl != null) {
            this.updateStatus();
        }
    }

    protected void updateStatus() {
        StringBuilder sb = new StringBuilder();
        sb.append("Previous: ");
        sb.append(this.fInitialValue != null ? this.fInitialValue.toString() : "-");
        sb.append("\n");
        sb.append("Current: ");
        sb.append(this.fCurrentValue.toString());
        this.fStatusControl.setToolTipText(sb.toString());
        this.fStatusControl.redraw();
    }

    private ColorDef doGetColorValue() {
        if (this.fCurrentValue instanceof ColorAlphaDef) {
            return ((ColorAlphaDef)this.fCurrentValue).getRef();
        }
        return this.fCurrentValue;
    }

    private Float doGetAlphaValue() {
        if (this.fCurrentValue instanceof ColorAlphaDef) {
            return Float.valueOf(((ColorAlphaDef)this.fCurrentValue).getAlpha());
        }
        return Float.valueOf(1.0f);
    }

    public ColorDef getValue() {
        return this.fCurrentValue;
    }

    protected void onDispose() {
        this.fStatusControl = null;
        super.onDispose();
    }

    protected class HSVTab
    extends ToolPopup.ToolTab {
        private final HSVSelector fSelector;
        private final DoubleText[] fHSVText;
        private int fTextChange;

        HSVTab() {
            super(RColorChooser.HSV, (ToolPopup)RColorChooser.this, RColorChooser.HSV, "Definition by Hue-Saturation-Value");
            this.fHSVText = new DoubleText[3];
            Composite composite = this.create();
            composite.setLayout((Layout)LayoutUtils.newTabGrid((int)3));
            this.fSelector = new HSVSelector(composite, composite.getBackground());
            this.fSelector.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
            String[] fieldLabels = new String[]{"&Hue:", "&Saturation:", "&Value:"};
            IObjValueListener<Double> textListener = new IObjValueListener<Double>(){

                public void valueAboutToChange(ObjValueEvent<Double> event) {
                }

                public void valueChanged(ObjValueEvent<Double> event) {
                    if (event.newValue == null) {
                        return;
                    }
                    HSVColorDef oldValue = HSVTab.this.fSelector.getValue(0);
                    double[] hsv = RColorChooser.safeHSVDoubleArray(oldValue);
                    ++HSVTab.this.fTextChange;
                    try {
                        try {
                            hsv[HSVTab.this.indexOf((DoubleText)((DoubleText)event.getSource()))] = (Double)event.newValue;
                            HSVColorDef value = new HSVColorDef((float)hsv[0], (float)hsv[1], (float)hsv[2]);
                            if (!value.equals((Object)oldValue)) {
                                HSVTab.this.fSelector.setValue(0, (ColorDef)value);
                                RColorChooser.this.doSetColorValue((ColorDef)value);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            --HSVTab.this.fTextChange;
                        }
                    }
                    finally {
                        --HSVTab.this.fTextChange;
                    }
                }
            };
            int i = 0;
            while (i < 3) {
                Label label = new Label(composite, 0);
                label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
                label.setText(fieldLabels[i]);
                DoubleText text = new DoubleText(composite, 2048);
                GridData gd = new GridData(4, 0x1000000, false, false);
                gd.widthHint = LayoutUtils.hintWidth((Text)text.getControl(), (int)6);
                text.getControl().setLayoutData((Object)gd);
                text.addValueListener((IObjValueListener)textListener);
                text.setIncrement(0.001);
                text.setMinMax(0.0, 1.0);
                text.setFormat(DoubleText.createFormat((int)3));
                this.fHSVText[i] = text;
                ++i;
            }
            Label label = new Label(composite, 0);
            GridData gd = new GridData(4, 4, false, true, 2, 1);
            label.setLayoutData((Object)gd);
            this.fSelector.addValueListener((IObjValueListener)new IObjValueListener<ColorDef>(){

                public void valueAboutToChange(ObjValueEvent<ColorDef> event) {
                }

                public void valueChanged(ObjValueEvent<ColorDef> event) {
                    if (HSVTab.this.fTextChange == 0) {
                        HSVColorDef value = (HSVColorDef)event.newValue;
                        Double[] hsv = new Double[]{value.getHue(), value.getSaturation(), value.getValue()};
                        int i = 0;
                        while (i < 3) {
                            HSVTab.this.fHSVText[i].setValue(0, hsv[i]);
                            ++i;
                        }
                        RColorChooser.this.doSetColorValue((ColorDef)value);
                    }
                }
            });
        }

        private int indexOf(DoubleText source) {
            int i = 0;
            while (i < 3) {
                if (this.fHSVText[i] == source) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected void activated() {
            ColorDef value = RColorChooser.this.doGetColorValue();
            this.fSelector.setValue(0, value);
        }
    }

    protected class PaletteTab
    extends ToolPopup.ToolTab {
        ColorPalette fPalette;

        PaletteTab(String key, String name, String tooltip, List<? extends ColorDef> colors) {
            super(key, (ToolPopup)RColorChooser.this, name, "Palette of Named Colors in R");
            Composite composite = this.create();
            composite.setLayout((Layout)LayoutUtils.newTabGrid((int)1));
            this.fPalette = new ColorPalette(composite, composite.getBackground());
            this.fPalette.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fPalette.setColors(colors);
            this.fPalette.addValueListener((IObjValueListener)new IObjValueListener<ColorDef>(){

                public void valueAboutToChange(ObjValueEvent<ColorDef> event) {
                }

                public void valueChanged(ObjValueEvent<ColorDef> event) {
                    if (event.newValue == null) {
                        return;
                    }
                    RColorChooser.this.doSetColorValue((ColorDef)event.newValue);
                    if ((event.flags & 1) != 0) {
                        PaletteTab.this.performOK();
                    }
                }
            });
        }

        protected void activated() {
            ColorDef value = RColorChooser.this.doGetColorValue();
            this.fPalette.setValue(0, value);
            ColorDef paletteColor = this.fPalette.getValue(0);
            if (paletteColor != null) {
                RColorChooser.this.doSetColorValue(paletteColor);
            }
        }
    }

    protected class RGBTab
    extends ToolPopup.ToolTab {
        private final RGBSelector fSelector;
        private final Button[] fRGBButton;
        private final IntText[] fRGBText;
        private Text fHexText;
        private int fTextChange;

        RGBTab() {
            super(RColorChooser.RGB, (ToolPopup)RColorChooser.this, RColorChooser.RGB, "Definition by Red-Green-Blue");
            this.fRGBButton = new Button[3];
            this.fRGBText = new IntText[3];
            Composite composite = this.create();
            composite.setLayout((Layout)LayoutUtils.newTabGrid((int)4));
            this.fSelector = new RGBSelector(composite, composite.getBackground());
            this.fSelector.setLayoutData((Object)new GridData(4, 4, true, true, 1, 5));
            String[] fieldLabels = new String[]{"&Red", "&Green", "&Blue"};
            Listener buttonListener = new Listener(){

                public void handleEvent(Event event) {
                    RGBTab.this.fSelector.setPrimary(RGBTab.this.indexOf((Button)event.widget));
                }
            };
            IObjValueListener<Integer> textListener = new IObjValueListener<Integer>(){

                public void valueAboutToChange(ObjValueEvent<Integer> event) {
                }

                public void valueChanged(ObjValueEvent<Integer> event) {
                    if (event.newValue == null) {
                        return;
                    }
                    ColorDef oldColor = RGBTab.this.fSelector.getValue(0);
                    int[] rgb = RColorChooser.safeRGBIntArray(oldColor);
                    ++RGBTab.this.fTextChange;
                    try {
                        try {
                            rgb[RGBTab.this.indexOf((IntText)((IntText)event.getSource()))] = (Integer)event.newValue;
                            ColorDef newColor = new ColorDef(rgb[0], rgb[1], rgb[2]);
                            if (!newColor.equals((Object)oldColor)) {
                                RGBTab.this.fSelector.setValue(0, newColor);
                                RColorChooser.this.doSetColorValue(newColor);
                            }
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            --RGBTab.this.fTextChange;
                        }
                    }
                    finally {
                        --RGBTab.this.fTextChange;
                    }
                }
            };
            int i = 0;
            while (i < 3) {
                Button button = new Button(composite, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
                button.setText(fieldLabels[i]);
                button.addListener(13, buttonListener);
                this.fRGBButton[i] = button;
                IntText text = new IntText(composite, 2048);
                GridData gd = new GridData(4, 0x1000000, false, false);
                gd.widthHint = LayoutUtils.hintWidth((Text)text.getControl(), (int)4);
                text.getControl().setLayoutData((Object)gd);
                text.addValueListener((IObjValueListener)textListener);
                text.setIncrement(1);
                text.setMinMax(0, 255);
                this.fRGBText[i] = text;
                ++i;
            }
            this.fRGBButton[0].setSelection(true);
            Label label = new Label(composite, 0);
            GridData gd = new GridData(4, 4, false, true, 3, 1);
            label.setLayoutData((Object)gd);
            label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, true, 1, 1));
            label.setText("Hex:");
            Text text = new Text(composite, 18436);
            GridData gd2 = new GridData(4, 0x1000000, true, false, 2, 1);
            gd2.widthHint = LayoutUtils.hintWidth((Text)text, (int)9);
            text.setLayoutData((Object)gd2);
            text.addListener(24, new Listener(){

                public void handleEvent(Event event) {
                    ColorDef newColor;
                    String s = RGBTab.this.fHexText.getText();
                    if (s.length() == 7 && s.charAt(0) == '#' && (newColor = ColorDef.parseRGBHex((String)s.substring(1))) != null && !newColor.equals((Object)RGBTab.this.fSelector.getValue(0))) {
                        RGBTab.this.fSelector.setValue(0, newColor);
                    }
                }
            });
            this.fHexText = text;
            this.fSelector.addValueListener((IObjValueListener)new IObjValueListener<ColorDef>(){

                public void valueAboutToChange(ObjValueEvent<ColorDef> event) {
                }

                public void valueChanged(ObjValueEvent<ColorDef> event) {
                    ColorDef value = (ColorDef)event.newValue;
                    if (RGBTab.this.fTextChange == 0) {
                        Integer[] rgb = new Integer[]{value.getRed(), value.getGreen(), value.getBlue()};
                        int i = 0;
                        while (i < 3) {
                            RGBTab.this.fRGBText[i].setValue(0, rgb[i]);
                            ++i;
                        }
                        RColorChooser.this.doSetColorValue(value);
                    }
                    StringBuilder sb = new StringBuilder(7);
                    sb.append('#');
                    value.printRGBHex(sb);
                    Point selection = RGBTab.this.fHexText.getSelection();
                    RGBTab.this.fHexText.setText(sb.toString());
                    RGBTab.this.fHexText.setSelection(selection);
                }
            });
        }

        private int indexOf(IntText source) {
            int i = 0;
            while (i < 3) {
                if (this.fRGBText[i] == source) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private int indexOf(Button source) {
            int i = 0;
            while (i < 3) {
                if (this.fRGBButton[i] == source) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        protected void activated() {
            ColorDef value = RColorChooser.this.doGetColorValue();
            this.fSelector.setValue(0, value);
        }
    }
}

