/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpRCodeScanner;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpWorkbenchStyle;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.ui.NicoUITools;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.renv.IREnvManager;
import org.eclipse.statet.rhelp.core.RHelpPage;
import org.eclipse.statet.rhelp.core.http.RunExamplesRunnable;
import org.eclipse.statet.rhelp.core.http.RunResult;
import org.eclipse.statet.rhelp.core.http.ee8.HttpForwardHandler;
import org.eclipse.statet.rhelp.core.http.ee8.RHelpHttpServlet;
import org.eclipse.statet.rhelp.core.http.ee8.jetty.JettyForwardHandler;
import org.eclipse.statet.rhelp.core.http.ee8.jetty.JettyRHelpUtils;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.ide.IDE;

@NonNullByDefault
public class RHelpUIServlet
extends RHelpHttpServlet
implements IPropertyChangeListener,
SettingsChangeNotifier.ChangeListener {
    private static final long serialVersionUID = 1L;
    static final String STYLE_PARAM = "style";
    static final String HOVER_STYLE = "hover";
    private volatile @Nullable String cssStyle;
    private RHelpRCodeScanner rCodeScanner;
    private final Runnable updateStyles = this::updateStyles;
    private boolean updateStyleScheduled;
    private static String infoStepList = "<ol class=\"c2\">";
    private static String infoStepCreateREnvironment = "<li>Open the preference page R &gt; R Environments, create an environment and mark it as default.</li>";
    private static String infoStepConfigureAndLaunchConsole = "<li>Configure and launch a console for this R environment.</li>";
    private static String infoStepLaunchConsole = "<li>Launch a console for this R environment.</li>";
    private static String infoStepIndexInConsole = "<li>By default the indexer is run automatically when the console is started.<br/>If the automatic indexing is disabled, execute the command 'Update R environment index'.</li>";
    private static String infoRefreshButton = "<p><button onClick=\"window.location.reload();\">Refresh Page</button></p>";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.init(RCore.getRHelpManager(), JettyRHelpUtils.newResourceHandler((ServletContext)config.getServletContext()), (HttpForwardHandler)new JettyForwardHandler());
        this.rCodeScanner = new RHelpRCodeScanner(RUIPlugin.getInstance().getEditorPreferenceStore());
        EditorsUI.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().addListener((IPropertyChangeListener)this);
        PreferencesUtil.getSettingsChangeNotifier().addChangeListener((SettingsChangeNotifier.ChangeListener)this);
        this.updateStyleScheduled = true;
        Display.getDefault().syncExec(this.updateStyles);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (!this.updateStyleScheduled && (event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewBackgroundColor") || event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewColor") || event.getProperty().equals("org.eclipse.statet.workbench.themes.DocViewFont") || event.getProperty().equals("org.eclipse.jface.dialogfont") || event.getProperty().equals("HYPERLINK_COLOR") || event.getProperty().equals("ACTIVE_HYPERLINK_COLOR") || event.getProperty().equals("searchResultIndicationColor"))) {
            this.updateStyleScheduled = true;
            Display.getDefault().asyncExec(this.updateStyles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void settingsChanged(Set<String> groupIds) {
        if (groupIds.contains("r.editor/textstyles") || groupIds.contains("r.editor/identifiergroups")) {
            HashMap<String, Object> options = new HashMap<String, Object>();
            RHelpRCodeScanner rHelpRCodeScanner = this.rCodeScanner;
            synchronized (rHelpRCodeScanner) {
                this.rCodeScanner.handleSettingsChanged(groupIds, options);
            }
        }
    }

    public void destroy() {
        super.destroy();
        IPreferenceStore preferenceStore = EditorsUI.getPreferenceStore();
        if (preferenceStore != null) {
            preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        JFaceResources.getColorRegistry().removeListener((IPropertyChangeListener)this);
        PreferencesUtil.getSettingsChangeNotifier().removeChangeListener((SettingsChangeNotifier.ChangeListener)this);
    }

    protected boolean getShowInternal() {
        return (Boolean)EPreferences.getInstancePrefs().getPreferenceValue(RHelpPreferences.SHOW_INTERNAL_ENABLED_PREF);
    }

    protected boolean canOpenFile(String ext) {
        return true;
    }

    protected void doOpenFile(Path file) {
        try {
            final IFileStore fileStore = EFS.getLocalFileSystem().getStore(file.toUri());
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPage page = UIAccess.getActiveWorkbenchPage((boolean)true);
                    try {
                        IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doRunExamples(RHelpPage helpPage, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        RunExamplesRunnable runnable = new RunExamplesRunnable(helpPage);
        REnv rEnv = helpPage.getPackage().getREnv();
        class Context {
            final IWorkbenchPage workbenchPage;
            final @Nullable IWorkbenchPart workbenchPart;
            final @Nullable RTool rTool;

            public Context(@Nullable IWorkbenchPage workbenchPage, @Nullable IWorkbenchPart workbenchPart, RTool rTool) {
                this.workbenchPage = workbenchPage;
                this.workbenchPart = workbenchPart;
                this.rTool = rTool;
            }
        }
        @Nullable Context context = (Context)UIAccess.syncExecGet(() -> {
            IWorkbenchPage uiPage;
            IWorkbenchPart uiPart = UIAccess.getActiveWorkbenchPart((boolean)true);
            IWorkbenchPage iWorkbenchPage = uiPage = uiPart != null ? uiPart.getSite().getPage() : UIAccess.getActiveWorkbenchPage((boolean)true);
            if (uiPage == null) {
                return null;
            }
            return new Context(uiPage, uiPart, (RTool)NicoUITools.findTool(tool -> {
                RTool rToolCandicate;
                if (runnable.canRunIn(tool) && (rToolCandicate = (RTool)tool).getREnv() == rEnv && !rToolCandicate.isTerminated()) {
                    return rToolCandicate;
                }
                return null;
            }, (IWorkbenchPart)uiPart, (IWorkbenchPage)uiPage));
        });
        if (context != null && context.rTool != null) {
            RTool rTool = (RTool)ObjectUtils.nonNullAssert((Object)context.rTool);
            runnable.changed(272, (Tool)rTool);
            if (rTool.getQueue().add((ToolRunnable)runnable).getSeverity() == 0) {
                NIConsole console = NicoUITools.getConsole((Tool)rTool);
                if (console != null) {
                    NicoUITools.showConsole((NIConsole)console, (IWorkbenchPage)context.workbenchPage, (boolean)false);
                }
                try {
                    RunResult result = runnable.waitForResult();
                    if (result != null) {
                        this.servePageExamples(helpPage, result, req, resp);
                        return;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                resp.setStatus(504);
                return;
            }
        }
        RHelpHttpServlet.ErrorData errorData = new RHelpHttpServlet.ErrorData(0, 503, "Examples of R Environment '" + rEnv.getName() + "'");
        errorData.getMessageBuilder().append("No session of R is available to run the examples of the R environment '").append(rEnv.getName()).append("'.");
        errorData.setFixInfos("<p>Launch a console to enable running of examples.</p>" + infoStepList + infoStepLaunchConsole + "</ol>" + infoRefreshButton);
        this.sendError(errorData, req, resp);
    }

    protected void enrichErrorData(RHelpHttpServlet.ErrorData errorData, HttpServletRequest req) throws IOException {
        super.enrichErrorData(errorData, req);
        if (((Object)((Object)this)).getClass() != Browse.class) {
            return;
        }
        switch (errorData.getProblemCode()) {
            case 1: {
                String rEnvId = RHelpUIServlet.getREnvId((HttpServletRequest)req);
                if (rEnvId.startsWith("default-")) {
                    IREnvManager rEnvManager = RCore.getREnvManager();
                    if (rEnvManager.list().isEmpty()) {
                        errorData.setFixInfos("<p>Configure an R environment and get it indexed to enable the R help support.</p>" + infoStepList + infoStepCreateREnvironment + infoStepConfigureAndLaunchConsole + infoStepIndexInConsole + "</ol>" + infoRefreshButton);
                    } else {
                        errorData.setFixInfos("<p>Configure an R environment as default or select a specific R environment.</p>" + infoRefreshButton);
                    }
                } else {
                    errorData.setFixInfos("<p>Select a valid R environment.</p>");
                }
                return;
            }
            case 2: {
                errorData.setFixInfos("<p>Launch the console and get the R environment indexed to enable the R help support.</p>" + infoStepList + infoStepLaunchConsole + infoStepIndexInConsole + "</ol>" + infoRefreshButton);
                return;
            }
        }
    }

    private void updateStyles() {
        this.updateStyleScheduled = false;
        StringBuilder sb = new StringBuilder(1024);
        this.collectCss(sb);
        sb.append(".header { display: none; }");
        this.cssStyle = sb.toString();
    }

    protected void collectCss(StringBuilder sb) {
    }

    protected void customizeCss(PrintWriter writer) {
        writer.print(this.cssStyle);
    }

    protected void customizePageHtmlHeader(HttpServletRequest req, PrintWriter writer) {
        this.customizeHtmlHeader(req, writer, true);
    }

    protected void customizeIndexHtmlHeader(HttpServletRequest req, PrintWriter writer) {
        this.customizeHtmlHeader(req, writer, false);
    }

    protected void customizeHtmlHeader(HttpServletRequest req, PrintWriter writer, boolean page) {
        writer.println("<script type=\"text/javascript\">/* <![CDATA[ */");
        writer.println("function keyNavHandler(event) {");
        writer.println("if (!event) event= window.event;");
        writer.println("if (event.which) { key= event.which } else if (event.keyCode) { key= event.keyCode };");
        writer.println("if (!event.ctrlKey && !event.altKey) { var anchor= 0;");
        if (page) {
            writer.println("if (key == 68) anchor= \"#description\"; else if (key == 85) anchor= \"#usage\"; else if (key == 65) anchor= \"#arguments\"; else if (key == 73) anchor= \"#details\"; else if (key == 86) anchor= \"#value\"; else if (key == 79) anchor= \"#authors\"; else if (key == 82) anchor= \"#references\"; else if (key == 69) anchor= \"#examples\"; else if (key == 83) anchor= \"#seealso\";");
        } else {
            writer.println("if (key >= 65 && key <= 90) anchor= \"#idx\"+String.fromCharCode(key+32);");
        }
        writer.println("if (anchor) { window.location.hash= anchor; event.cancelBubble= true; return false; }");
        writer.println("} return true; }");
        writer.println("document.onkeydown= keyNavHandler;");
        writer.println("/* ]]> */</script>");
        if (HOVER_STYLE.equals(req.getParameter(STYLE_PARAM))) {
            writer.println("<style type=\"text/css\">body { overflow: hidden; }</style>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printRCode(PrintWriter writer, String html) {
        RHelpRCodeScanner rHelpRCodeScanner = this.rCodeScanner;
        synchronized (rHelpRCodeScanner) {
            IToken token;
            this.rCodeScanner.setHtml(html);
            writer.write("<span style=\"");
            writer.write(this.rCodeScanner.getRootStyle());
            writer.write("\">");
            int currentIdx = 0;
            while (!(token = this.rCodeScanner.nextToken()).isEOF()) {
                String data = (String)token.getData();
                if (data == null) continue;
                int tokenIdx = this.rCodeScanner.getTokenOffset();
                if (tokenIdx > currentIdx) {
                    writer.write(html, currentIdx, tokenIdx - currentIdx);
                }
                writer.write("<span style=\"");
                writer.write(data);
                writer.write("\">");
                writer.write(html, tokenIdx, this.rCodeScanner.getTokenLength());
                writer.write("</span>");
                currentIdx = tokenIdx + this.rCodeScanner.getTokenLength();
            }
            writer.write(html, currentIdx, html.length() - currentIdx);
            writer.write("</span>");
        }
    }

    public static class Browse
    extends RHelpUIServlet {
        private static final long serialVersionUID = 1L;

        protected boolean canRunExamples() {
            return true;
        }

        @Override
        protected void collectCss(StringBuilder sb) {
            RHelpWorkbenchStyle style = new RHelpWorkbenchStyle();
            sb.append("body { ");
            style.appendFont(sb, style.getDocFontDescr());
            sb.append("}\n");
            sb.append("@media only screen {\n");
            sb.append("html {");
            style.appendRootColors(sb);
            sb.append("}\n");
            sb.append("body { margin: ");
            sb.append(LayoutUtils.defaultVSpacing()).append("px ");
            sb.append(LayoutUtils.defaultHSpacing()).append("px; ");
            style.appendScreenColors(sb);
            sb.append("}\n");
            style.appendLinkDefinitions(sb);
            style.appendDialogButtonDefinitions(sb);
            sb.append("div.toc { display: inline; float: right; border: 1px solid ");
            RHelpWorkbenchStyle.appendCssColor(sb, style.getDocBorderColorRGB()).append("; ");
            sb.append("}\n");
            sb.append("div.toc a, div.toc a:visited { color: ");
            RHelpWorkbenchStyle.appendCssColor(sb, style.getDocForegroundColorRGB()).append("; ");
            sb.append("; }\n");
            sb.append("span.mnemonic, div.toc a.mnemonic { text-decoration: underline; }\n");
            sb.append("hr { border: 0; height: 1px; background: ");
            RHelpWorkbenchStyle.appendCssColor(sb, style.getDocBorderColorRGB()).append("; ");
            sb.append("}\n");
            sb.append("body.error { ");
            style.appendFont(sb, style.getDialogFontDescr());
            style.appendDialogColors(sb);
            sb.append("}\n");
            sb.append("}\n");
            style.appendMatchColors(sb);
            super.collectCss(sb);
        }
    }

    public static class Info
    extends RHelpUIServlet {
        private static final long serialVersionUID = 1L;

        @Override
        protected void collectCss(StringBuilder sb) {
            RHelpWorkbenchStyle style = new RHelpWorkbenchStyle();
            int vIndent = Math.max(1, LayoutUtils.defaultVSpacing() / 4);
            int hIndent = Math.max(3, LayoutUtils.defaultHSpacing() / 2);
            sb.append("html { ");
            style.appendFont(sb, style.getDialogFontDescr());
            style.appendRootColors(sb);
            sb.append("}\n");
            sb.append("body { ");
            sb.append("margin: 0 ").append(hIndent).append("px ").append(vIndent).append("px; ");
            style.appendScreenColors(sb);
            sb.append("}\n");
            style.appendLinkDefinitions(sb);
            style.appendDialogButtonDefinitions(sb);
            sb.append("h2, h3#description { display: none; }\n");
            sb.append("h3 { font-size: 90%; margin-bottom: 0.4em; }\n");
            sb.append("p, pre { margin-top: 0.4em; margin-bottom: 0.4em; }\n");
            sb.append("hr { visibility: hidden; }\n");
            sb.append("body.error { ");
            style.appendDialogColors(sb);
            sb.append("}\n");
            sb.append("body.error button {visibility: hidden; }\n");
            super.collectCss(sb);
        }
    }
}

