/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.intable;

import java.util.function.Function;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.ecommons.ui.swt.ColorUtils;
import org.eclipse.statet.ecommons.waltable.config.AbstractRegistryConfiguration;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.LayoutSizeConfig;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.style.BasicStyle;
import org.eclipse.statet.ecommons.waltable.core.style.BorderStyle;
import org.eclipse.statet.ecommons.waltable.core.style.CellStyling;
import org.eclipse.statet.ecommons.waltable.core.style.GridStyling;
import org.eclipse.statet.ecommons.waltable.core.style.HorizontalAlignment;
import org.eclipse.statet.ecommons.waltable.core.style.VerticalAlignment;
import org.eclipse.statet.ecommons.waltable.core.swt.painters.GridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.freeze.IFreezeConfigAttributes;
import org.eclipse.statet.ecommons.waltable.grid.swt.CornerGridLineCellLayerPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.DiagCellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.LineBorderDecorator;
import org.eclipse.statet.ecommons.waltable.sort.swt.SortableHeaderTextPainter;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.intable.RTextPainter;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.editors.text.EditorsUI;

public class PresentationConfig
extends AbstractRegistryConfiguration
implements Disposable,
IPropertyChangeListener {
    private static PresentationConfig gInstance;
    private final Display display;
    private final Color headerGridColor;
    private final Color headerBackgroundColor;
    private final Color headerForegroundColor;
    private final Color bodyGridColor;
    private final Color bodyBackgroundColor;
    private final Color bodyEvenRowBackgroundColor;
    private final Color bodyOddRowBackgroundColor;
    private final Color bodyForegroundColor;
    private final Color headerSelectionBackgroundColor;
    private final Color headerSelectionForegroundColor;
    private final Color headerPlaceholderColor;
    private final Color headerFullSelectionBackgroundColor;
    private final Color headerFullSelectionForegroundColor;
    private final Color bodySelectionBackgroundColor;
    private final Color bodySelectionForegroundColor;
    private final Color bodyFreezeSeparatorColor;
    private final LayerPainter headerLayerPainter;
    private final LayerPainter headerLabelLayerPainter;
    private LayerCellPainter baseCellPainter;
    private LayerCellPainter headerCellPainter;
    private LayerCellPainter headerSortedCellPainter;
    private LayerCellPainter headerCornerCellPainter;
    private Font baseFont;
    private Font infoFont;
    private LayoutSizeConfig baseSizeConfig;
    private final CopyOnWriteIdentityListSet<Runnable> listeners = new CopyOnWriteIdentityListSet();

    public static PresentationConfig getInstance(Display display) {
        if (gInstance == null) {
            gInstance = new PresentationConfig(display);
            RUIPlugin.getInstance().registerPluginDisposable(gInstance);
        }
        return gInstance;
    }

    public PresentationConfig(Display display) {
        this.display = display;
        ColorRegistry colorRegistry = JFaceResources.getColorRegistry();
        this.headerGridColor = display.getSystemColor(16);
        this.headerBackgroundColor = display.getSystemColor(22);
        this.headerForegroundColor = display.getSystemColor(21);
        this.bodyGridColor = display.getSystemColor(15);
        this.bodyEvenRowBackgroundColor = this.bodyBackgroundColor = display.getSystemColor(25);
        this.bodyOddRowBackgroundColor = ColorUtils.blend((Color)display.getSystemColor(19), (Color)this.bodyEvenRowBackgroundColor, (float)0.2f);
        this.bodyForegroundColor = display.getSystemColor(24);
        this.headerSelectionBackgroundColor = ColorUtils.blend((Color)display.getSystemColor(26), (Color)this.headerBackgroundColor, (float)0.25f);
        this.headerSelectionForegroundColor = this.headerForegroundColor;
        this.headerPlaceholderColor = ColorUtils.blend((Color)this.bodyGridColor, (Color)this.headerBackgroundColor, (float)0.25f);
        this.headerFullSelectionBackgroundColor = ColorUtils.blend((Color)display.getSystemColor(26), (Color)display.getSystemColor(18), (float)0.25f);
        this.headerFullSelectionForegroundColor = display.getSystemColor(20);
        this.bodySelectionBackgroundColor = this.getSelectionBackgroundColor();
        this.bodySelectionForegroundColor = display.getSystemColor(27);
        this.bodyFreezeSeparatorColor = colorRegistry.get("DECORATIONS_COLOR");
        this.headerLayerPainter = new GridLineCellLayerPainter((Function)new GridStyling.ConfigGridLineColorSupplier("COLUMN_HEADER"));
        this.headerLabelLayerPainter = new CornerGridLineCellLayerPainter((Function)new GridStyling.ConfigGridLineColorSupplier("COLUMN_HEADER"));
        this.updateFonts();
        this.updateCellPainters();
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        fontRegistry.addListener((IPropertyChangeListener)this);
    }

    private Color getSelectionBackgroundColor() {
        RGB rgb;
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        if (!store.getBoolean("AbstractTextEditor.Color.SelectionBackground.SystemDefault") && (rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AbstractTextEditor.Color.SelectionBackground")) != null) {
            return new Color(rgb);
        }
        return this.display.getSystemColor(26);
    }

    public void dispose() {
        FontRegistry fontRegistry = JFaceResources.getFontRegistry();
        if (fontRegistry != null) {
            fontRegistry.removeListener((IPropertyChangeListener)this);
        }
    }

    private void updateFonts() {
        GC gc = new GC((Drawable)this.display);
        try {
            FontRegistry fontRegistry = JFaceResources.getFontRegistry();
            this.baseFont = fontRegistry.get("org.eclipse.statet.workbench.themes.TableFont");
            this.infoFont = fontRegistry.getItalic("org.eclipse.statet.workbench.themes.TableFont");
            gc.setFont(this.baseFont);
            FontMetrics fontMetrics = gc.getFontMetrics();
            int textHeight = fontMetrics.getHeight();
            int charWidth = (gc.textExtent((String)"1234567890.-120").x + 5) / 15;
            int textSpace = 3;
            this.baseSizeConfig = new LayoutSizeConfig(3, textHeight, charWidth);
        }
        finally {
            gc.dispose();
        }
    }

    private void updateCellPainters() {
        this.baseCellPainter = new LineBorderDecorator((LayerCellPainter)new RTextPainter(this.baseSizeConfig.getDefaultSpace()));
        this.headerCellPainter = new RTextPainter(this.baseSizeConfig.getDefaultSpace());
        this.headerSortedCellPainter = new SortableHeaderTextPainter((LayerCellPainter)new RTextPainter(this.baseSizeConfig.getDefaultSpace()), true, true);
        this.headerCornerCellPainter = new DiagCellPainter(this.headerGridColor);
    }

    public void propertyChange(PropertyChangeEvent event) {
        switch (event.getProperty()) {
            case "org.eclipse.statet.workbench.themes.TableFont": {
                this.updateFonts();
                this.updateCellPainters();
                this.notifyListeners();
                return;
            }
        }
    }

    public LayerPainter getHeaderLayerPainter() {
        return this.headerLayerPainter;
    }

    public LayerPainter getHeaderLabelLayerPainter() {
        return this.headerLabelLayerPainter;
    }

    public LayoutSizeConfig getBaseSizeConfig() {
        return this.baseSizeConfig;
    }

    public void configureRegistry(ConfigRegistry configRegistry) {
        BasicStyle cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.bodyBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.bodyForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyling.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.baseCellPainter);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle);
        configRegistry.registerAttribute(GridStyling.GRID_LINE_COLOR, (Object)this.bodyGridColor);
        configRegistry.registerAttribute(LayoutSizeConfig.CONFIG, (Object)this.baseSizeConfig);
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.CENTER);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyling.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "COLUMN_HEADER");
        configRegistry.registerAttribute(GridStyling.GRID_LINE_COLOR, (Object)this.headerGridColor, DisplayMode.NORMAL, "COLUMN_HEADER");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyling.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "COLUMN_HEADER_LABEL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "COLUMN_HEADER_LABEL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "CORNER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCornerCellPainter, DisplayMode.NORMAL, "CORNER");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyling.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ROW_HEADER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "ROW_HEADER");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.LEFT);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        cellStyle.setAttributeValue(CellStyling.CONTROL_FONT, (Object)this.infoFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "ROW_HEADER_LABEL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerCellPainter, DisplayMode.NORMAL, "ROW_HEADER_LABEL");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerPlaceholderColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerForegroundColor);
        cellStyle.setAttributeValue(CellStyling.HORIZONTAL_ALIGNMENT, (Object)HorizontalAlignment.RIGHT);
        cellStyle.setAttributeValue(CellStyling.VERTICAL_ALIGNMENT, (Object)VerticalAlignment.MIDDLE);
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, null);
        cellStyle.setAttributeValue(CellStyling.FONT, (Object)this.baseFont);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "HEADER_PLACEHOLDER");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.bodyEvenRowBackgroundColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "BODY_EVEN_ROW");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.bodyOddRowBackgroundColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "BODY_ODD_ROW");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.bodySelectionBackgroundColor);
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.bodySelectionForegroundColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED);
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.BORDER_STYLE, (Object)new BorderStyle(2, this.bodyForegroundColor, BorderStyle.LineStyle.SOLID, -1));
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.NORMAL, "SELECTION_ANCHOR");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "SELECTION_ANCHOR");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerSelectionForegroundColor);
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerSelectionBackgroundColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "COLUMN_HEADER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "CORNER");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "ROW_HEADER");
        cellStyle = new BasicStyle();
        cellStyle.setAttributeValue(CellStyling.FOREGROUND_COLOR, (Object)this.headerFullSelectionForegroundColor);
        cellStyle.setAttributeValue(CellStyling.BACKGROUND_COLOR, (Object)this.headerFullSelectionBackgroundColor);
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "COLUMN_HEADER_FULL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_STYLE, (Object)cellStyle, DisplayMode.SELECTED, "ROW_HEADER_FULL");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerSortedCellPainter, DisplayMode.NORMAL, "SORT_DOWN");
        configRegistry.registerAttribute(CellConfigAttributes.CELL_PAINTER, (Object)this.headerSortedCellPainter, DisplayMode.NORMAL, "SORT_UP");
        configRegistry.registerAttribute(IFreezeConfigAttributes.SEPARATOR_COLOR, (Object)this.bodyFreezeSeparatorColor);
    }

    public void addListener(Runnable listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(Runnable listener) {
        this.listeners.remove((Object)listener);
    }

    private void notifyListeners() {
        for (Runnable listener : this.listeners) {
            listener.run();
        }
    }
}

