/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SimpleCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.SourceProposal;
import org.eclipse.statet.r.core.source.util.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.swt.graphics.Point;

@NonNullByDefault
public class RSimpleCompletionProposal
extends SimpleCompletionProposal<RAssistInvocationContext> {
    public RSimpleCompletionProposal(SourceProposal.ProposalParameters<RAssistInvocationContext> parameters, String replacementString) {
        super(parameters, replacementString);
    }

    protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) {
        int end = Math.max(caretOffset, selection.x + selection.y);
        if (overwrite) {
            try {
                RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
                RHeuristicTokenScanner scanner = context.getRHeuristicTokenScanner();
                scanner.configure(context.getDocument());
                IRegion word = scanner.findRWord(end, false, true);
                if (word != null) {
                    return word.getOffset() + word.getLength() - replacementOffset;
                }
            }
            catch (BadLocationException e) {
                RUIPlugin.logUncriticalError(e);
            }
        }
        return end - replacementOffset;
    }

    protected @Nullable String getValidationPrefix(int offset) throws BadLocationException {
        int startOffset = Math.max(this.getReplacementOffset(), 0);
        if (offset >= startOffset) {
            RAssistInvocationContext context = (RAssistInvocationContext)this.getInvocationContext();
            IDocument document = context.getDocument();
            int nameEndOffset = offset;
            int nameStartOffset = startOffset;
            if (nameEndOffset > nameStartOffset && document.getChar(nameStartOffset) == '`') {
                ++nameStartOffset;
            }
            if (nameEndOffset > nameStartOffset && document.getChar(nameEndOffset - 1) == '`') {
                --nameEndOffset;
            }
            if (nameEndOffset >= nameStartOffset) {
                return context.getIdentifierSegmentName(document.get(startOffset, offset - startOffset));
            }
        }
        return null;
    }
}

