/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.console.ui.launching;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.statet.ecommons.databinding.core.validation.IntegerValidator;
import org.eclipse.statet.ecommons.ui.components.WidgetToolsButton;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleMainTab;
import org.eclipse.statet.internal.r.console.ui.launching.RConsoleType;
import org.eclipse.statet.internal.r.console.ui.launching.RRemoteConsoleLaunchDelegate;
import org.eclipse.statet.internal.r.console.ui.launching.RRemoteConsoleSelectionDialog;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.net.CommonsNet;
import org.eclipse.statet.jcommons.net.Port;
import org.eclipse.statet.jcommons.net.core.RSAccessClientSession;
import org.eclipse.statet.jcommons.net.core.RemoteTarget;
import org.eclipse.statet.jcommons.net.core.ssh.SshTarget;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.nico.impl.RjsUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RRemoteConsoleMainTab
extends RConsoleMainTab {
    private final IObservableValue<String> addressValue;
    private final IObservableValue<String> userValue;
    private final IObservableValue<Integer> sshPortValue;
    private final IObservableValue<Boolean> sshTunnelValue;
    private final IObservableValue<String> commandValue;
    private final IObservableValue<String> sshAddressValue;
    private Text addressControl;
    private List<Control> addressControls;
    private RRemoteConsoleSelectionDialog remoteEngineSelectionDialog;
    private Text usernameControl;
    private List<Control> loginControls;
    private Label usernameInfo;
    private Text sshPortControl;
    private Text sshAddress;
    private Button sshTunnelControl;
    private List<Control> sshControls;
    private Text commandControl;
    private List<Control> commandControls;
    private UpdateJob updateJob;

    public RRemoteConsoleMainTab() {
        Realm realm = this.getRealm();
        this.addressValue = new WritableValue(realm, (Object)"", String.class);
        this.userValue = new WritableValue(realm, (Object)"", String.class);
        this.sshPortValue = new WritableValue(realm, null, Integer.class);
        this.sshTunnelValue = new WritableValue(realm, (Object)false, Boolean.TYPE);
        this.commandValue = new WritableValue(realm, (Object)"", String.class);
        this.sshAddressValue = new WritableValue(realm, (Object)"", String.class);
    }

    @Override
    protected ImList<RConsoleType> loadTypes() {
        ArrayList<RConsoleType> types = new ArrayList<RConsoleType>();
        types.add(new RConsoleType("RJ (RMI/JRI) - Manual", "remote.rjs-rmi", false, true, false));
        types.add(new RConsoleType("RJ (RMI/JRI) - Start over SSH", "remote.rjs-rmi.ssh", false, true, false));
        types.add(new RConsoleType("RJ (RMI/JRI) - Quick Reconnect", "remote.rjs-rmi-reconnect", false, true, false));
        return ImCollections.toList(types);
    }

    @Override
    public void createControl(Composite parent) {
        this.updateJob = new UpdateJob();
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.statet.r.ui.r_remote_console-launch");
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.updateJob != null) {
            this.updateJob.cancel();
            this.updateJob = null;
        }
    }

    @Override
    protected Composite createTypeDetailGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        group.setText("Connection:");
        this.addressControls = new ArrayList<Control>(8);
        this.loginControls = new ArrayList<Control>(8);
        this.sshControls = new ArrayList<Control>(8);
        this.commandControls = new ArrayList<Control>(8);
        Label label = new Label((Composite)group, 0);
        label.setText("&Address: ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        Composite composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.addressControl = new Text(composite, 18432);
        this.addressControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button addressButton = new Button(composite, 8);
        addressButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        addressButton.setText("Browse...");
        addressButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String text;
                boolean newDialog;
                boolean bl = newDialog = RRemoteConsoleMainTab.this.remoteEngineSelectionDialog == null;
                if (newDialog) {
                    RRemoteConsoleMainTab.this.remoteEngineSelectionDialog = new RRemoteConsoleSelectionDialog(RRemoteConsoleMainTab.this.getShell(), false);
                } else {
                    RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.clearAdditionaAddress(true);
                }
                String userName = (String)RRemoteConsoleMainTab.this.userValue.getValue();
                if (userName != null && userName.isEmpty()) {
                    userName = null;
                }
                if ((text = RRemoteConsoleMainTab.this.addressControl.getText()).length() > 0) {
                    try {
                        StringBuilder sb = new StringBuilder();
                        RMIAddress rmiAddress = RMIAddress.parseUnresolved((String)text);
                        sb.append(rmiAddress.getHost());
                        if (rmiAddress.getPort() != RMIAddress.DEFAULT_PORT) {
                            sb.append(':').append(rmiAddress.getPort());
                        }
                        RRemoteConsoleSelectionDialog.SpecialAddress special = null;
                        if (RRemoteConsoleMainTab.this.sshTunnelControl.isEnabled() && RRemoteConsoleMainTab.this.sshTunnelControl.getSelection() && userName != null) {
                            Integer sshPort = (Integer)RRemoteConsoleMainTab.this.sshPortValue.getValue();
                            SshTarget remoteTarget = new SshTarget(rmiAddress.getHost(), sshPort != null ? Port.valueOf((Integer)sshPort) : null, userName);
                            special = new RRemoteConsoleSelectionDialog.SpecialAddress(rmiAddress.getRegistryAddress(), CommonsNet.LOOPBACK_STRING, (RemoteTarget)remoteTarget){
                                private final /* synthetic */ RemoteTarget val$remoteTarget;
                                {
                                    this.val$remoteTarget = remoteTarget;
                                    super($anonymous0, $anonymous1);
                                }

                                @Override
                                public RMIClientSocketFactory getSocketFactory(ProgressMonitor m) throws StatusException {
                                    RSAccessClientSession remoteNetSession = RjsUtil.getRSAccessClientSession((RemoteTarget)this.val$remoteTarget, (ProgressMonitor)m);
                                    return RjsUtil.createRMIOverSshClientSocketFactory((RSAccessClientSession)remoteNetSession);
                                }
                            };
                            sb.append(" through SSH tunnel");
                        } else {
                            rmiAddress = rmiAddress.resolve();
                        }
                        String label = sb.toString();
                        RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.addAdditionalAddress(label, special);
                        RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.setInitialAddress(label);
                    }
                    catch (Exception sb) {
                        // empty catch block
                    }
                }
                RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.setUser(userName);
                if (RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.open() == 0) {
                    String result = (String)RRemoteConsoleMainTab.this.remoteEngineSelectionDialog.getFirstResult();
                    RRemoteConsoleMainTab.this.addressValue.setValue((Object)result);
                }
            }
        });
        this.addressControls.add((Control)label);
        this.addressControls.add((Control)composite);
        label = new Label((Composite)group, 0);
        label.setText("&Username: ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.usernameControl = new Text(composite, 18432);
        GridData gd = new GridData(4, 0x1000000, false, false);
        gd.widthHint = gd.minimumWidth = LayoutUtils.hintWidth((Text)this.usernameControl, (int)20);
        this.usernameControl.setLayoutData((Object)gd);
        this.usernameInfo = new Label(composite, 16384);
        this.usernameInfo.setText("");
        this.usernameInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.loginControls.add((Control)label);
        this.loginControls.add((Control)this.usernameControl);
        this.loginControls.add((Control)this.usernameInfo);
        label = new Label((Composite)group, 0);
        label.setText("&SSH Port: ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sshPortControl = new Text((Composite)group, 18432);
        GridData gd2 = new GridData(16384, 0x1000000, true, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)this.sshPortControl, (int)6);
        this.sshPortControl.setLayoutData((Object)gd2);
        this.sshControls.add((Control)label);
        this.sshControls.add((Control)this.sshPortControl);
        label = new Label((Composite)group, 0);
        label.setText("SSH Options: ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.sshTunnelControl = new Button((Composite)group, 32);
        this.sshTunnelControl.setLayoutData((Object)new GridData(4, 4, true, false));
        this.sshTunnelControl.setText("&Tunnel connections to R engine through SSH");
        this.sshControls.add((Control)label);
        this.sshControls.add((Control)this.sshTunnelControl);
        label = new Label((Composite)group, 16384);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("SSH Address:");
        this.sshAddress = new Text((Composite)group, 18432);
        this.sshAddress.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sshAddress.setEditable(false);
        this.sshControls.add((Control)label);
        this.sshControls.add((Control)this.sshAddress);
        label = new Label((Composite)group, 0);
        label.setText("Re&mote Command: ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        composite = new Composite((Composite)group, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 3, 1));
        composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
        this.commandControl = new Text(composite, 18432);
        this.commandControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        WidgetToolsButton toolsButton = new WidgetToolsButton((Control)this.commandControl){

            protected void fillMenu(Menu menu) {
                MenuItem item = new MenuItem(menu, 8);
                item.setText("Insert &Variable...");
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell()){

                            public void setElements(Object[] elements) {
                                super.setElements((Object[])new IStringVariable[]{RRemoteConsoleLaunchDelegate.ADDRESS_VARIABLE, RRemoteConsoleLaunchDelegate.NAME_VARIABLE, RRemoteConsoleLaunchDelegate.WD_VARIABLE});
                            }
                        };
                        if (dialog.open() != 0) {
                            return;
                        }
                        String variable = dialog.getVariableExpression();
                        if (variable == null) {
                            return;
                        }
                        (this).RRemoteConsoleMainTab.this.commandControl.insert(variable);
                        (this).RRemoteConsoleMainTab.this.commandControl.setFocus();
                    }
                });
            }
        };
        toolsButton.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.commandControls.add((Control)label);
        this.commandControls.add((Control)this.commandControl);
        this.commandControls.add((Control)toolsButton);
        return group;
    }

    @Override
    protected void createFooter(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText("Global preferences: <a href=\"org.eclipse.statet.nico.preferencePages.ResourceMappings\">Folder Mapping</a>, <a href=\"org.eclipse.jsch.ui.SSHPreferences\">SSH2 Options (Key Management)</a>.");
        composite.setLayoutData((Object)new GridData(4, 1024, true, false));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)e.text, null, null);
                if (dialog != null) {
                    dialog.open();
                }
            }
        });
        super.createFooter(composite);
    }

    @Override
    protected void addBindings(DataBindingContext dbc) {
        super.addBindings(dbc);
        MultiValidator validator = new MultiValidator(){

            protected IStatus validate() {
                if (!RRemoteConsoleMainTab.this.getType().getId().equals("remote.rjs-rmi-reconnect")) {
                    String text = (String)RRemoteConsoleMainTab.this.addressValue.getValue();
                    if (text == null || text.isEmpty()) {
                        return ValidationStatus.error((String)"Missing address for R remote engine ('//host[:port]/rsessionname').");
                    }
                    try {
                        RMIAddress.validate((String)text);
                    }
                    catch (MalformedURLException e) {
                        return ValidationStatus.error((String)("Invalid address for R remote engine: " + e.getLocalizedMessage()));
                    }
                }
                return ValidationStatus.ok();
            }
        };
        WritableValue addressValue1 = new WritableValue((Object)"", String.class);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.addressControl), (IObservableValue)addressValue1);
        validator.observeValidatedValue((IObservableValue)addressValue1);
        dbc.bindValue((IObservableValue)addressValue1, this.addressValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.usernameControl), this.userValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.sshPortControl), this.sshPortValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(0, 65535, true, "Invalid SSH port number specified (0-65535).")), null);
        dbc.bindValue((IObservableValue)WidgetProperties.buttonSelection().observe((Widget)this.sshTunnelControl), this.sshTunnelValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.commandControl), this.commandValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.sshAddress), this.sshAddressValue);
        this.addressValue.addValueChangeListener((IValueChangeListener)this.updateJob);
        this.userValue.addValueChangeListener((IValueChangeListener)this.updateJob);
        this.sshPortValue.addValueChangeListener((IValueChangeListener)this.updateJob);
        dbc.addValidationStatusProvider((ValidationStatusProvider)validator);
        validator.observeValidatedValue(this.getTypeValue());
    }

    @Override
    protected void updateType(RConsoleType type) {
        if ("remote.rjs-rmi".equals(type.getId())) {
            DialogUtils.setEnabled(this.addressControls, null, (boolean)true);
            DialogUtils.setEnabled((Control)this.getArgumentComposite(), null, (boolean)true);
            DialogUtils.setEnabled(this.loginControls, null, (boolean)true);
            this.usernameInfo.setText("(optional)");
            DialogUtils.setVisible(this.sshControls, null, (boolean)true);
            DialogUtils.setVisible(this.commandControls, null, (boolean)false);
        } else if ("remote.rjs-rmi.ssh".equals(type.getId())) {
            DialogUtils.setEnabled(this.addressControls, null, (boolean)true);
            DialogUtils.setEnabled((Control)this.getArgumentComposite(), null, (boolean)true);
            DialogUtils.setEnabled(this.loginControls, null, (boolean)true);
            this.usernameInfo.setText("(required)");
            DialogUtils.setVisible(this.sshControls, null, (boolean)true);
            DialogUtils.setVisible(this.commandControls, null, (boolean)true);
            UIAccess.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RRemoteConsoleMainTab.this.userValue.getValue() == null || ((String)RRemoteConsoleMainTab.this.userValue.getValue()).isEmpty()) {
                        RRemoteConsoleMainTab.this.userValue.setValue((Object)System.getProperty("user.name"));
                    }
                    if (RRemoteConsoleMainTab.this.sshPortValue.getValue() == null) {
                        RRemoteConsoleMainTab.this.sshPortValue.setValue((Object)CommonsNet.SSH_DEFAULT_PORT.get());
                    }
                    if (RRemoteConsoleMainTab.this.commandValue.getValue() == null || ((String)RRemoteConsoleMainTab.this.commandValue.getValue()).isEmpty()) {
                        RRemoteConsoleMainTab.this.commandValue.setValue((Object)RRemoteConsoleLaunchDelegate.DEFAULT_COMMAND);
                    }
                }
            });
        } else {
            DialogUtils.setEnabled(this.addressControls, null, (boolean)false);
            DialogUtils.setEnabled((Control)this.getArgumentComposite(), null, (boolean)false);
            DialogUtils.setEnabled(this.loginControls, null, (boolean)true);
            this.usernameInfo.setText("");
            DialogUtils.setVisible(this.sshControls, null, (boolean)false);
            DialogUtils.setVisible(this.commandControls, null, (boolean)false);
        }
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/address", "//host/rsessionname");
    }

    @Override
    protected void doInitialize(ILaunchConfiguration configuration) {
        super.doInitialize(configuration);
        this.addressValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/address", ""));
        this.userValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/login.name", ""));
        this.sshPortValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/ssh.port", 22));
        this.sshTunnelValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/ssh.tunnel.enabled", false));
        this.commandValue.setValue((Object)this.readAttribute(configuration, "org.eclipse.statet.r.debug/RConsole/command", ""));
    }

    @Override
    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        super.doSave(configuration);
        if (this.addressControl.isEnabled()) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/address", (String)this.addressValue.getValue());
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/address");
        }
        String user = (String)this.userValue.getValue();
        if (user != null && user.length() > 0) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/login.name", user);
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/login.name");
        }
        Integer port = (Integer)this.sshPortValue.getValue();
        if (!this.getType().getId().equals("remote.rjs-rmi-reconnect") && port != null) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/ssh.port", port.intValue());
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/ssh.port");
        }
        Boolean tunnel = (Boolean)this.sshTunnelValue.getValue();
        if (!this.getType().getId().equals("remote.rjs-rmi-reconnect") && tunnel != null) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/ssh.tunnel.enabled", tunnel.booleanValue());
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/ssh.tunnel.enabled");
        }
        String command = (String)this.commandValue.getValue();
        if (this.getType().getId().equals("remote.rjs-rmi.ssh") && command != null) {
            configuration.setAttribute("org.eclipse.statet.r.debug/RConsole/command", command);
        } else {
            configuration.removeAttribute("org.eclipse.statet.r.debug/RConsole/command");
        }
    }

    private class UpdateJob
    extends Job
    implements IValueChangeListener<Object> {
        private String user;
        private String address;
        private Integer sshPort;

        public UpdateJob() {
            super("Background Update for RRemoteConsoleMainTab");
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            StringBuilder sb = new StringBuilder();
            sb.setLength(0);
            sb.append(this.user);
            sb.append('@');
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            try {
                RMIAddress rmiAddress = RMIAddress.parse((String)this.address);
                sb.append(rmiAddress.getHostInetAddress().getHostAddress());
            }
            catch (UnknownHostException e) {
                sb.append("<unknown>");
            }
            catch (Exception e) {
                // empty catch block
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            Integer port = this.sshPort;
            if (port != null && port != 22) {
                sb.append(':');
                sb.append(port.toString());
            }
            final String s = sb.toString();
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            RRemoteConsoleMainTab.this.sshAddressValue.getRealm().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ((UpdateJob)UpdateJob.this).RRemoteConsoleMainTab.this.sshAddressValue.setValue((Object)s);
                }
            });
            return Status.OK_STATUS;
        }

        public void handleValueChange(ValueChangeEvent<?> event) {
            this.cancel();
            this.user = (String)RRemoteConsoleMainTab.this.userValue.getValue();
            this.address = (String)RRemoteConsoleMainTab.this.addressValue.getValue();
            this.sshPort = (Integer)RRemoteConsoleMainTab.this.sshPortValue.getValue();
            this.schedule(100L);
        }
    }
}

