/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.compare;

import org.eclipse.compare.contentmergeviewer.IIgnoreWhitespaceContributor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.internal.ltk.ui.LtkUIPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class PartitionIgnoreSpaceContributor
implements IIgnoreWhitespaceContributor {
    private final IDocument document;
    private final String partitioning;
    private final PartitionConstraint partitionConstraint;

    public PartitionIgnoreSpaceContributor(IDocument document, String partitioning, PartitionConstraint partitionConstraint) {
        if (!(document instanceof IDocumentExtension3)) {
            throw new IllegalArgumentException();
        }
        this.document = document;
        this.partitioning = partitioning;
        this.partitionConstraint = partitionConstraint;
    }

    public boolean isIgnoredWhitespace(int lineNumber, int columnNumber) {
        try {
            int offset = this.document.getLineOffset(lineNumber) + columnNumber;
            ITypedRegion partition = ((IDocumentExtension3)this.document).getPartition(this.partitioning, offset, false);
            return !this.partitionConstraint.matches(partition.getType());
        }
        catch (BadLocationException | BadPartitioningException e) {
            LtkUIPlugin.logUncriticalError(e);
            return true;
        }
    }
}

