/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.text.core;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;

@NonNullByDefault
public class MultiContentSectionCharPairMatcher
implements CharPairMatcher {
    private static final Object NULL = new Object();
    private final DocContentSections sections;
    private final Map<String, Object> handlers = new IdentityHashMap<String, Object>(8);
    private @Nullable CharPairMatcher activeMatcher;

    public MultiContentSectionCharPairMatcher(DocContentSections sections) {
        this.sections = (DocContentSections)ObjectUtils.nonNullAssert((Object)sections);
    }

    public MultiContentSectionCharPairMatcher(DocContentSections sections, String sectionType1, CharPairMatcher matcher1) {
        this(sections, sectionType1, matcher1, null, null);
    }

    public MultiContentSectionCharPairMatcher(DocContentSections sections, String sectionType1, CharPairMatcher matcher1, String sectionType2, CharPairMatcher matcher2) {
        this(sections);
        if (sectionType1 != null) {
            this.registerHandler(sectionType1, matcher1);
        }
        if (sectionType2 != null) {
            this.registerHandler(sectionType2, matcher2);
        }
    }

    protected DocContentSections getSections() {
        return this.sections;
    }

    public void dispose() {
        for (Object handler : this.handlers.values()) {
            if (handler == NULL) continue;
            ((CharPairMatcher)handler).dispose();
        }
        this.handlers.clear();
    }

    public void registerHandler(String sectionType, CharPairMatcher matcher) {
        this.handlers.put((String)ObjectUtils.nonNullAssert((Object)sectionType), matcher);
    }

    protected final @Nullable CharPairMatcher getHandler(String sectionType) {
        if (sectionType == "") {
            return null;
        }
        Object handler = this.handlers.get(sectionType);
        if (handler == null) {
            handler = NULL;
            try {
                CharPairMatcher newHandler = this.createHandler(sectionType);
                if (newHandler != null) {
                    handler = newHandler;
                }
            }
            finally {
                this.handlers.put(sectionType, handler);
            }
        }
        return handler != NULL ? (CharPairMatcher)handler : null;
    }

    protected @Nullable CharPairMatcher createHandler(String sectionType) {
        return null;
    }

    public void clear() {
        CharPairMatcher activeMatcher = this.activeMatcher;
        if (activeMatcher != null) {
            this.activeMatcher = null;
            activeMatcher.clear();
        }
    }

    @Override
    public @Nullable IRegion match(IDocument document, int offset) {
        CharPairMatcher activeMatcher;
        CharPairMatcher previousMatcher = this.activeMatcher;
        this.activeMatcher = activeMatcher = this.getHandler(this.sections.getType(document, offset));
        if (previousMatcher != null && previousMatcher != activeMatcher) {
            previousMatcher.clear();
        }
        if (activeMatcher != null) {
            return activeMatcher.match(document, offset);
        }
        return null;
    }

    @Override
    public @Nullable IRegion match(IDocument document, int offset, boolean auto) {
        CharPairMatcher activeMatcher;
        CharPairMatcher previousMatcher = this.activeMatcher;
        this.activeMatcher = activeMatcher = this.getHandler(this.sections.getType(document, offset));
        if (previousMatcher != null && previousMatcher != activeMatcher) {
            previousMatcher.clear();
        }
        if (activeMatcher != null) {
            return activeMatcher.match(document, offset, auto);
        }
        return null;
    }

    public int getAnchor() {
        CharPairMatcher activeMatcher = this.activeMatcher;
        if (activeMatcher != null) {
            return activeMatcher.getAnchor();
        }
        return -1;
    }
}

