/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.string;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.util.StringUtils;

@NonNullByDefault
public final class MStringAUtils {
    public static final boolean isLineSeparator(char c) {
        return c == '\n' || c == '\r';
    }

    public static final void replaceTabsWithSpaces(StringBuilder sb, int tabWidth) {
        int column = 0;
        int index = 0;
        while (index < sb.length()) {
            char c = sb.charAt(index);
            switch (c) {
                case '\r': {
                    if (++index < sb.length() && sb.charAt(index++) != '\n') {
                        --index;
                    }
                    column = 0;
                    break;
                }
                case '\n': {
                    ++index;
                    column = 0;
                    break;
                }
                case '\t': {
                    int numSpaces = tabWidth - column % tabWidth;
                    sb.setCharAt(index++, ' ');
                    if (numSpaces > 1) {
                        StringUtils.insertSpaces(sb, index, numSpaces - 1);
                        index += numSpaces - 1;
                    }
                    column += numSpaces;
                    break;
                }
                default: {
                    ++index;
                    ++column;
                }
            }
        }
    }

    public static final int computeIndent(String s, int startIndex, int endIndex, int tabWidth) {
        if (startIndex == endIndex) {
            return 0;
        }
        int minColumn = Integer.MAX_VALUE;
        int columns = 0;
        int index = startIndex;
        block8: while (index < endIndex) {
            char c = s.charAt(index++);
            block0 : switch (c) {
                case ' ': {
                    ++columns;
                    break;
                }
                case '\t': {
                    columns += tabWidth - columns % tabWidth;
                    break;
                }
                default: {
                    if (columns < minColumn) {
                        minColumn = columns;
                    }
                    columns = 0;
                    while (index < endIndex) {
                        switch (c) {
                            case '\r': {
                                if (s.charAt(index++) == '\n') continue block8;
                                --index;
                                break block0;
                            }
                            case '\n': {
                                break block0;
                            }
                            default: {
                                c = s.charAt(index++);
                            }
                        }
                    }
                    return minColumn;
                }
            }
        }
        return columns > 0 && columns < minColumn ? columns : minColumn;
    }

    public static final int computeIndent(String s, int tabWidth) {
        return MStringAUtils.computeIndent(s, 0, s.length(), tabWidth);
    }

    public static final int computeIndent(StringBuilder s, int startIndex, int endIndex, int tabWidth) {
        if (startIndex == endIndex) {
            return 0;
        }
        int minColumns = Integer.MAX_VALUE;
        int column = 0;
        int index = startIndex;
        block8: while (index < endIndex) {
            char c = s.charAt(index++);
            block0 : switch (c) {
                case ' ': {
                    ++column;
                    break;
                }
                case '\t': {
                    column += tabWidth - column % tabWidth;
                    break;
                }
                default: {
                    if (column < minColumns) {
                        minColumns = column;
                    }
                    column = 0;
                    while (index < endIndex) {
                        switch (c) {
                            case '\r': {
                                if (s.charAt(index++) == '\n') continue block8;
                                --index;
                                break block0;
                            }
                            case '\n': {
                                break block0;
                            }
                            default: {
                                c = s.charAt(index++);
                            }
                        }
                    }
                    return minColumns;
                }
            }
        }
        return column > 0 && column < minColumns ? column : minColumns;
    }

    public static final int computeIndent(StringBuilder s, int tabWidth) {
        return MStringAUtils.computeIndent(s, 0, s.length(), tabWidth);
    }

    public static void collectLines(String s, int startIndex, int endIndex, Collection<String> lines) {
        int index = startIndex;
        int lineStartIndex = startIndex;
        while (index < endIndex) {
            switch (s.charAt(index)) {
                case '\r': {
                    lines.add(s.substring(lineStartIndex, index++));
                    if (index >= endIndex || s.charAt(index++) != '\n') {
                        // empty if block
                    }
                    lineStartIndex = --index;
                    break;
                }
                case '\n': {
                    lines.add(s.substring(lineStartIndex, index++));
                    lineStartIndex = index;
                    break;
                }
                default: {
                    ++index;
                }
            }
        }
        if (lineStartIndex < endIndex) {
            lines.add(s.substring(lineStartIndex, endIndex));
        }
    }

    public static void collectLines(String s, Collection<String> lines) {
        MStringAUtils.collectLines(s, 0, s.length(), lines);
    }

    public static List<String> linesToList(String s) {
        ArrayList<String> lines = new ArrayList<String>(2 + s.length() / 20);
        MStringAUtils.collectLines(s, lines);
        return lines;
    }

    public static String getLastLine(String s) {
        int start = s.length() - 1;
        if (start > 1) {
            if (s.charAt(start) == '\n') {
                --start;
            }
            if ((start = s.lastIndexOf(10, start)) != -1) {
                return s.substring(start + 1, s.length());
            }
        }
        return s;
    }

    public static final void stripLineStart(StringBuilder sb, int numChars) {
        if (numChars == 0 || sb.length() < numChars) {
            return;
        }
        int index = 0;
        sb.delete(0, numChars);
        while (index < sb.length() - numChars - 1) {
            char c = sb.charAt(index++);
            switch (c) {
                case '\r': {
                    if (sb.charAt(index++) != '\n') {
                        --index;
                    }
                    sb.delete(index, index + numChars);
                    break;
                }
                case '\n': {
                    sb.delete(index, index + numChars);
                    break;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void appendWithLineStart(StringBuilder sb, String s, int startIndex, int endIndex, String prefix, boolean applyToFirstLine) {
        block13: {
            ObjectUtils.nonNullAssert(s);
            ObjectUtils.nonNullAssert(prefix);
            if (startIndex == endIndex) {
                return;
            }
            index = startIndex;
            if (!applyToFirstLine) ** GOTO lbl-1000
            lineStartIndex = startIndex;
            break block13;
            {
                switch (s.charAt(index++)) {
                    case '\r': {
                        if (index >= endIndex || s.charAt(index++) == '\n') break block8;
                        --index;
                        break block8;
                    }
                    case '\n': {
                        break block8;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (index < endIndex) continue block8;
                    }
                }
            }
            sb.append(s, startIndex, index);
            lineStartIndex = index;
        }
        while (index < endIndex) {
            switch (s.charAt(index++)) {
                case '\r': {
                    if (index < endIndex && s.charAt(index++) != '\n') {
                        --index;
                    }
                    sb.append(prefix);
                    sb.append(s, lineStartIndex, index);
                    lineStartIndex = index;
                    break;
                }
                case '\n': {
                    sb.append(prefix);
                    sb.append(s, lineStartIndex, index);
                    lineStartIndex = index;
                    break;
                }
            }
        }
        if (lineStartIndex < endIndex) {
            sb.append(prefix);
            sb.append(s, lineStartIndex, endIndex);
        }
    }

    public static final void appendWithLineStart(StringBuilder sb, String s, String prefix, boolean applyToFirstLine) {
        MStringAUtils.appendWithLineStart(sb, s, 0, s.length(), prefix, applyToFirstLine);
    }

    public static final void appendWithLineStart(StringBuilder sb, String s, String prefix) {
        MStringAUtils.appendWithLineStart(sb, s, 0, s.length(), prefix, true);
    }

    private MStringAUtils() {
    }
}

