/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.workbench.search.ui;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.text.Match;
import org.eclipse.statet.ecommons.workbench.search.ui.ElementMatchComparator;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResult;
import org.eclipse.statet.ecommons.workbench.search.ui.ExtTextSearchResultPage;
import org.eclipse.statet.ecommons.workbench.search.ui.IMatchGroup;
import org.eclipse.statet.ecommons.workbench.search.ui.LineElement;
import org.eclipse.statet.ecommons.workbench.search.ui.TextSearchResultContentProvider;
import org.eclipse.statet.jcommons.collections.SortedArraySet;

public abstract class TextSearchResultTreeContentProvider<E, M extends Match>
extends TextSearchResultContentProvider<E, M, TreeViewer>
implements ITreeContentProvider {
    protected final ElementMatchComparator<E, M> comparator;
    private final SortedArraySet<E> currentElements;

    public TextSearchResultTreeContentProvider(ExtTextSearchResultPage<E, M> page, TreeViewer viewer) {
        super(page, viewer);
        this.comparator = page.comparator;
        this.currentElements = new SortedArraySet((Object[])this.comparator.getElement0(), this.comparator.getElementComparator());
    }

    @Override
    protected void reset() {
        super.reset();
        this.currentElements.clear();
    }

    public Object[] getElements(Object inputElement) {
        if (!this.active) {
            int limit;
            ExtTextSearchResult result = this.getInput();
            assert (result == inputElement);
            if (result == null) {
                return NO_ELEMENTS;
            }
            assert (this.currentElements.isEmpty());
            Object[] elements = result.getElements();
            if (elements.length <= (limit = this.getElementLimit()) && result.getActiveMatchFilters() == null) {
                this.currentElements.addAllE(0, elements, 0, elements.length);
                this.active = true;
                return elements;
            }
            int i = 0;
            while (i < elements.length && this.currentElements.size() < limit) {
                Object element = elements[i];
                if (result.hasPickedMatches(element)) {
                    this.currentElements.addE(this.currentElements.size(), element);
                }
                ++i;
            }
            this.active = true;
        }
        return this.currentElements.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof Match) {
            return ((Match)element).getElement();
        }
        if (element instanceof IMatchGroup) {
            return ((IMatchGroup)element).getElement();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return !(element instanceof Match) && !(element instanceof LineElement);
    }

    public Object[] getChildren(Object parentElement) {
        ExtTextSearchResult result = this.getInput();
        Match[] matches = result.getPickedMatches(parentElement);
        return this.getShownMatches(matches);
    }

    public Object[] getShownMatches(M[] matches) {
        return matches;
    }

    @Override
    public void elementsChanged(Object[] elements) {
        if (!this.active) {
            return;
        }
        ExtTextSearchResult result = this.getInput();
        int limit = this.getElementLimit();
        TreeViewer viewer = (TreeViewer)this.getViewer();
        viewer.getTree().setRedraw(false);
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (result.hasPickedMatches(element)) {
                    if (this.currentElements.size() < limit) {
                        currentIdx = this.currentElements.addE(element);
                        if (currentIdx >= 0) {
                            this.addElement(viewer, element, currentIdx);
                        } else {
                            viewer.refresh(element, true);
                        }
                    } else {
                        currentIdx = this.currentElements.indexOfE(element);
                        if (currentIdx >= 0) {
                            viewer.refresh(element, true);
                        }
                    }
                } else {
                    currentIdx = this.currentElements.removeE(element);
                    if (currentIdx >= 0) {
                        this.removeElement(viewer, element, currentIdx);
                    }
                }
                ++i;
            }
        }
        finally {
            viewer.getTree().setRedraw(true);
        }
    }

    protected void addElement(TreeViewer viewer, E element, int idx) {
        viewer.insert((Object)TreePath.EMPTY, element, idx);
    }

    protected void removeElement(TreeViewer viewer, E element, int idx) {
        viewer.remove((Object)TreePath.EMPTY, idx);
    }

    @Override
    public void clear() {
        this.reset();
        super.clear();
    }
}

