/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.painter.cell.AbstractTextPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.GraphicsUtils;
import org.eclipse.statet.ecommons.waltable.resize.core.DimPositionResizeCommand;
import org.eclipse.statet.ecommons.waltable.style.CellStyleUtil;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class TextPainter
extends AbstractTextPainter {
    public TextPainter() {
        this(false, true);
    }

    public TextPainter(boolean wrapText, boolean paintBg) {
        this(wrapText, paintBg, 0);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing) {
        this(wrapText, paintBg, spacing, false);
    }

    public TextPainter(boolean wrapText, boolean paintBg, boolean calculate) {
        this(wrapText, paintBg, 0, calculate);
    }

    public TextPainter(boolean wrapText, boolean paintBg, int spacing, boolean calculate) {
        super(wrapText, paintBg, spacing, calculate);
    }

    @Override
    public long getPreferredWidth(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return this.getWidthFromCache(gc, this.convertDataType(cell, configRegistry)) + this.spacing * 2 + 1;
    }

    @Override
    public long getPreferredHeight(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        this.setupGCFromConfig(gc, CellStyleUtil.getCellStyle(cell, configRegistry));
        return gc.textExtent((String)this.convertDataType((LayerCell)cell, (ConfigRegistry)configRegistry)).y + this.spacing * 2 + 1;
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle lRectangle, ConfigRegistry configRegistry) {
        block7: {
            Rectangle originalClipping;
            block9: {
                String[] lines;
                int contentHeight;
                String text;
                int fontHeight;
                boolean strikethrough;
                boolean underline;
                Style cellStyle;
                block8: {
                    if (this.paintBg) {
                        super.paintCell(cell, gc, lRectangle, configRegistry);
                    }
                    if (!this.paintFg) break block7;
                    originalClipping = gc.getClipping();
                    gc.setClipping(GraphicsUtils.safe(lRectangle).intersection(originalClipping));
                    cellStyle = CellStyleUtil.getCellStyle(cell, configRegistry);
                    this.setupGCFromConfig(gc, cellStyle);
                    underline = this.renderUnderlined(cellStyle);
                    strikethrough = this.renderStrikethrough(cellStyle);
                    fontHeight = gc.getFontMetrics().getHeight();
                    text = this.convertDataType(cell, configRegistry);
                    text = this.getTextToDisplay(cell, gc, lRectangle.width, text);
                    int numberOfNewLines = this.getNumberOfNewLines(text);
                    contentHeight = fontHeight * numberOfNewLines + this.spacing * 2;
                    long contentToCellDiff = cell.getBounds().height - lRectangle.height;
                    if (this.performRowResize(contentHeight, lRectangle)) {
                        Layer layer = cell.getLayer();
                        layer.doCommand(new DimPositionResizeCommand(layer.getDim(Orientation.VERTICAL), cell.getRowPosition(), (int)Math.min((long)contentHeight + contentToCellDiff, 32767L)));
                    }
                    if (numberOfNewLines != 1) break block8;
                    long contentWidth = Math.min((long)this.getWidthFromCache(gc, text), lRectangle.width);
                    gc.drawText(text, GraphicsUtils.safe(lRectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, lRectangle, contentWidth) + (long)this.spacing), GraphicsUtils.safe(lRectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, lRectangle, (long)contentHeight) + (long)this.spacing), 3);
                    if (!underline && !strikethrough) break block9;
                    int x = GraphicsUtils.safe(lRectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, lRectangle, contentWidth) + (long)this.spacing);
                    int y = GraphicsUtils.safe(lRectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, lRectangle, (long)contentHeight) + (long)this.spacing);
                    if (underline) {
                        int underlineY = GraphicsUtils.safe(y + fontHeight - gc.getFontMetrics().getDescent() / 2);
                        gc.drawLine(x, underlineY, x + gc.textExtent((String)text).x, underlineY);
                    }
                    if (!strikethrough) break block9;
                    int strikeY = GraphicsUtils.safe(y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2);
                    gc.drawLine(x, strikeY, x + gc.textExtent((String)text).x, strikeY);
                    break block9;
                }
                long yStartPos = lRectangle.y + CellStyleUtil.getVerticalAlignmentPadding(cellStyle, lRectangle, (long)contentHeight);
                String[] stringArray = lines = text.split("\n");
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    long lineContentWidth = Math.min((long)this.getWidthFromCache(gc, line), lRectangle.width);
                    gc.drawText(line, GraphicsUtils.safe(lRectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, lRectangle, lineContentWidth) + (long)this.spacing), GraphicsUtils.safe(yStartPos + (long)this.spacing), 3);
                    if (underline || strikethrough) {
                        int x = GraphicsUtils.safe(lRectangle.x + CellStyleUtil.getHorizontalAlignmentPadding(cellStyle, lRectangle, lineContentWidth) + (long)this.spacing);
                        int y = GraphicsUtils.safe(yStartPos + (long)this.spacing);
                        if (underline) {
                            int underlineY = GraphicsUtils.safe(y + fontHeight - gc.getFontMetrics().getDescent() / 2);
                            gc.drawLine(x, underlineY, x + gc.textExtent((String)line).x, underlineY);
                        }
                        if (strikethrough) {
                            int strikeY = GraphicsUtils.safe(y + fontHeight / 2 + gc.getFontMetrics().getLeading() / 2);
                            gc.drawLine(x, strikeY, x + gc.textExtent((String)line).x, strikeY);
                        }
                    }
                    yStartPos += (long)fontHeight;
                    ++n2;
                }
            }
            gc.setClipping(originalClipping);
        }
    }

    protected boolean performRowResize(long contentHeight, LRectangle lRectangle) {
        return this.calculateByTextHeight && contentHeight > lRectangle.height;
    }
}

