/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.painter.cell;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRectangle;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.events.CellVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.painter.cell.AbstractCellPainter;
import org.eclipse.statet.ecommons.waltable.painter.cell.decorator.BeveledBorderDecorator;
import org.eclipse.statet.ecommons.waltable.ui.NatEventData;
import org.eclipse.statet.ecommons.waltable.ui.action.IMouseAction;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;

public class ButtonCellPainter
extends AbstractCellPainter
implements IMouseAction {
    private final LayerCellPainter buttonRaisedPainter;
    private final LayerCellPainter buttonPressedPainter;
    private int buttonFlashTime = 150;
    private long columnPosClicked;
    private long rowPosClicked;
    private boolean recentlyClicked;
    private final List<IMouseAction> clickLiseners = new ArrayList<IMouseAction>();

    public ButtonCellPainter(LayerCellPainter interiorPainter) {
        this.buttonPressedPainter = new BeveledBorderDecorator(interiorPainter, false);
        this.buttonRaisedPainter = new BeveledBorderDecorator(interiorPainter);
    }

    public ButtonCellPainter(LayerCellPainter buttonRaisedPainter, LayerCellPainter buttonPressedPainter) {
        this.buttonRaisedPainter = buttonRaisedPainter;
        this.buttonPressedPainter = buttonPressedPainter;
    }

    @Override
    public void paintCell(LayerCell cell, GC gc, LRectangle bounds, ConfigRegistry configRegistry) {
        if (this.recentlyClicked && this.columnPosClicked == cell.getColumnPosition() && this.rowPosClicked == cell.getRowPosition()) {
            this.buttonPressedPainter.paintCell(cell, gc, bounds, configRegistry);
        } else {
            this.buttonRaisedPainter.paintCell(cell, gc, bounds, configRegistry);
        }
    }

    @Override
    public long getPreferredHeight(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        return cell.getBounds().height;
    }

    @Override
    public long getPreferredWidth(LayerCell cell, GC gc, ConfigRegistry configRegistry) {
        return cell.getBounds().width;
    }

    private TimerTask getButtonFlashTimerTask(final Layer layer) {
        return new TimerTask(){

            @Override
            public void run() {
                ButtonCellPainter.this.recentlyClicked = false;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        layer.fireLayerEvent(new CellVisualChangeEvent(layer, (this).ButtonCellPainter.this.columnPosClicked, (this).ButtonCellPainter.this.rowPosClicked));
                    }
                });
            }
        };
    }

    @Override
    public void run(NatTable natTable, MouseEvent event) {
        NatEventData eventData = (NatEventData)event.data;
        this.columnPosClicked = eventData.getColumnPosition();
        this.rowPosClicked = eventData.getRowPosition();
        this.recentlyClicked = true;
        new Timer().schedule(this.getButtonFlashTimerTask(natTable), this.buttonFlashTime);
        natTable.fireLayerEvent(new CellVisualChangeEvent(natTable, this.columnPosClicked, this.rowPosClicked));
        for (IMouseAction listener : this.clickLiseners) {
            listener.run(natTable, event);
        }
    }

    public void addClickListener(IMouseAction mouseAction) {
        this.clickLiseners.add(mouseAction);
    }

    public void removeClickListener(IMouseAction mouseAction) {
        this.clickLiseners.remove(mouseAction);
    }

    public void setButtonFlashTime(int flashTimeInMS) {
        this.buttonFlashTime = flashTimeInMS;
    }
}

