/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ecommons.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class UIMiscellanyPlugin
extends AbstractUIPlugin {
    public static final String BUNDLE_ID = "org.eclipse.statet.ecommons.uimisc";
    private static final String NS = "org.eclipse.statet.ecommons.uimisc";
    public static final String LOCTOOL_GO_IMAGE_ID = "org.eclipse.statet.ecommons.uimisc/images/loctool/go";
    public static final String LOCTOOL_GO_D_IMAGE_ID = "org.eclipse.statet.ecommons.uimisc/images/loctoold/go";
    private static UIMiscellanyPlugin instance;
    private boolean started;
    private final List<Disposable> disposables = new ArrayList<Disposable>();

    public static UIMiscellanyPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        UIMiscellanyPlugin plugin = UIMiscellanyPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            UIMiscellanyPlugin uIMiscellanyPlugin = this;
            synchronized (uIMiscellanyPlugin) {
                this.started = false;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    UIMiscellanyPlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", "Error occured when dispose module", e));
                }
            }
            this.disposables.clear();
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        UIMiscellanyPlugin uIMiscellanyPlugin = this;
        synchronized (uIMiscellanyPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(final ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil(this);
        util.register("org.eclipse.statet.ecommons.uimisc/images/obj/user");
        util.register("org.eclipse.statet.ecommons.uimisc/images/obj/line_match", ".gif");
        util.register("org.eclipse.statet.ecommons.uimisc/images/obj/main_tab", "obj_16", "main_tab.png");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/default_marker", ".gif");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/light-green");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/light-yellow");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/info");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/warning");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/error");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/ignore-optional_problems");
        util.register("org.eclipse.statet.ecommons.uimisc/images/ovr/deprecated");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/filter_view", "loctool_16", "filter_view.gif");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctoold/filter_view", "loctool_16_d", "filter_view.gif");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/disable-filter", "loctool_16", "disable-filter.png");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/sort-alpha");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/sort-score");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/casesensitive", "loctool_16", "casesensitive.png");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/expand.all");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/collapse.all");
        util.register("org.eclipse.statet.ecommons.uimisc/images/tool/scrolllock");
        util.register("org.eclipse.statet.ecommons.uimisc/images/tool/scrolllock$d");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/sync-editor");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/favorites");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/change_page", "loctool_16", "change_page.png");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctool/pin_page", "loctool_16", "pin_page.png");
        util.register("org.eclipse.statet.ecommons.uimisc/images/loctoold/pin_page", "loctool_16", "pin_page.png");
        util.register(LOCTOOL_GO_IMAGE_ID, "loctool_16", "go.png");
        util.register(LOCTOOL_GO_D_IMAGE_ID, "loctool_16_d", "go.png");
        UIAccess.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Display display = Display.getCurrent();
                int[] cross = new int[]{3, 3, 5, 3, 7, 5, 8, 5, 10, 3, 12, 3, 12, 5, 10, 7, 10, 8, 12, 10, 12, 12, 10, 12, 8, 10, 7, 10, 5, 12, 3, 12, 3, 10, 5, 8, 5, 7, 3, 5};
                int[] right = new int[]{5, 3, 8, 3, 12, 7, 12, 8, 8, 12, 5, 12, 5, 11, 8, 8, 8, 7, 5, 4};
                int[] left = new int[right.length];
                int[] up = new int[right.length];
                int[] down = new int[right.length];
                int i = 0;
                while (i < right.length) {
                    int j = i + 1;
                    int x = right[i];
                    int y = right[j];
                    left[i] = 16 - x;
                    left[j] = y;
                    up[i] = y;
                    up[j] = 16 - x;
                    down[i] = y;
                    down[j] = x;
                    i += 2;
                }
                Color border = display.getSystemColor(17);
                Color background = display.getSystemColor(25);
                Color hotRed = new Color(252, 160, 160);
                Color hotYellow = new Color(252, 232, 160);
                Color transparent = display.getSystemColor(11);
                int defaultIconSize = 16;
                PaletteData palette = new PaletteData(new RGB[]{transparent.getRGB(), border.getRGB(), background.getRGB(), hotRed.getRGB(), hotYellow.getRGB()});
                ImageData data = new ImageData(16, 16, 8, palette);
                data.transparentPixel = 0;
                reg.put("org.eclipse.statet.ecommons.uimisc/images/obj/dummy", (ImageDescriptor)new CompositeImageDescriptor(){

                    protected Point getSize() {
                        return new Point(16, 16);
                    }

                    protected void drawCompositeImage(int width, int height) {
                    }
                });
                Image image = new Image((Device)display, data);
                image.setBackground(transparent);
                GC gc = new GC((Drawable)image);
                gc.setBackground(background);
                gc.fillPolygon(cross);
                gc.setForeground(border);
                gc.drawPolygon(cross);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctool/close", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(hotRed);
                gc.fillPolygon(cross);
                gc.setForeground(border);
                gc.drawPolygon(cross);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctoolh/close", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(background);
                gc.fillPolygon(left);
                gc.setForeground(border);
                gc.drawPolygon(left);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctool/left", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(hotYellow);
                gc.fillPolygon(left);
                gc.setForeground(border);
                gc.drawPolygon(left);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctoolh/left", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(background);
                gc.fillPolygon(right);
                gc.setForeground(border);
                gc.drawPolygon(right);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctool/right", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(hotYellow);
                gc.fillPolygon(right);
                gc.setForeground(border);
                gc.drawPolygon(right);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctoolh/right", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(background);
                gc.fillPolygon(up);
                gc.setForeground(border);
                gc.drawPolygon(up);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctool/up", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(hotYellow);
                gc.fillPolygon(up);
                gc.setForeground(border);
                gc.drawPolygon(up);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctoolh/up", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(background);
                gc.fillPolygon(down);
                gc.setForeground(border);
                gc.drawPolygon(down);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctool/down", image);
                image = new Image((Device)display, data);
                image.setBackground(transparent);
                gc = new GC((Drawable)image);
                gc.setBackground(hotYellow);
                gc.fillPolygon(down);
                gc.setForeground(border);
                gc.drawPolygon(down);
                gc.dispose();
                reg.put("org.eclipse.statet.ecommons.uimisc/images/loctoolh/down", image);
            }
        });
    }
}

