/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.viewers.breadcrumb;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbItem;
import org.eclipse.statet.ecommons.ui.viewers.breadcrumb.BreadcrumbViewerRow;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@NonNullByDefault
public abstract class BreadcrumbViewer
extends StructuredViewer {
    private static final boolean IS_GTK = "gtk".equals(SWT.getPlatform());
    private final ArrayList<BreadcrumbItem> breadcrumbItems = new ArrayList();
    private final CopyOnWriteIdentityListSet<MenuDetectListener> menuListeners = new CopyOnWriteIdentityListSet();
    private final Composite container;
    private @Nullable BreadcrumbItem selectedItem;
    private @Nullable ILabelProvider toolTipLabelProvider;
    private @Nullable Predicate<Object> canOpen;

    public BreadcrumbViewer(Composite parent, int style) {
        this.container = new Composite(parent, 0);
        this.container.setLayoutData((Object)new GridData(4, 128, true, false));
        this.container.setBackgroundMode(1);
        this.container.setData("org.eclipse.e4.ui.css.id", (Object)"BreadcrumbComposite");
        this.container.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                e.doit = true;
            }
        });
        this.hookControl((Control)this.container);
        int columns = 1000;
        if ((0x200 & style) != 0) {
            columns = 1;
        }
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.container.setLayout((Layout)gridLayout);
        this.container.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                BreadcrumbViewer.this.refresh();
            }
        });
    }

    protected void handleDispose(DisposeEvent event) {
        ILabelProvider toolTipLabelProvider = this.toolTipLabelProvider;
        if (toolTipLabelProvider != null) {
            this.toolTipLabelProvider = null;
            toolTipLabelProvider.dispose();
        }
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            indexItem.dispose();
            ++index;
        }
        this.breadcrumbItems.clear();
        super.handleDispose(event);
    }

    public void setToolTipLabelProvider(@Nullable ILabelProvider toolTipLabelProvider) {
        this.toolTipLabelProvider = toolTipLabelProvider;
    }

    public void setCanOpen(@Nullable Predicate<Object> predicate) {
        this.canOpen = predicate;
    }

    public Control getControl() {
        return this.container;
    }

    protected @Nullable Object getRoot() {
        if (this.breadcrumbItems.isEmpty()) {
            return null;
        }
        return this.breadcrumbItems.getFirst().getElement();
    }

    public void reveal(Object element) {
    }

    public void setFocus() {
        this.container.setFocus();
        BreadcrumbItem item = this.selectedItem;
        if (item != null) {
            item.setFocus(true);
            return;
        }
        if (this.breadcrumbItems.isEmpty()) {
            return;
        }
        item = this.breadcrumbItems.getLast();
        if (item.getData() == null) {
            if (this.breadcrumbItems.size() < 2) {
                return;
            }
            item = this.breadcrumbItems.get(this.breadcrumbItems.size() - 2);
        }
        item.setFocus(true);
    }

    public boolean isDropDownOpen() {
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (indexItem.isMenuShown()) {
                return true;
            }
            ++index;
        }
        return false;
    }

    public @Nullable Shell getDropDownShell() {
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (indexItem.isMenuShown()) {
                return indexItem.getDropDownShell();
            }
            ++index;
        }
        return null;
    }

    public @Nullable ISelectionProvider getDropDownSelectionProvider() {
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (indexItem.isMenuShown()) {
                return indexItem.getDropDownSelectionProvider();
            }
            ++index;
        }
        return null;
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.menuListeners.add((Object)((MenuDetectListener)ObjectUtils.nonNullAssert((Object)listener)));
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.menuListeners.remove((Object)listener);
    }

    protected void assertContentProviderType(IContentProvider provider) {
        super.assertContentProviderType(provider);
        Assert.isTrue((boolean)(provider instanceof ITreeContentProvider));
    }

    protected void inputChanged(@Nullable Object input, @Nullable Object oldInput) {
        if (this.container.isDisposed()) {
            return;
        }
        this.disableRedraw();
        try {
            int lastIndex;
            if (!this.breadcrumbItems.isEmpty()) {
                BreadcrumbItem last = this.breadcrumbItems.getLast();
                last.setIsLastItem(false);
            }
            if ((lastIndex = this.buildItemChain(input)) > 0) {
                BreadcrumbItem last = this.breadcrumbItems.get(lastIndex - 1);
                last.setIsLastItem(true);
            }
            while (lastIndex < this.breadcrumbItems.size()) {
                BreadcrumbItem item = this.breadcrumbItems.removeLast();
                if (item == this.selectedItem) {
                    this.selectItem(null);
                }
                if (item.getData() != null) {
                    this.unmapElement(item.getData());
                }
                item.dispose();
            }
            this.updateSize();
            this.container.layout(true, true);
        }
        finally {
            this.enableRedraw();
        }
    }

    protected @Nullable Widget doFindInputItem(@Nullable Object element) {
        if (element == null) {
            return null;
        }
        if (element == this.getInput() || element.equals(this.getInput())) {
            return this.doFindItem(element);
        }
        return null;
    }

    protected @Nullable Widget doFindItem(@Nullable Object element) {
        if (element == null) {
            return null;
        }
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (element.equals(indexItem.getData())) {
                return indexItem;
            }
            ++index;
        }
        return null;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        if (widget instanceof BreadcrumbItem) {
            BreadcrumbItem item = (BreadcrumbItem)widget;
            if (fullMap) {
                this.associate(element, item);
            } else {
                Object data = item.getData();
                if (data != null) {
                    this.unmapElement(data, (Widget)item);
                }
                item.setData(element);
                this.mapElement(element, (Widget)item);
            }
            BreadcrumbViewerRow row = new BreadcrumbViewerRow(this, item);
            ViewerCell cell = (ViewerCell)ObjectUtils.nonNullAssert((Object)row.getCell(0));
            ((CellLabelProvider)this.getLabelProvider()).update(cell);
            item.refreshArrow();
            if (this.toolTipLabelProvider != null) {
                item.setToolTip(this.toolTipLabelProvider.getText(item.getElement()));
            } else {
                item.setToolTip(cell.getText());
            }
        }
    }

    protected ImList<@NonNull Object> getSelectionFromWidget() {
        BreadcrumbItem selectedItem = this.selectedItem;
        if (selectedItem == null || selectedItem.getData() == null) {
            return ImCollections.emptyList();
        }
        return ImCollections.newList((Object)selectedItem.getElement());
    }

    protected void internalRefresh(@Nullable Object element) {
        this.disableRedraw();
        try {
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) {
                int size = this.breadcrumbItems.size();
                int index = 0;
                while (index < size) {
                    BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
                    indexItem.refresh();
                    ++index;
                }
            } else {
                item.refresh();
            }
            if (this.updateSize()) {
                this.container.layout(true, true);
            }
        }
        finally {
            this.enableRedraw();
        }
    }

    protected void setSelectionToWidget(@Nullable List l, boolean reveal) {
        BreadcrumbItem focusItem = null;
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (indexItem.hasFocus()) {
                focusItem = indexItem;
            }
            indexItem.setSelected(false);
            ++index;
        }
        if (l == null) {
            return;
        }
        for (Object element : l) {
            BreadcrumbItem item = (BreadcrumbItem)this.doFindItem(element);
            if (item == null) continue;
            item.setSelected(true);
            this.selectedItem = item;
            if (item != focusItem) continue;
            item.setFocus(true);
        }
    }

    void selectItem(@Nullable BreadcrumbItem item) {
        BreadcrumbItem oldItem = this.selectedItem;
        if (oldItem != null) {
            oldItem.setSelected(false);
        }
        this.selectedItem = item;
        this.setSelectionToWidget(this.getSelection(), false);
        if (item != null) {
            this.setFocus();
        } else {
            int size = this.breadcrumbItems.size();
            int index = 0;
            while (index < size) {
                BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
                indexItem.setFocus(false);
                ++index;
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    int getItemCount() {
        return this.breadcrumbItems.size();
    }

    BreadcrumbItem getItem(int index) {
        return this.breadcrumbItems.get(index);
    }

    int getIndexOfItem(BreadcrumbItem item) {
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            if (indexItem == item) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    void fireDoubleClick() {
        this.fireDoubleClick(new DoubleClickEvent((Viewer)this, this.getSelection()));
    }

    boolean canOpen(Object element) {
        Predicate<Object> predicate = this.canOpen;
        return predicate == null || predicate.test(element);
    }

    void fireOpen() {
        this.fireOpen(new OpenEvent((Viewer)this, this.getSelection()));
    }

    void fireMenuSelection(Object element) {
        this.fireOpen(new OpenEvent((Viewer)this, (ISelection)new StructuredSelection(element)));
    }

    void fireMenuDetect(MenuDetectEvent event) {
        for (MenuDetectListener listener : this.menuListeners) {
            listener.menuDetected(event);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void doTraverse(boolean next) {
        if (this.selectedItem == null) {
            return;
        }
        int index = this.breadcrumbItems.indexOf((Object)this.selectedItem);
        if (next) {
            if (index != this.breadcrumbItems.size() - 1) {
                BreadcrumbItem nextItem = this.breadcrumbItems.get(index + 1);
                this.selectItem(nextItem);
                return;
            }
            BreadcrumbItem item = this.breadcrumbItems.get(index);
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
            if (!contentProvider.hasChildren(item.getElement())) {
                return;
            }
            item.openDropDownMenu();
            return;
        }
        if (index == 1) {
            BreadcrumbItem item = this.breadcrumbItems.getFirst();
            item.openDropDownMenu();
            return;
        }
        this.selectItem(this.breadcrumbItems.get(index - 1));
    }

    private int buildItemChain(@Nullable Object element) {
        BreadcrumbItem item;
        if (element == null) {
            return 0;
        }
        ITreeContentProvider contentProvider = (ITreeContentProvider)this.getContentProvider();
        Object parent = contentProvider.getParent(element);
        int index = this.buildItemChain(parent);
        if (index < this.breadcrumbItems.size()) {
            item = this.breadcrumbItems.get(index);
            if (item.getData() != null) {
                this.unmapElement(item.getData());
            }
        } else {
            item = this.createItem();
            this.breadcrumbItems.add(item);
        }
        if (this.equals(element, item.getData())) {
            this.update(element, null);
        } else {
            item.setData(element);
            item.refresh();
        }
        if (parent == null) {
            item.setDetailsVisible(false);
        }
        this.mapElement(element, (Widget)item);
        return index + 1;
    }

    private BreadcrumbItem createItem() {
        BreadcrumbItem result = new BreadcrumbItem(this, this.container);
        result.setLabelProvider((ILabelProvider)this.getLabelProvider());
        if (this.toolTipLabelProvider != null) {
            result.setToolTipLabelProvider(this.toolTipLabelProvider);
        } else {
            result.setToolTipLabelProvider((ILabelProvider)this.getLabelProvider());
        }
        result.setContentProvider((ITreeContentProvider)this.getContentProvider());
        return result;
    }

    private boolean updateSize() {
        boolean requiresLayout;
        block7: {
            int currentWidth;
            int width;
            block6: {
                width = this.container.getClientArea().width;
                currentWidth = this.getCurrentWidth();
                requiresLayout = false;
                if (currentWidth <= width) break block6;
                int index = 0;
                while (currentWidth > width && index < this.breadcrumbItems.size() - 1) {
                    BreadcrumbItem item = this.breadcrumbItems.get(index);
                    if (item.isShowText()) {
                        item.setShowText(false);
                        currentWidth = this.getCurrentWidth();
                        requiresLayout = true;
                    }
                    ++index;
                }
                break block7;
            }
            if (currentWidth >= width) break block7;
            int index = this.breadcrumbItems.size() - 1;
            while (currentWidth < width && index >= 0) {
                BreadcrumbItem item = this.breadcrumbItems.get(index);
                if (!item.isShowText()) {
                    item.setShowText(true);
                    currentWidth = this.getCurrentWidth();
                    if (currentWidth > width) {
                        item.setShowText(false);
                        index = 0;
                    } else {
                        requiresLayout = true;
                    }
                }
                --index;
            }
        }
        return requiresLayout;
    }

    private int getCurrentWidth() {
        int result = 0;
        int size = this.breadcrumbItems.size();
        int index = 0;
        while (index < size) {
            BreadcrumbItem indexItem = this.breadcrumbItems.get(index);
            result += indexItem.getWidth();
            ++index;
        }
        return result;
    }

    private void enableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.container.setRedraw(true);
    }

    private void disableRedraw() {
        if (IS_GTK) {
            return;
        }
        this.container.setRedraw(false);
    }

    protected abstract void configureDropDownViewer(TreeViewer var1, Object var2);

    public void fillDropDownContextMenu(IMenuManager manager, Object selection) {
    }
}

