/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.statet.internal.ecommons.preferences.ui.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public final class PreferenceUIUtils {
    public static SeeAlsoBuilder composeSeeAlsoPreferencePages() {
        return new SeeAlsoBuilder(Messages.SeeAlso_message);
    }

    private PreferenceUIUtils() {
    }

    public static final class SeeAlsoBuilder {
        private final StringBuilder sb = new StringBuilder(128);

        public SeeAlsoBuilder(String seeAlsoMessage) {
            this.sb.append(seeAlsoMessage);
        }

        private void addItem() {
            this.sb.append("\n   \u2022 ");
        }

        public SeeAlsoBuilder add(String text) {
            this.addItem();
            this.sb.append(text);
            return this;
        }

        public SeeAlsoBuilder add(String text, String ... pageId) {
            this.addItem();
            int idxWritten = 0;
            int i = 0;
            while (i < pageId.length) {
                int idx = text.indexOf("<a>");
                if (idx < 0) {
                    throw new IllegalArgumentException();
                }
                this.sb.append(text, idxWritten, idx);
                this.sb.append("<a href=\"");
                this.sb.append(pageId[i]);
                this.sb.append("\">");
                idxWritten = idx + 3;
                ++i;
            }
            this.sb.append(text, idxWritten, text.length());
            return this;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

