/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core.util;

import java.util.function.Supplier;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectDef;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.jcommons.collections.ImSet;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class PreferenceObjectController<TObject>
implements Supplier<TObject>,
PreferenceSetService.ChangeListener {
    private static final byte STARTED = 0;
    private static final byte INITIALIZED = 1;
    private static final byte UPTODATE = 2;
    private static final byte DISPOSED = 3;
    private final Class<TObject> type;
    private final PreferenceAccess prefs;
    private final ImSet<String> qualifiers;
    private volatile byte state;
    private @Nullable TObject object;

    public PreferenceObjectController(Class<TObject> type, PreferenceAccess prefs, ImSet<String> qualifiers) {
        this.type = type;
        this.prefs = prefs;
        this.qualifiers = qualifiers;
    }

    public synchronized void dispose() {
        byte state = this.state;
        if (state == 3) {
            return;
        }
        this.state = (byte)3;
        if (state > 0) {
            this.prefs.removePreferenceSetListener(this);
        }
    }

    public final Class<TObject> getType() {
        return this.type;
    }

    @Override
    public byte getNotificationPriority() {
        return 9;
    }

    @Override
    public final void onPreferenceChanged(PreferenceSetService.ChangeEvent event) {
        if (this.state == 2 && this.isUpdateRequired(event)) {
            this.disposeObject();
        }
    }

    protected boolean isUpdateRequired(PreferenceSetService.ChangeEvent event) {
        return true;
    }

    protected final synchronized void disposeObject() {
        byte state = this.state;
        if (state <= 1) {
            return;
        }
        this.state = 1;
        @Nullable TObject object = this.object;
        this.object = null;
        if (object instanceof Disposable) {
            ((Disposable)object).dispose();
        }
    }

    protected abstract TObject createObject(PreferenceAccess var1);

    @Override
    public synchronized TObject get() {
        byte state = this.state;
        if (state >= 2) {
            return this.object;
        }
        this.state = (byte)2;
        if (state == 0) {
            this.prefs.addPreferenceSetListener(this, this.qualifiers);
        }
        this.object = this.createObject(this.prefs);
        return this.object;
    }

    public String toString() {
        return this.type.getName();
    }

    public static <TObject> PreferenceObjectController<TObject> createController(Class<TObject> type, PreferenceAccess prefs, final PreferenceObjectDef<TObject> factory) {
        return new PreferenceObjectController<TObject>(type, prefs, factory.getQualifiers()){

            @Override
            protected TObject createObject(PreferenceAccess prefs) {
                return factory.create(prefs);
            }
        };
    }
}

