/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.resources.core;

import java.util.Objects;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.internal.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BuildUtils {
    public static Job getBuildJob(@Nullable IProject project) {
        BuildJob buildJob = new BuildJob(Messages.CoreUtility_Build_Job_title, project);
        buildJob.setUser(true);
        return buildJob;
    }

    public static Job getCleanJob(IProject project, boolean autoBuild) {
        CleanJob buildJob = new CleanJob(Messages.CoreUtility_Clean_Job_title, project, autoBuild);
        buildJob.setUser(true);
        return buildJob;
    }

    public static void startBuildInBackground(IProject project) {
        BuildUtils.getBuildJob(project).schedule();
    }

    public static boolean setAutoBuilding(boolean state) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceDescription desc = workspace.getDescription();
        boolean isAutoBuilding = desc.isAutoBuilding();
        if (isAutoBuilding != state) {
            desc.setAutoBuilding(state);
            workspace.setDescription(desc);
        }
        return isAutoBuilding;
    }

    private BuildUtils() {
    }

    private static final class BuildJob
    extends Job {
        private final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        private final @Nullable IProject project;

        private BuildJob(String name, @Nullable IProject project) {
            super(name);
            this.project = project;
            this.setPriority(40);
            this.setRule(this.workspace.getRuleFactory().buildRule());
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
        }

        public byte isCoveredBy(BuildJob other) {
            if (Objects.equals(this.project, other.project)) {
                return 1;
            }
            if (other.project == null) {
                return 2;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            try {
                try {
                    Class<?> clazz = ((Object)((Object)this)).getClass();
                    synchronized (clazz) {
                        Job[] buildJobs;
                        if (m.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Job[] jobArray = buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                        int n = buildJobs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Job job = jobArray[n2];
                            if (job != this && job instanceof BuildJob) {
                                BuildJob buildJob = (BuildJob)job;
                                switch (buildJob.isCoveredBy(this)) {
                                    case 1: 
                                    case 2: {
                                        buildJob.cancel();
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    IProject project = this.project;
                    if (project != null) {
                        m.beginTask(NLS.bind((String)Messages.CoreUtility_Build_ProjectTask_name, (Object)project.getName()), 2);
                        project.build(6, (IProgressMonitor)m.newChild(1));
                        this.workspace.build(10, (IProgressMonitor)m.newChild(1));
                    } else {
                        m.beginTask(Messages.CoreUtility_Build_AllTask_name, 1);
                        this.workspace.build(6, (IProgressMonitor)m.newChild(1));
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    m.done();
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    m.done();
                    return iStatus;
                }
            }
            finally {
                m.done();
            }
            return Status.OK_STATUS;
        }
    }

    private static final class CleanJob
    extends Job {
        private final IWorkspace workspace = ResourcesPlugin.getWorkspace();
        private final @Nullable IProject project;
        private boolean autoBuild;

        private CleanJob(String name, @Nullable IProject project, boolean autoBuild) {
            super(name);
            this.project = project;
            this.autoBuild = autoBuild;
            this.setPriority(30);
            this.setRule(this.workspace.getRuleFactory().buildRule());
        }

        public boolean belongsTo(Object family) {
            return family == ResourcesPlugin.FAMILY_MANUAL_BUILD;
        }

        public byte isCoveredBy(CleanJob other) {
            if (Objects.equals(this.project, other.project)) {
                return 1;
            }
            if (other.project == null) {
                return 2;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor);
            try {
                try {
                    IWorkspaceDescription desc;
                    Class<?> clazz = ((Object)((Object)this)).getClass();
                    synchronized (clazz) {
                        Job[] buildJobs;
                        if (m.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        Job[] jobArray = buildJobs = Job.getJobManager().find(ResourcesPlugin.FAMILY_MANUAL_BUILD);
                        int n = buildJobs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Job job = jobArray[n2];
                            if (job != this && job instanceof CleanJob) {
                                CleanJob buildJob = (CleanJob)job;
                                switch (buildJob.isCoveredBy(this)) {
                                    case 1: {
                                        this.autoBuild |= buildJob.autoBuild;
                                        buildJob.cancel();
                                        break;
                                    }
                                    case 2: {
                                        if (!this.autoBuild || buildJob.autoBuild) break;
                                        buildJob.cancel();
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    IProject project = this.project;
                    if (project != null) {
                        m.beginTask(NLS.bind((String)Messages.CoreUtility_Clean_ProjectTask_name, (Object)project.getName()), 1);
                        project.build(15, (IProgressMonitor)m.newChild(1));
                    } else {
                        m.beginTask(Messages.CoreUtility_Clean_AllTask_name, 1);
                        this.workspace.build(15, (IProgressMonitor)m.newChild(1));
                    }
                    if (this.autoBuild && !(desc = this.workspace.getDescription()).isAutoBuilding()) {
                        BuildUtils.getBuildJob(project).schedule();
                    }
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    m.done();
                    return iStatus;
                }
                catch (OperationCanceledException e) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    m.done();
                    return iStatus;
                }
            }
            finally {
                m.done();
            }
            return Status.OK_STATUS;
        }
    }
}

