/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.tex.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.source.doc.LtxDocumentContentInfo;
import org.eclipse.statet.docmlet.tex.core.source.doc.TexDocumentConstants;
import org.eclipse.statet.docmlet.tex.core.source.util.LtxBracketPairMatcher;
import org.eclipse.statet.docmlet.tex.core.source.util.LtxHeuristicTokenScanner;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.LtxQuickAssistProcessor;
import org.eclipse.statet.docmlet.tex.ui.sourceediting.TexEditingSettings;
import org.eclipse.statet.docmlet.tex.ui.text.LtxDefaultTextStyleScanner;
import org.eclipse.statet.docmlet.tex.ui.text.LtxDoubleClickStrategy;
import org.eclipse.statet.docmlet.tex.ui.text.LtxMathTextStyleScanner;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.internal.docmlet.tex.ui.TexUIPlugin;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxAutoEditStrategy;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxContentAssistProcessor;
import org.eclipse.statet.internal.docmlet.tex.ui.sourceediting.LtxQuickOutlineInformationProvider;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.presentation.CommentScanner;

public class LtxSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])TexDocumentConstants.LTX_CONTENT_TYPES.toArray((Object[])new String[TexDocumentConstants.LTX_CONTENT_TYPES.size()]);
    protected ITextDoubleClickStrategy doubleClickStrategy;
    private LtxAutoEditStrategy autoEditStrategy;
    private TexCoreAccess coreAccess;

    public LtxSourceViewerConfiguration(int flags) {
        this((DocContentSections)LtxDocumentContentInfo.INSTANCE, flags, null, null, null, null);
    }

    public LtxSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor editor, TexCoreAccess access, IPreferenceStore preferenceStore, PreferenceStoreTextStyleManager<TextAttribute> textStyles) {
        super(documentContentInfo, flags, editor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : TexUIPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), TexEditingSettings.getAssistPreferences());
        this.setTextStyles(textStyles);
    }

    protected void setCoreAccess(TexCoreAccess access) {
        this.coreAccess = access != null ? access : TexCore.getWorkbenchAccess();
    }

    protected void initTextStyles() {
        this.setTextStyles(TexUIPlugin.getInstance().getLtxTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("Ltx.Default", new LtxDefaultTextStyleScanner(textStyles));
        this.addScanner("Ltx.Math", new LtxMathTextStyleScanner(textStyles));
        this.addScanner("Ltx.Comment", (ITokenScanner)new CommentScanner(textStyles, "tex_ts_Comment", "tex_ts_TaskTag", this.coreAccess.getPrefs()));
        this.addScanner("Ltx.MathComment", (ITokenScanner)new CommentScanner(textStyles, "tex_ts_Comment", "tex_ts_TaskTag", this.coreAccess.getPrefs()));
        this.addScanner("Ltx.Verbatim", (ITokenScanner)new SingleTokenScanner(textStyles, "tex_ts_Verbatim"));
    }

    public List<SourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.autoEditStrategy != null) {
            addons.add(this.autoEditStrategy);
        }
        return addons;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        if (this.autoEditStrategy != null) {
            this.autoEditStrategy.getSettings().handleSettingsChanged(groupIds, options);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public CharPairMatcher createPairMatcher() {
        return new LtxBracketPairMatcher(LtxHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new LtxDoubleClickStrategy(LtxHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
        }
        return this.doubleClickStrategy;
    }

    protected IIndentSettings getIndentSettings() {
        return this.coreAccess.getTexCodeStyle();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"%", ""};
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)EPreferences.getInstancePrefs().getPreferenceValue(TexEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createTexAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoEditStrategy};
    }

    protected LtxAutoEditStrategy createTexAutoEditStrategy() {
        return new LtxAutoEditStrategy(this.coreAccess, this.getSourceEditor());
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        SourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2(editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        return reconciler;
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = TexUIPlugin.getInstance().getLtxEditorContentAssistRegistry();
        LtxContentAssistProcessor processor = new LtxContentAssistProcessor(assistant, "Ltx.Default", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'\\'});
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Default");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Math", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'\\'});
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Math");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Comment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Comment");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.MathComment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.MathComment");
        processor = new LtxContentAssistProcessor(assistant, "Ltx.Verbatim", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Ltx.Verbatim");
    }

    protected IQuickAssistProcessor createQuickAssistProcessor() {
        SourceEditor editor = this.getSourceEditor();
        if (editor != null) {
            return new LtxQuickAssistProcessor(editor);
        }
        return null;
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.docmlet.editorHyperlinks.TexEditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        SourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        return switch (operation) {
            case 51 -> new LtxQuickOutlineInformationProvider(editor, operation);
            default -> null;
        };
    }
}

