/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.io.File;
import java.rmi.RemoteException;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.internal.rj.servi.server.RServiBackend;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.rmi.RMIAddress;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.servi.node.RServiNode;

public abstract class NodeHandler {
    protected RServiNode node;
    RMIAddress address;
    File dir;
    Process process;
    private @Nullable String clientLabel;
    private @Nullable RServiBackend clientHandler;
    boolean isConsoleEnabled;
    private final long startTime = System.currentTimeMillis();
    private long shutdownTime = -1L;

    public boolean isConsoleEnabled() {
        return this.isConsoleEnabled;
    }

    public void enableConsole(String authConfig) throws RjException {
        try {
            this.isConsoleEnabled = this.node.setConsole(authConfig);
        }
        catch (Exception e) {
            Utils.logError("An error occurred when configuring the debug console.", e);
            throw new RjException("An error occurred when configuring the debug console. See server log for detail.");
        }
    }

    public void disableConsole() throws RjException {
        this.enableConsole(null);
    }

    public @Nullable RMIAddress getAddress() {
        return this.address;
    }

    void init(RServiNode node, Process process) {
        this.node = node;
        this.process = process;
    }

    void bindClient(String name, String host) throws RemoteException {
        StringBuilder sb = new StringBuilder(80);
        if (name != null) {
            sb.append(name);
        }
        sb.append('@');
        sb.append(host);
        String client = sb.toString();
        this.clientHandler = this.node.bindClient(client);
        this.setClientLabel(client);
    }

    void unbindClient() throws RemoteException {
        this.clientHandler = null;
        this.setClientLabel(null);
        this.node.unbindClient();
    }

    void shutdown() throws RemoteException {
        this.shutdownTime = System.currentTimeMillis();
        this.clientHandler = null;
        this.setClientLabel(null);
        RServiNode node = this.node;
        this.node = null;
        if (node != null) {
            node.shutdown();
        }
    }

    @Nullable RServiBackend getClientHandler() {
        return this.clientHandler;
    }

    void setClientLabel(@Nullable String clientLabel) {
        this.clientLabel = clientLabel;
    }

    public @Nullable String getClientLabel() {
        return this.clientLabel;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getShutdownTime() {
        return this.shutdownTime;
    }
}

