/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rj.servi;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import org.eclipse.statet.internal.rj.servi.MXNode;
import org.eclipse.statet.internal.rj.servi.PoolListener;
import org.eclipse.statet.internal.rj.servi.PoolManager;
import org.eclipse.statet.internal.rj.servi.Utils;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.rj.servi.pool.PoolNodeObject;
import org.eclipse.statet.rj.servi.pool.PoolServer;

@NonNullByDefault
public class MXNodeManager
implements PoolListener {
    private final PoolServer server;
    private final Map<PoolNodeObject, MXNode> nodes = new HashMap<PoolNodeObject, MXNode>();
    private final PoolManager poolManager;

    public MXNodeManager(PoolServer server, PoolManager poolManager) {
        this.server = server;
        this.poolManager = poolManager;
    }

    @Override
    public void initializing(PoolNodeObject nodeObj) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialized(PoolNodeObject nodeObj) {
        MXNode node;
        MXNodeManager mXNodeManager = this;
        synchronized (mXNodeManager) {
            if (this.nodes.containsKey(nodeObj)) {
                return;
            }
            node = new MXNode(this.server, nodeObj);
            this.nodes.put(nodeObj, node);
        }
        try {
            node.initJM();
        }
        catch (JMException e) {
            Utils.logError("An error occurred when initializing JMX for node '" + node.getId() + "'.", e);
        }
    }

    @Override
    public void disposed(PoolNodeObject nodeObj) {
        MXNode node = this.nodes.remove(nodeObj);
        if (node != null) {
            this.dispose(node);
        }
    }

    private void dispose(MXNode node) {
        try {
            node.disposeJM();
        }
        catch (JMException e) {
            Utils.logError("An error occurred when disposing JMX for node '" + node.getId() + "'.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        this.poolManager.addPoolListener(this);
        Collection<? extends PoolNodeObject> objects = this.poolManager.getPoolNodeObjects();
        MXNodeManager mXNodeManager = this;
        synchronized (mXNodeManager) {
            for (PoolNodeObject poolNodeObject : objects) {
                switch (poolNodeObject.getState()) {
                    case DISPOSED: {
                        break;
                    }
                    default: {
                        this.initialized(poolNodeObject);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        this.poolManager.removePoolListener(this);
        MXNodeManager mXNodeManager = this;
        synchronized (mXNodeManager) {
            block9: {
                try {
                    try {
                        for (Map.Entry<PoolNodeObject, MXNode> entry : this.nodes.entrySet()) {
                            this.dispose(entry.getValue());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.nodes.clear();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.nodes.clear();
                    throw throwable;
                }
                this.nodes.clear();
            }
        }
    }
}

