/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public final class ConsoleWriteCmdItem
extends MainCmdItem {
    public static final byte R_OUTPUT = 1;
    public static final byte R_ERROR = 2;
    public static final byte SYS_OUTPUT = 5;
    private final byte streamId;
    private final String text;

    public ConsoleWriteCmdItem(byte streamId, String text) {
        assert (text != null);
        this.streamId = streamId;
        this.text = text;
    }

    public ConsoleWriteCmdItem(RJIO in) throws IOException {
        this.streamId = in.readByte();
        this.text = in.readString();
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeByte(this.streamId);
        out.writeString(this.text);
    }

    @Override
    public byte getCmdType() {
        return 2;
    }

    @Override
    public byte getOp() {
        return this.streamId;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOK() {
        return true;
    }

    @Override
    public RjsStatus getStatus() {
        return null;
    }

    @Override
    public String getDataText() {
        return this.text;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof ConsoleWriteCmdItem)) {
            return false;
        }
        ConsoleWriteCmdItem otherItem = (ConsoleWriteCmdItem)other;
        return this.options == otherItem.options && this.streamId == otherItem.streamId && this.text.equals(otherItem.getDataText());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("ConsoleWriteCmdItem (").append(this.streamId).append(")");
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        sb.append("\n<TEXT>\n");
        sb.append(this.text);
        sb.append("\n</TEXT>");
        return sb.toString();
    }
}

