/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.correction;

import java.util.Collection;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.internal.r.ui.RUIMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.LinkedNamesAssistProposal;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.rsource.ast.RAst;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

public class RLinkedNamesAssistProposal
extends LinkedNamesAssistProposal {
    public static final int IN_FILE = 1;
    public static final int IN_FILE_PRECEDING = 2;
    public static final int IN_FILE_FOLLOWING = 3;
    public static final int IN_CHUNK = 4;
    private final RElementAccess fAccess;
    private final int fMode;
    private final TextRegion fRegion;

    public RLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, RElementAccess access) {
        super(invocationContext);
        this.fMode = mode;
        this.fRegion = null;
        switch (mode) {
            case 1: {
                this.init(RUIMessages.Proposal_RenameInFile_label, RUIMessages.Proposal_RenameInFile_description, 90);
                break;
            }
            case 2: {
                this.init(RUIMessages.Proposal_RenameInFilePrecending_label, RUIMessages.Proposal_RenameInFilePrecending_description, 85);
                break;
            }
            case 3: {
                this.init(RUIMessages.Proposal_RenameInFileFollowing_label, RUIMessages.Proposal_RenameInFileFollowing_description, 84);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.fAccess = access;
    }

    public RLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, RElementAccess access, TextRegion region) {
        super(invocationContext);
        this.fMode = mode;
        this.fRegion = region;
        switch (mode) {
            case 4: {
                this.init(RUIMessages.Proposal_RenameInChunk_label, RUIMessages.Proposal_RenameInChunk_description, 89);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.fAccess = access;
    }

    protected void collectPositions(IDocument document, LinkedPositionGroup group) throws BadLocationException {
        block12: {
            int i;
            int regionOffset;
            int idx;
            int current;
            ImIdentityList allAccess;
            block11: {
                int i2;
                allAccess = ImCollections.toIdentityList((Collection)this.fAccess.getAllInUnit(false));
                current = allAccess.indexOf((Object)this.fAccess);
                if (current < 0) {
                    return;
                }
                idx = 0;
                idx = this.addPosition(group, document, this.getPosition((RElementAccess)allAccess.get(current)), idx);
                if (this.fMode == 1 || this.fMode == 3) {
                    i2 = current + 1;
                    while (i2 < allAccess.size()) {
                        idx = this.addPosition(group, document, this.getPosition((RElementAccess)allAccess.get(i2)), idx);
                        ++i2;
                    }
                } else if (this.fMode == 4) {
                    regionOffset = this.fRegion.getEndOffset();
                    i = current + 1;
                    while (i < allAccess.size()) {
                        if (regionOffset > ((RElementAccess)allAccess.get(i)).getNameNode().getStartOffset()) {
                            idx = this.addPosition(group, document, this.getPosition((RElementAccess)allAccess.get(i)), idx);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                if (this.fMode != 1 && this.fMode != 2) break block11;
                i2 = 0;
                while (i2 < current) {
                    idx = this.addPosition(group, document, this.getPosition((RElementAccess)allAccess.get(i2)), idx);
                    ++i2;
                }
                break block12;
            }
            if (this.fMode != 4) break block12;
            regionOffset = this.fRegion.getStartOffset();
            i = 0;
            while (i < current) {
                if (regionOffset <= ((RElementAccess)allAccess.get(i)).getNameNode().getStartOffset()) {
                    idx = this.addPosition(group, document, this.getPosition((RElementAccess)allAccess.get(i)), idx);
                }
                ++i;
            }
        }
    }

    private Position getPosition(RElementAccess access) {
        return RAst.getElementNamePosition((RAstNode)access.getNameNode());
    }
}

