/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.rsource.ast;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.statet.internal.r.core.rd.RdRCodeParserInput;
import org.eclipse.statet.internal.r.core.sourcemodel.RoxygenTagType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.string.BasicStringFactory;
import org.eclipse.statet.jcommons.string.StringFactory;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.input.RegionParserInput;
import org.eclipse.statet.jcommons.text.core.input.TextParserInput;
import org.eclipse.statet.r.core.rlang.RTerminal;
import org.eclipse.statet.r.core.rsource.ast.Comment;
import org.eclipse.statet.r.core.rsource.ast.DocuComment;
import org.eclipse.statet.r.core.rsource.ast.DocuTag;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RScanner;
import org.eclipse.statet.r.core.rsource.ast.SourceComponent;
import org.eclipse.statet.r.core.rsource.ast.Symbol;

public class RoxygenScanner {
    private TextParserInput input;
    private RegionParserInput regionInput;
    private RdRCodeParserInput rCodeInput;
    private RScanner rScanner;
    private final StringFactory textCache;
    private final List<DocuTag> list = new ArrayList<DocuTag>();
    private RoxygenTagType currentTagType;
    private DocuTag currentTag;
    private final List<RAstNode> currentTagFragments = new ArrayList<RAstNode>(64);
    private int fragmentMode;
    private final List<TextRegion> codeRegions = new ArrayList<TextRegion>();

    public RoxygenScanner(StringFactory textCache) {
        this.textCache = textCache != null ? textCache : BasicStringFactory.INSTANCE;
    }

    public void init(TextParserInput input) {
        if (input == null) {
            throw new NullPointerException();
        }
        this.input = input;
    }

    public void update(SourceComponent component) {
        List<RAstNode> comments = component.comments;
        if (comments == null || comments.isEmpty()) {
            return;
        }
        for (RAstNode comment : comments) {
            if (comment.getNodeType() != NodeType.DOCU_AGGREGATION) continue;
            this.update((DocuComment)comment);
        }
    }

    public void update(DocuComment comment) {
        if (comment.getOperator(0) != RTerminal.ROXYGEN_COMMENT) {
            return;
        }
        try {
            int lineCount = comment.getChildCount();
            int lineIdx = 0;
            while (lineIdx < lineCount) {
                this.readLine(comment.getChild(lineIdx));
                ++lineIdx;
            }
            this.finishTag();
            comment.tags = ImCollections.toList(this.list);
        }
        finally {
            this.list.clear();
            this.currentTagFragments.clear();
            this.currentTag = null;
        }
    }

    private void setFragmentMode(int mode) {
        this.fragmentMode = mode;
    }

    private void finishTag() {
        switch (this.fragmentMode & 0xF) {
            case 2: {
                if (this.codeRegions.isEmpty()) break;
                if (this.rScanner == null) {
                    if (this.regionInput == null) {
                        this.regionInput = new RegionParserInput(this.input, null);
                        this.regionInput.setSeparator("\n");
                    }
                    this.rCodeInput = new RdRCodeParserInput((TextParserInput)this.regionInput);
                    this.rScanner = new RScanner(4, this.textCache);
                }
                try {
                    this.regionInput.reset(ImCollections.toList(this.codeRegions));
                    SourceComponent node = this.rScanner.scanSourceRange((TextParserInput)this.rCodeInput.init(), this.currentTag);
                    if (node != null) {
                        this.currentTagFragments.add(node);
                    }
                }
                finally {
                    this.codeRegions.clear();
                }
                {
                }
            }
        }
        this.fragmentMode = 0;
        if (!this.currentTagFragments.isEmpty()) {
            this.currentTag.fragments = this.currentTagFragments.toArray(new RAstNode[this.currentTagFragments.size()]);
            this.currentTag.endOffset = this.currentTag.fragments[this.currentTag.fragments.length - 1].getEndOffset();
            this.currentTagFragments.clear();
        }
    }

    private void readLine(Comment line) {
        int num;
        TextParserInput in = this.input;
        block5: while (true) {
            in.init(line.startOffset + 2, line.endOffset);
            num = 0;
            block6: while (true) {
                switch (in.get(num++)) {
                    case -1: 
                    case 10: 
                    case 13: {
                        return;
                    }
                    case 9: 
                    case 32: {
                        continue block6;
                    }
                    case 64: {
                        if (this.fragmentMode != 0) {
                            this.finishTag();
                            continue block5;
                        }
                        in.consume(num - 1);
                        this.readTag(in);
                        return;
                    }
                }
                break;
            }
            break;
        }
        in.consume(num - 1);
        if (this.currentTag == null) {
            this.currentTag = new DocuTag(null);
            this.list.add(this.currentTag);
            this.currentTag.startOffset = this.input.getIndex();
            this.setFragmentMode(0);
        }
        this.readFragments();
    }

    private void readTag(TextParserInput in) {
        int c;
        int num = 1;
        while ((c = in.get(num++)) >= 65 && this.isRoxygenTagChar(c)) {
        }
        String tag = in.getString(1, --num - 1, this.textCache);
        this.currentTag = new DocuTag(tag);
        this.list.add(this.currentTag);
        this.currentTag.startOffset = in.getIndex();
        in.consume(num);
        this.currentTagType = RoxygenTagType.TYPES.get(tag);
        this.setFragmentMode(this.currentTagType != null ? this.currentTagType.getNextScanMode(0) : 0);
        if (c > 0) {
            this.readFragments();
        }
    }

    private void readFragments() {
        TextParserInput in = this.input;
        block5: while (true) {
            switch (this.fragmentMode & 0xF) {
                case 1: {
                    if (this.consumeWhitespace(in)) {
                        return;
                    }
                    if (!this.readSymbol(in)) continue block5;
                    return;
                }
                case 0: {
                    if (this.consumeWhitespace(in)) {
                        return;
                    }
                    if (!this.readText()) continue block5;
                    return;
                }
                case 2: {
                    if (this.consumeWhitespace(in)) {
                        return;
                    }
                    if (!this.readCode(in)) continue block5;
                    return;
                }
            }
        }
    }

    private boolean consumeWhitespace(TextParserInput in) {
        int c;
        int num = 0;
        while ((c = in.get(num++)) == 32 || c == 9) {
        }
        in.consume(num - 1);
        return c < 0 || c == 10 || c == 13;
    }

    private boolean readSymbol(TextParserInput in) {
        int c = in.get(1);
        if (c == 96) {
            return this.readSymbolGraveQuote(in);
        }
        int num = 1;
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122 || Character.isLetterOrDigit(c)) {
            int next;
            while ((next = in.get(num++)) >= 65 && next <= 90 || next >= 97 && next <= 122 || next >= 48 && next <= 57 || next == 46 || next == 95 || Character.isLetterOrDigit(next)) {
            }
            Symbol.Std symbol = new Symbol.Std();
            symbol.text = in.getString(0, --num, this.textCache);
            symbol.startOffset = in.getIndex();
            symbol.endOffset = in.getIndex() + in.getLengthInSource(num);
            this.addSymbol(symbol);
            in.consume(num);
            return next < 0 || next == 10 || next == 13;
        }
        Symbol.Std symbol = new Symbol.Std();
        symbol.startOffset = in.getIndex();
        symbol.endOffset = symbol.startOffset + in.getLengthInSource(num);
        symbol.status = 70640;
        this.addSymbol(symbol);
        in.consume(num);
        return c < 0 || c == 10 || c == 13;
    }

    private boolean readSymbolGraveQuote(TextParserInput in) {
        int num = 1;
        block5: while (true) {
            switch (in.get(num++)) {
                case 92: {
                    if (in.get(num++) != -1) continue block5;
                    --num;
                    continue block5;
                }
                case 96: {
                    Symbol.G symbol = new Symbol.G();
                    symbol.text = in.getString(1, num - 2, this.textCache);
                    symbol.startOffset = in.getIndex();
                    symbol.endOffset = symbol.startOffset + in.getLengthInSource(num);
                    this.addSymbol(symbol);
                    in.consume(num);
                    return false;
                }
                case -1: 
                case 10: 
                case 13: {
                    Symbol.G symbol = new Symbol.G();
                    symbol.text = in.getString(1, --num - 1, this.textCache);
                    symbol.status = 69904;
                    symbol.startOffset = in.getIndex();
                    symbol.endOffset = symbol.startOffset + in.getLengthInSource(num);
                    this.addSymbol(symbol);
                    in.consume(num);
                    return true;
                }
            }
        }
    }

    private void addSymbol(Symbol symbol) {
        symbol.rParent = this.currentTag;
        this.currentTagFragments.add(symbol);
        if (this.currentTagType != null) {
            this.setFragmentMode(this.currentTagType.getNextScanMode(this.fragmentMode));
        }
    }

    private boolean readText() {
        return true;
    }

    private boolean readCode(TextParserInput in) {
        this.codeRegions.add((TextRegion)new BasicTextRegion(in.getIndex(), in.getStopIndex()));
        return true;
    }

    private boolean isRoxygenTagChar(int c) {
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
            return true;
        }
        int type = Character.getType(c);
        return type > 0 && (type < 12 || type > 19);
    }
}

