/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAssociated;
import org.eclipse.statet.ltk.ui.util.LTKSelectionUtils;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractSourceDocumentHandler<TSourceUnit extends ISourceUnit>
extends AbstractHandler {
    protected static final byte DIRECT = 0;
    protected static final byte SHOW_BUSY = 1;
    protected static final byte BACKGROUND = 2;

    protected abstract String getTaskLabel();

    protected abstract boolean isEditTask();

    public void setEnabled(Object evaluationContext) {
        IWorkbenchPart activePart = WorkbenchUIUtils.getActivePart((Object)evaluationContext);
        ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)evaluationContext);
        ISourceEditor sourceEditor = this.getSourceEditor(activePart);
        if (sourceEditor != null && selection instanceof ITextSelection) {
            ISourceUnit sourceUnit = sourceEditor.getSourceUnit();
            this.setBaseEnabled(sourceUnit != null && (!this.isEditTask() || sourceEditor.isEditable(false)));
            return;
        }
        if (selection instanceof IStructuredSelection) {
            ISourceStructElement[] selectedElements = LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)selection);
            this.setBaseEnabled(selectedElements != null && selectedElements.length > 0 && this.checkSourceUnits(selectedElements));
            return;
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        NullProgressMonitor monitor;
        ISourceEditor sourceEditor;
        ISelection selection;
        IWorkbenchPart activePart;
        block6: {
            activePart = WorkbenchUIUtils.getActivePart((Object)event.getApplicationContext());
            selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
            sourceEditor = this.getSourceEditor(activePart);
            try {
                ExecData data;
                monitor = new NullProgressMonitor();
                if (sourceEditor == null || !(selection instanceof ITextSelection)) break block6;
                ISourceUnit sourceUnit = sourceEditor.getSourceUnit();
                if (sourceUnit != null && this.isSourceUnitSupported(sourceUnit) && (!this.isEditTask() || sourceEditor.isEditable(true)) && (data = this.createExecData(event, activePart, sourceEditor, ImCollections.newList((Object)sourceUnit), (ITextSelection)selection, null, (IProgressMonitor)monitor)) != null) {
                    this.execute(data);
                    return null;
                }
                return null;
            }
            catch (Exception e) {
                throw new ExecutionException(NLS.bind((String)EditingMessages.GenericAction_error_message, (Object)this.getTaskLabel()), (Throwable)e);
            }
        }
        if (selection instanceof IStructuredSelection) {
            ExecData data;
            ImList<TSourceUnit> sourceUnits;
            ISourceStructElement[] selectedElements = LTKSelectionUtils.getSelectedSourceStructElements((IStructuredSelection)selection);
            if (selectedElements != null && selectedElements.length > 0 && (sourceUnits = this.createSourceUnits(selectedElements, (IProgressMonitor)monitor)) != null && (data = this.createExecData(event, activePart, sourceEditor, sourceUnits, null, selectedElements, (IProgressMonitor)monitor)) != null) {
                this.execute(data);
                return null;
            }
            return null;
        }
        return null;
    }

    private ISourceEditor getSourceEditor(IWorkbenchPart part) {
        if (part instanceof ISourceEditor) {
            return (ISourceEditor)part;
        }
        ISourceEditor editor = (ISourceEditor)part.getAdapter(ISourceEditor.class);
        if (editor != null) {
            return editor;
        }
        ISourceEditorAssociated editorAssociated = (ISourceEditorAssociated)part.getAdapter(ISourceEditorAssociated.class);
        if (editorAssociated != null) {
            return editorAssociated.getSourceEditor();
        }
        return null;
    }

    private boolean checkSourceUnits(ISourceStructElement[] selectedElements) {
        ISourceUnit lastSourceUnit = null;
        ArrayList<ISourceUnit> sourceUnits = null;
        int i = 0;
        while (i < selectedElements.length) {
            ISourceUnit sourceUnit = selectedElements[i].getSourceUnit();
            if (sourceUnit == null) {
                return false;
            }
            if (!(sourceUnit.equals(lastSourceUnit) || sourceUnits != null && sourceUnits.contains(sourceUnit))) {
                if (!this.isSourceUnitSupported(sourceUnit) || this.isEditTask() && !sourceUnit.checkState(false, null)) {
                    return false;
                }
                if (lastSourceUnit == null) {
                    lastSourceUnit = sourceUnit;
                } else {
                    if (sourceUnits == null) {
                        if (!this.isMultiSourceUnitsSupported()) {
                            return false;
                        }
                        sourceUnits = new ArrayList<ISourceUnit>();
                        sourceUnits.add(lastSourceUnit);
                    }
                    sourceUnits.add(sourceUnit);
                    lastSourceUnit = sourceUnit;
                }
            }
            ++i;
        }
        return true;
    }

    private ImList<TSourceUnit> createSourceUnits(ISourceStructElement[] selectedElements, IProgressMonitor monitor) {
        ISourceUnit lastSourceUnit = null;
        ArrayList<ISourceUnit> sourceUnits = null;
        int i = 0;
        while (i < selectedElements.length) {
            ISourceUnit sourceUnit = selectedElements[i].getSourceUnit();
            if (sourceUnit == null) {
                return null;
            }
            if (!(sourceUnit.equals(lastSourceUnit) || sourceUnits != null && sourceUnits.contains(sourceUnit))) {
                if (!this.isSourceUnitSupported(sourceUnit) || this.isEditTask() && !sourceUnit.checkState(true, monitor)) {
                    return null;
                }
                if (lastSourceUnit == null) {
                    lastSourceUnit = sourceUnit;
                } else {
                    if (sourceUnits == null) {
                        if (!this.isMultiSourceUnitsSupported()) {
                            return null;
                        }
                        sourceUnits = new ArrayList<ISourceUnit>();
                        sourceUnits.add(lastSourceUnit);
                    }
                    sourceUnits.add(sourceUnit);
                    lastSourceUnit = sourceUnit;
                }
            }
            ++i;
        }
        return sourceUnits == null ? ImCollections.newList(lastSourceUnit) : ImCollections.toList(sourceUnits);
    }

    private void execute(final ExecData data) throws Exception {
        final AtomicReference<Exception> error = new AtomicReference<Exception>();
        switch (this.getExecMode(data)) {
            case 2: {
                try {
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                AbstractSourceDocumentHandler.this.doExecute(data, monitor);
                            }
                            catch (Exception e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    error.set((Exception)e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
                break;
            }
            case 1: {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            AbstractSourceDocumentHandler.this.doExecute(data, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            error.set(e);
                        }
                    }
                });
                break;
            }
            default: {
                this.doExecute(data, (IProgressMonitor)new NullProgressMonitor());
                return;
            }
        }
        if (error.get() != null) {
            throw (Exception)error.get();
        }
    }

    protected abstract boolean isSourceUnitSupported(ISourceUnit var1);

    protected boolean isMultiSourceUnitsSupported() {
        return false;
    }

    protected ExecData createExecData(ExecutionEvent event, IWorkbenchPart activePart, ISourceEditor sourceEditor, ImList<? extends TSourceUnit> sourceUnits, ITextSelection textSelection, ISourceStructElement[] selectedElements, IProgressMonitor monitor) throws Exception {
        return new ExecData(activePart, sourceEditor, sourceUnits, textSelection, selectedElements != null ? new ElementSet((Object[])selectedElements) : null);
    }

    protected byte getExecMode(ExecData data) {
        return this.isEditTask() ? (byte)1 : 0;
    }

    protected abstract void doExecute(ExecData var1, IProgressMonitor var2) throws Exception;

    protected class ExecData {
        private final IWorkbenchPart activePart;
        private final ISourceEditor sourceEditor;
        private final ImList<? extends TSourceUnit> sourceUnits;
        final ITextSelection textSelection;
        final ElementSet elementSelection;

        public ExecData(IWorkbenchPart activePart, ISourceEditor sourceEditor, ImList<? extends TSourceUnit> sourceUnits, ITextSelection textSelection, ElementSet elementSet) {
            this.activePart = activePart;
            this.sourceEditor = sourceEditor;
            this.sourceUnits = sourceUnits;
            this.textSelection = textSelection;
            this.elementSelection = elementSet;
        }

        public IWorkbenchPart getActivePart() {
            return this.activePart;
        }

        public ISourceEditor getSourceEditor() {
            return this.sourceEditor;
        }

        public ImList<? extends TSourceUnit> getSourceUnits() {
            return this.sourceUnits;
        }

        public ITextSelection getTextSelection() {
            return this.textSelection;
        }

        public ElementSet getElementSelection() {
            return this.elementSelection;
        }
    }
}

