/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text.ui.settings;

import java.util.EnumMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.databinding.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.ecommons.text.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class IndentSettingsUI {
    private static final EnumMap<IIndentSettings.IndentationType, String> INDENT_NAMES = new EnumMap(IIndentSettings.IndentationType.class);
    private Text tabSizeControl;
    private ComboViewer indentPolicyControl;
    private Button conserveIndentControl;
    private Label indentSpaceCountLabel;
    private Text indentSpaceCountControl;
    private Button replaceOtherTabsControl;
    private Text lineWidthControl;

    static {
        INDENT_NAMES.put(IIndentSettings.IndentationType.TAB, Messages.CodeStyle_Indent_Type_UseTabs_name);
        INDENT_NAMES.put(IIndentSettings.IndentationType.SPACES, Messages.CodeStyle_Indent_Type_UseSpaces_name);
    }

    public String getGroupLabel() {
        return Messages.CodeStyle_Indent_group;
    }

    public String getLevelUnitLabel() {
        return Messages.CodeStyle_Indent_Levels_label;
    }

    public void createControls(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.CodeStyle_Indent_Type_label);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.indentPolicyControl = new ComboViewer(composite, 12);
        this.indentPolicyControl.setContentProvider((IContentProvider)new ArrayContentProvider());
        IIndentSettings.IndentationType[] items = this.getAvailableIndentationTypes();
        this.indentPolicyControl.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IIndentSettings.IndentationType t = (IIndentSettings.IndentationType)element;
                return (String)INDENT_NAMES.get(t);
            }
        });
        this.indentPolicyControl.setInput((Object)items);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Combo)this.indentPolicyControl.getCombo(), INDENT_NAMES.values());
        this.indentPolicyControl.getCombo().setLayoutData((Object)gd);
        this.indentPolicyControl.setSelection((ISelection)new StructuredSelection((Object)IIndentSettings.IndentationType.TAB));
        label = new Label(composite, 0);
        label.setText(Messages.CodeStyle_TabSize_label);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.tabSizeControl = new Text(composite, 133124);
        GridData gd2 = new GridData(16384, 0x1000000, false, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)this.tabSizeControl, (int)2);
        this.tabSizeControl.setLayoutData((Object)gd2);
        label = this.indentSpaceCountLabel = new Label(composite, 0);
        label.setText(Messages.CodeStyle_Indent_NumOfSpaces_label);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.indentSpaceCountControl = new Text(composite, 133124);
        gd2 = new GridData(16384, 0x1000000, false, false);
        gd2.widthHint = LayoutUtils.hintWidth((Text)this.indentSpaceCountControl, (int)2);
        this.indentSpaceCountControl.setLayoutData((Object)gd2);
        this.conserveIndentControl = new Button(composite, 32);
        this.conserveIndentControl.setText(Messages.CodeStyle_Indent_ConserveExisting_label);
        this.conserveIndentControl.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
        this.replaceOtherTabsControl = new Button(composite, 32);
        this.replaceOtherTabsControl.setText(Messages.CodeStyle_Indent_ReplaceOtherTabs_label);
        this.replaceOtherTabsControl.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 2, 1));
    }

    public Text getTabSizeControl() {
        return this.tabSizeControl;
    }

    public void addLineWidth(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.CodeStyle_LineWidth_label);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lineWidthControl = new Text(composite, 133124);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)this.lineWidthControl, (int)4);
        this.lineWidthControl.setLayoutData((Object)gd);
    }

    protected IIndentSettings.IndentationType[] getAvailableIndentationTypes() {
        return new IIndentSettings.IndentationType[]{IIndentSettings.IndentationType.TAB, IIndentSettings.IndentationType.SPACES};
    }

    public void addBindings(DataBindingSupport db, Object model) {
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.tabSizeControl), BeanProperties.value((String)"tabSize").observe(db.getRealm(), model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 32, Messages.CodeStyle_TabSize_error_message)), null);
        IViewerObservableValue indentTargetValue = ViewersObservables.observeSingleSelection((Viewer)this.indentPolicyControl);
        indentTargetValue.setValue(null);
        indentTargetValue.addValueChangeListener(event -> {
            IIndentSettings.IndentationType t = (IIndentSettings.IndentationType)event.diff.getNewValue();
            this.indentSpaceCountLabel.setEnabled(t == IIndentSettings.IndentationType.SPACES);
            this.indentSpaceCountControl.setEnabled(t == IIndentSettings.IndentationType.SPACES);
        });
        db.getContext().bindValue((IObservableValue)indentTargetValue, BeanProperties.value((String)"indentDefaultType").observe(db.getRealm(), model));
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indentSpaceCountControl), BeanProperties.value((String)"indentSpacesCount").observe(db.getRealm(), model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 32, Messages.CodeStyle_Indent_NumOfSpaces_error_message)), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.replaceOtherTabsControl), BeanProperties.value((String)"replaceOtherTabsWithSpaces").observe(db.getRealm(), model));
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.conserveIndentControl), BeanProperties.value((String)"replaceConservative").observe(db.getRealm(), model));
        if (this.lineWidthControl != null) {
            db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.lineWidthControl), BeanProperties.value((String)"lineWidth").observe(db.getRealm(), model), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(40, 400, Messages.CodeStyle_LineWidth_error_message)), null);
        }
    }
}

