/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.elements.NameAccess;
import org.eclipse.statet.ltk.model.core.elements.NameAccessSet;
import org.eclipse.statet.ltk.model.core.impl.NameAccessAccumulator;

@NonNullByDefault
public final class BasicNameAccessSet<TNameAccess extends NameAccess<?, TNameAccess>>
implements NameAccessSet<TNameAccess> {
    private static final BasicNameAccessSet EMPTY_SET = new BasicNameAccessSet(Collections.EMPTY_MAP);
    private final ImList<String> labelsSorted;
    private final Map<String, NameAccessAccumulator<TNameAccess>> map;

    public static final <TNameAccess extends NameAccess<?, TNameAccess>> BasicNameAccessSet<TNameAccess> emptySet() {
        return EMPTY_SET;
    }

    public BasicNameAccessSet(Map<String, NameAccessAccumulator<TNameAccess>> map) {
        Object[] labelArray = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, NameAccessAccumulator<TNameAccess>> entry : map.entrySet()) {
            labelArray[i++] = entry.getKey();
            entry.getValue().finish();
        }
        Arrays.sort(labelArray);
        this.labelsSorted = ImCollections.newList((Object[])labelArray);
        this.map = map;
    }

    @Override
    public ImList<String> getNames() {
        return this.labelsSorted;
    }

    @Override
    public @Nullable ImList<TNameAccess> getAllInUnit(String label) {
        NameAccessAccumulator<TNameAccess> shared = this.map.get(label);
        return shared != null ? (ImList)shared.getList() : null;
    }
}

