/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit;

import java.util.Collection;
import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.config.IConfigRegistry;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.edit.EditController;
import org.eclipse.statet.ecommons.waltable.edit.EditSelectionCommand;
import org.eclipse.statet.ecommons.waltable.edit.EditUtils;
import org.eclipse.statet.ecommons.waltable.edit.InlineCellEditEvent;
import org.eclipse.statet.ecommons.waltable.layer.cell.ILayerCell;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;
import org.eclipse.swt.widgets.Composite;

public class EditSelectionCommandHandler
extends AbstractLayerCommandHandler<EditSelectionCommand> {
    private final SelectionLayer selectionLayer;

    public EditSelectionCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<EditSelectionCommand> getCommandClass() {
        return EditSelectionCommand.class;
    }

    @Override
    public boolean doCommand(EditSelectionCommand command) {
        Composite parent = command.getParent();
        IConfigRegistry configRegistry = command.getConfigRegistry();
        Character initialValue = command.getCharacter();
        if (EditUtils.allCellsEditable(this.selectionLayer, configRegistry) && EditUtils.isEditorSame(this.selectionLayer, configRegistry) && EditUtils.isConverterSame(this.selectionLayer, configRegistry)) {
            Collection<ILayerCell> selectedCells = this.selectionLayer.getSelectedCells();
            if (selectedCells.size() == 1) {
                ILayerCell cell = selectedCells.iterator().next();
                this.selectionLayer.fireLayerEvent(new InlineCellEditEvent(this.selectionLayer, new PositionCoordinate(this.selectionLayer, cell.getColumnPosition(), cell.getRowPosition()), parent, configRegistry, initialValue != null ? initialValue : cell.getDataValue(0, null)));
            } else if (selectedCells.size() > 1) {
                Object initialEditValue = initialValue;
                if (initialValue == null && EditUtils.isValueSame(this.selectionLayer)) {
                    ILayerCell cell = selectedCells.iterator().next();
                    initialEditValue = cell.getDataValue(0, null);
                }
                EditController.editCells(selectedCells, parent, initialEditValue, configRegistry);
            }
        }
        return true;
    }
}

