/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.databinding.core.workspace;

import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;

public class PathToResourceConverter
implements IConverter {
    private final int resourceType;
    private IContainer baseContainer;

    public PathToResourceConverter(int resourceType, IContainer baseContainer) {
        this.resourceType = resourceType;
        this.baseContainer = baseContainer;
    }

    public void setBaseContainer(IContainer container) {
        this.baseContainer = container;
    }

    public IContainer getBaseContainer() {
        return this.baseContainer;
    }

    public Object getFromType() {
        return IPath.class;
    }

    public Object getToType() {
        return IResource.class;
    }

    public IResource convert(Object fromObject) {
        return this.convert((IPath)fromObject);
    }

    protected IResource convert(IPath path) {
        IContainer base = this.getBaseContainer();
        if (path.isAbsolute()) {
            base = base.getWorkspace().getRoot();
        }
        if (path.segmentCount() == 0) {
            this.checkResourceType(base.getType(), path);
            return base;
        }
        if (path.segmentCount() == 1 && base.getType() == 8) {
            this.checkResourceType(4, path);
            return ((IWorkspaceRoot)base).getProject(path.segment(0));
        }
        if ((this.resourceType & 1) == 0 || path.hasTrailingSeparator()) {
            this.checkResourceType(2, path);
            return base.getFolder(path);
        }
        this.checkResourceType(1, path);
        return base.getFile(path);
    }

    protected void checkResourceType(int type, IPath path) {
        if (this.resourceType != 0 && (this.resourceType & type) == 0) {
            throw new IllegalArgumentException("path= " + path.toString());
        }
    }

    public static class ToContainer
    extends PathToResourceConverter {
        public ToContainer(IContainer baseContainer) {
            super(6, baseContainer);
        }

        @Override
        public Object getToType() {
            return IContainer.class;
        }

        public IContainer convert(Object fromObject) {
            return (IContainer)this.convert((IPath)fromObject);
        }
    }

    public static class ToFile
    extends PathToResourceConverter {
        public ToFile(IContainer baseContainer) {
            super(1, baseContainer);
        }

        @Override
        public Object getToType() {
            return IFile.class;
        }

        public IFile convert(Object fromObject) {
            return (IFile)this.convert((IPath)fromObject);
        }
    }

    public static class ToFolder
    extends PathToResourceConverter {
        public ToFolder(IContainer baseContainer) {
            super(2, baseContainer);
        }

        @Override
        public Object getToType() {
            return IFolder.class;
        }

        public IFolder convert(Object fromObject) {
            return (IFolder)this.convert((IPath)fromObject);
        }
    }
}

