/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.collections;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.statet.ecommons.collections.IntMap;

public final class IntArrayMap<V>
implements IntMap<V> {
    private Object[] fArray;
    private int fSize;

    public IntArrayMap() {
        this.fArray = new Object[16];
    }

    public IntArrayMap(int initialCapacity) {
        this.fArray = new Object[initialCapacity];
    }

    @Override
    public boolean isEmpty() {
        return this.fSize == 0;
    }

    @Override
    public int size() {
        return this.fSize;
    }

    @Override
    public boolean containsKey(int key) {
        return key < this.fArray.length && this.fArray[key] != null;
    }

    @Override
    public boolean containsKey(Object key) {
        return key instanceof Integer && this.containsKey((Integer)key);
    }

    @Override
    public boolean containsValue(Object value) {
        int i = this.fArray.length - 1;
        while (i >= 0) {
            if (this.fArray[i] != null && this.fArray[i].equals(value)) {
                return true;
            }
            --i;
        }
        return false;
    }

    @Override
    public V get(int key) {
        if (key < this.fArray.length) {
            return (V)this.fArray[key];
        }
        return null;
    }

    @Override
    public V get(Object key) {
        return key instanceof Integer ? (V)this.get((Integer)key) : null;
    }

    private void increase(int min) {
        Object[] newArray = new Object[min + 16];
        System.arraycopy(this.fArray, 0, newArray, 0, this.fArray.length);
        this.fArray = newArray;
    }

    @Override
    public V put(int key, V value) {
        if (key >= this.fArray.length) {
            this.increase(key);
        }
        Object oldValue = this.fArray[key];
        this.fArray[key] = value;
        if (oldValue != null) {
            return (V)oldValue;
        }
        ++this.fSize;
        return null;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> t) {
        for (Map.Entry<Integer, V> entry : t.entrySet()) {
            this.put((int)entry.getKey(), entry.getValue());
        }
    }

    public V remove(int key) {
        Object oldValue;
        if (key < this.fArray.length && (oldValue = this.fArray[key]) != null) {
            this.fArray[key] = null;
            --this.fSize;
            return (V)oldValue;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return key instanceof Integer ? (V)this.remove((Integer)key) : null;
    }

    @Override
    public void clear() {
        if (this.fSize > 0) {
            int i = this.fArray.length - 1;
            while (i >= 0) {
                this.fArray[i] = null;
                --i;
            }
            this.fSize = 0;
        }
    }

    @Override
    public Set<Integer> keySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<Integer, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    public int getMaxKey() {
        if (this.fSize > 0) {
            int i = this.fArray.length - 1;
            while (i >= 0) {
                if (this.fArray[i] != null) {
                    return i;
                }
                --i;
            }
        }
        return -1;
    }

    public V[] toArray(Class<? super V> type) {
        int length = this.getMaxKey() + 1;
        Object[] array = (Object[])Array.newInstance(type, length);
        System.arraycopy(this.fArray, 0, array, 0, length);
        return array;
    }
}

