/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.regex.Matcher;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class SourceBlock {
    protected static final void advanceLinesUpto(LineSequence lineSequence, int endLineNumber) {
        Line line;
        while ((line = lineSequence.getCurrentLine()) != null && line.getLineNumber() < endLineNumber) {
            lineSequence.advance();
        }
    }

    protected static final void advanceBlankLines(LineSequence lineSequence) {
        Line line;
        while ((line = lineSequence.getCurrentLine()) != null && line.isBlank()) {
            lineSequence.advance();
        }
    }

    protected static final void advanceNonBlankLines(LineSequence lineSequence) {
        Line line;
        while ((line = lineSequence.getCurrentLine()) != null && !line.isBlank()) {
            lineSequence.advance();
        }
    }

    protected static void assertMatches(Matcher matcher) {
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
    }

    public abstract boolean canStart(LineSequence var1, @Nullable SourceBlockItem<?> var2);

    public abstract void createItem(SourceBlocks.SourceBlockBuilder var1, LineSequence var2);

    public abstract void initializeContext(ProcessingContext var1, SourceBlockItem<?> var2);

    public abstract void emit(ProcessingContext var1, SourceBlockItem<?> var2, CommonmarkLocator var3, DocumentBuilder var4);
}

