/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.base.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.docmlet.base.ui.markuphelp.MarkupHelpManager;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocProcessingRegistry;
import org.eclipse.statet.internal.docmlet.base.ui.viewer.DocViewerCloseDelegate;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class DocBaseUIPlugin
extends AbstractUIPlugin {
    private static DocBaseUIPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private MarkupHelpManager markupHelpManager;
    private DocViewerCloseDelegate docViewerCloseDelegate;
    private DocProcessingRegistry docProcessingRegistry;

    public static DocBaseUIPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        DocBaseUIPlugin plugin = DocBaseUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            DocBaseUIPlugin docBaseUIPlugin = this;
            synchronized (docBaseUIPlugin) {
                this.started = false;
                this.docProcessingRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    DocBaseUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.base.ui", "Error occured while dispose module", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.docmlet.base/image/obj/Preamble", "obj_16", "preamble.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H1", "obj_16", "sectioning-1.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H2", "obj_16", "sectioning-2.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H3", "obj_16", "sectioning-3.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H4", "obj_16", "sectioning-4.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H5", "obj_16", "sectioning-5.png");
        util.register("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H6", "obj_16", "sectioning-6.png");
        util.register("org.eclipse.statet.docmlet.base/image/view/MarkupHelp", "view_16", "markup_help.png");
        util.register("org.eclipse.statet.docmlet.base/image/tool/Process", "tool_16", "process.png");
        util.register("org.eclipse.statet.docmlet.base/image/tool/ProcessAndPreview", "tool_16", "process_and_preview.png");
        util.register("org.eclipse.statet.docmlet.base/image/tool/Preview", "tool_16", "preview.png");
    }

    public synchronized MarkupHelpManager getMarkupHelpManager() {
        if (this.markupHelpManager == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.markupHelpManager = new MarkupHelpManager();
        }
        return this.markupHelpManager;
    }

    public synchronized DocViewerCloseDelegate getDocViewerCloseDelegate() {
        if (this.docViewerCloseDelegate == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docViewerCloseDelegate = new DocViewerCloseDelegate();
            this.disposables.add((Disposable)this.docViewerCloseDelegate);
        }
        return this.docViewerCloseDelegate;
    }

    public synchronized DocProcessingRegistry getDocProcessingRegistry() {
        if (this.docProcessingRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docProcessingRegistry = new DocProcessingRegistry();
            this.disposables.add(this.docProcessingRegistry);
        }
        return this.docProcessingRegistry;
    }
}

