/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.source;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.docmlet.wikitext.core.ast.Block;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.source.IMarkupSourceFormatAdapter;
import org.eclipse.statet.ecommons.text.IndentUtil;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockQuoteBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ListBlock;

public class CommonmarkSourceFormatAdapter
implements IMarkupSourceFormatAdapter {
    private final Matcher quoteMatcher = BlockQuoteBlock.PATTERN.matcher("");
    private final Matcher listItemMatcher = ListBlock.PATTERN.matcher("");
    private final StringBuilder indentBuilder = new StringBuilder();

    public String getPrefixCont(WikitextAstNode node, IndentUtil indentUtil) throws Exception {
        if (indentUtil.getTabWidth() != 4) {
            return null;
        }
        ArrayList<Block> blocks = new ArrayList<Block>(8);
        block12: while (node != null) {
            block0 : switch (node.getNodeType()) {
                case SOURCELINES: {
                    if (node.getParent() == null) break block12;
                    return null;
                }
                case BLOCK: {
                    switch (((Block)node).getBlockType()) {
                        case NUMERIC_LIST: 
                        case BULLETED_LIST: {
                            break block0;
                        }
                        case PARAGRAPH: 
                        case QUOTE: 
                        case LIST_ITEM: {
                            blocks.add((Block)node);
                            break block0;
                        }
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
            node = node.getWikitextParent();
        }
        switch (blocks.size()) {
            case 0: {
                return null;
            }
            case 1: {
                break;
            }
            default: {
                Collections.reverse(blocks);
            }
        }
        return this.createIndent(blocks, indentUtil);
    }

    private String createIndent(List<Block> blocks, IndentUtil indentUtil) throws Exception {
        this.indentBuilder.setLength(0);
        int column = 0;
        block5: for (Block block : blocks) {
            switch (block.getBlockType()) {
                case PARAGRAPH: {
                    break;
                }
                case QUOTE: {
                    Line nodeLine = this.createLine(indentUtil, block.getStartOffset());
                    Matcher matcher = nodeLine.setupIndent(this.quoteMatcher);
                    if (!matcher.matches()) {
                        return null;
                    }
                    int n = column;
                    column = nodeLine.getIndent();
                    indentUtil.appendIndent(this.indentBuilder, n, column);
                    this.indentBuilder.append("> ");
                    break;
                }
                case LIST_ITEM: {
                    Line nodeLine = this.createLine(indentUtil, block.getStartOffset());
                    Matcher matcher = nodeLine.setupIndent(this.listItemMatcher);
                    if (!matcher.matches()) {
                        return null;
                    }
                    int n = column;
                    column = ListBlock.computeItemLineIndent(nodeLine, matcher);
                    indentUtil.appendIndent(this.indentBuilder, n, column);
                    break;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
        return this.indentBuilder.toString();
    }

    private Line createLine(IndentUtil indentUtil, int offset) throws BadLocationException {
        IDocument doc = indentUtil.getDocument();
        int lineNum = doc.getLineOfOffset(offset);
        IRegion lineInfo = doc.getLineInformation(lineNum);
        return new Line(lineNum, offset, indentUtil.getColumn(lineNum, offset), doc.get(offset, lineInfo.getOffset() + lineInfo.getLength() - offset), "\n");
    }
}

