/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceTextBlockAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.ReferenceDefinition;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ParagraphBlock
extends SourceBlock {
    public static final ImIdentityList<Class<? extends SourceBlock>> DEFAULT_INTERRUPT_EXCLUSIONS = ImCollections.newIdentityList();
    private final Collection<Class<? extends SourceBlock>> interruptExclusions;

    public ParagraphBlock() {
        this((Collection<Class<? extends SourceBlock>>)DEFAULT_INTERRUPT_EXCLUSIONS);
    }

    public ParagraphBlock(Collection<Class<? extends SourceBlock>> interruptExclusions) {
        this.interruptExclusions = interruptExclusions;
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Line line = lineSequence.getCurrentLine();
        return line != null && !line.isBlank();
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        Line line;
        ParagraphSourceBlockItem<ParagraphBlock> blockItem = new ParagraphSourceBlockItem<ParagraphBlock>(this, builder);
        lineSequence.advance();
        while ((line = lineSequence.getCurrentLine()) != null && !line.isBlank() && !this.isAnotherBlockStart(lineSequence, builder.getSourceBlocks(), blockItem)) {
            lineSequence.advance();
        }
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
        ImList<Line> lines = blockItem.getLines();
        TextSegment textSegment = new TextSegment(lines);
        List<Inline> inlines = context.getInlineParser().parse(context, textSegment, true);
        for (Inline inline : inlines) {
            if (inline instanceof ReferenceDefinition) {
                inline.createContext(context);
                continue;
            }
            return;
        }
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        this.emit(context, blockItem, true, locator, builder);
    }

    void emit(ProcessingContext context, SourceBlockItem<?> blockItem, boolean asBlock, CommonmarkLocator locator, DocumentBuilder builder) {
        ImList<Line> lines = blockItem.getLines();
        TextSegment textSegment = new TextSegment(lines);
        List<Inline> inlines = context.getInlineParser().parse(context, textSegment, true);
        if (!(inlines.isEmpty() || context.getMode() != 3 && this.isEmptyParagraph(inlines))) {
            locator.setBlockBegin(blockItem);
            if (asBlock) {
                SourceTextBlockAttributes attributes = new SourceTextBlockAttributes(lines, 256);
                builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, (Attributes)attributes);
            }
            InlineParser.emit(context, inlines, locator, builder);
            locator.setBlockEnd(blockItem);
            if (asBlock) {
                builder.endBlock();
            }
        }
    }

    private boolean isEmptyParagraph(List<Inline> inlines) {
        for (Inline inline : inlines) {
            if (inline instanceof ReferenceDefinition) continue;
            return false;
        }
        return true;
    }

    boolean isAnotherBlockStart(LineSequence lineSequence, SourceBlocks sourceBlocks, SourceBlockItem<?> currentBlockItem) {
        SourceBlock block = sourceBlocks.selectBlock(lineSequence, currentBlockItem);
        return block != null && !(block instanceof ParagraphBlock) && !this.interruptExclusions.contains(block.getClass());
    }

    protected static class ParagraphSourceBlockItem<TBlock extends ParagraphBlock>
    extends SourceBlockItem<TBlock> {
        public ParagraphSourceBlockItem(TBlock type, SourceBlocks.SourceBlockBuilder builder) {
            super(type, builder);
        }

        @Override
        public boolean isParagraph() {
            return true;
        }
    }
}

