/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.statet.ecommons.preferences.PreferencesUtil;
import org.eclipse.statet.ecommons.preferences.SettingsChangeNotifier;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.docmlet.tex.ui.editors.LtxDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.EnhTemplateStore;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class TexUIPlugin
extends AbstractUIPlugin {
    private static TexUIPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private IPreferenceStore editorPreferenceStore;
    private LtxDocumentProvider ltxDocumentProvider;
    private TextStyleManager ltxTextStyles;
    private ContextTypeRegistry ltxEditorTemplateContextTypeRegistry;
    private EnhTemplateStore ltxEditorTemplateStore;
    private ContentAssistComputerRegistry ltxEditorContentAssistRegistry;
    private Map<String, String> commandImages;

    public static TexUIPlugin getInstance() {
        return instance;
    }

    public static final void log(IStatus status) {
        TexUIPlugin plugin = TexUIPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.ltxEditorTemplateStore != null) {
                this.ltxEditorTemplateStore.stopListeningForPreferenceChanges();
            }
            TexUIPlugin texUIPlugin = this;
            synchronized (texUIPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.ltxDocumentProvider = null;
                this.ltxEditorTemplateStore = null;
                this.ltxEditorTemplateContextTypeRegistry = null;
                this.ltxEditorContentAssistRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    TexUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStoppingListener(Disposable listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        TexUIPlugin texUIPlugin = this;
        synchronized (texUIPlugin) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.disposables.add(listener);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        if (!this.started) {
            throw new IllegalStateException("Plug-in is not started.");
        }
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register("org.eclipse.statet.docmlet.tex/image/obj/sectioning-part", "obj_16", "sectioning-part.png");
        util.register("org.eclipse.statet.docmlet.tex/image/obj/sectioning-chapter", "obj_16", "sectioning-chapter.png");
        util.register("org.eclipse.statet.docmlet.tex/image/obj/sectioning-section", "obj_16", "sectioning-section.png");
        util.register("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsection", "obj_16", "sectioning-subsection.png");
        util.register("org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsubsection", "obj_16", "sectioning-subsubsection.png");
        util.register("org.eclipse.statet.docmlet.tex/image/obj/label", "obj_16", "label.png");
        HashMap<String, String> commandMap = new HashMap<String, String>();
        commandMap.put("S", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00a7");
        commandMap.put("dag", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2020");
        commandMap.put("ddag", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2021");
        commandMap.put("textasciicircum", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-005e");
        commandMap.put("textasciitilde", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-02dc");
        commandMap.put("ldots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2026");
        commandMap.put("cdots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22ef");
        commandMap.put("vdots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22ee");
        commandMap.put("adots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22f0");
        commandMap.put("ddots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22f1");
        commandMap.put("underline", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0332");
        commandMap.put("Alpha", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-alpha");
        commandMap.put("alpha", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-alpha");
        commandMap.put("Beta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-beta");
        commandMap.put("beta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-beta");
        commandMap.put("Gamma", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-gamma");
        commandMap.put("gamma", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-gamma");
        commandMap.put("Delta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-delta");
        commandMap.put("delta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-delta");
        commandMap.put("Epsilon", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-epsilon");
        commandMap.put("epsilon", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-epsilon");
        commandMap.put("varepsilon", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-epsilon-var");
        commandMap.put("Zeta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-zeta");
        commandMap.put("zeta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-zeta");
        commandMap.put("Eta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-eta");
        commandMap.put("eta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-eta");
        commandMap.put("Theta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-theta");
        commandMap.put("theta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-theta");
        commandMap.put("vartheta", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-theta-var");
        commandMap.put("Iota", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-iota");
        commandMap.put("iota", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-iota");
        commandMap.put("Kappa", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-kappa");
        commandMap.put("kappa", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-kappa");
        commandMap.put("varkappa", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-kappa-var");
        commandMap.put("Lambda", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-lambda");
        commandMap.put("lambda", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-lambda");
        commandMap.put("Mu", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-mu");
        commandMap.put("mu", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-mu");
        commandMap.put("Nu", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-nu");
        commandMap.put("nu", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-nu");
        commandMap.put("Xi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-xi");
        commandMap.put("xi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-xi");
        commandMap.put("Omicron", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-omicron");
        commandMap.put("omicron", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-omicron");
        commandMap.put("Pi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-pi");
        commandMap.put("pi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-pi");
        commandMap.put("varpi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-pi-var");
        commandMap.put("Rho", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-rho");
        commandMap.put("rho", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-rho");
        commandMap.put("varrho", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-rho-var");
        commandMap.put("Sigma", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-sigma");
        commandMap.put("sigma", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-sigma");
        commandMap.put("varsigma", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-sigma-var");
        commandMap.put("Tau", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-tau");
        commandMap.put("tau", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-tau");
        commandMap.put("Upsilon", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-upsilon");
        commandMap.put("upsilon", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-upsilon");
        commandMap.put("Phi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-phi");
        commandMap.put("phi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-phi");
        commandMap.put("varphi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-phi-var");
        commandMap.put("Chi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-chi");
        commandMap.put("chi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-chi");
        commandMap.put("Psi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-psi");
        commandMap.put("psi", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-psi");
        commandMap.put("Omega", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-u-omega");
        commandMap.put("omega", "org.eclipse.statet.docmlet.tex.ui/image/obj/greek-l-omega");
        commandMap.put("pm", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00b1");
        commandMap.put("mp", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2213");
        commandMap.put("cdot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c5");
        commandMap.put("times", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00d7");
        commandMap.put("ast", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2217");
        commandMap.put("star", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c6");
        commandMap.put("diamond", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c4");
        commandMap.put("circ", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2218");
        commandMap.put("bullet", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2219");
        commandMap.put("div", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00f7");
        commandMap.put("cap", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2229");
        commandMap.put("cup", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-222a");
        commandMap.put("setminus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2216");
        commandMap.put("uplus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-228e");
        commandMap.put("sqcap", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2293");
        commandMap.put("sqcup", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2294");
        commandMap.put("triangleleft", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-25c1");
        commandMap.put("triangleright", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-25b7");
        commandMap.put("wr", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2240");
        commandMap.put("wedge", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2228");
        commandMap.put("vee", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2227");
        commandMap.put("oplus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2295");
        commandMap.put("ominus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2296");
        commandMap.put("otimes", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2297");
        commandMap.put("oslash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2298");
        commandMap.put("odot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2299");
        commandMap.put("amalg", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a3f");
        commandMap.put("equiv", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2261");
        commandMap.put("sim", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-223c");
        commandMap.put("simeq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2ab0");
        commandMap.put("asymp", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-224d");
        commandMap.put("approx", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2248");
        commandMap.put("approxeq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-224a");
        commandMap.put("eqsim", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2242");
        commandMap.put("cong", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2245");
        commandMap.put("doteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2250");
        commandMap.put("leq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2264");
        commandMap.put("geq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2265");
        commandMap.put("ll", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-226a");
        commandMap.put("gg", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-226b");
        commandMap.put("leqq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2266");
        commandMap.put("geqq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2267");
        commandMap.put("leqslant", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a7d");
        commandMap.put("geqslant", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a7e");
        commandMap.put("eqslantless", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a95");
        commandMap.put("eqslantgtr", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a96");
        commandMap.put("lesssim", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2272");
        commandMap.put("gtrsim", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2273");
        commandMap.put("lessapprox", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a85");
        commandMap.put("gtrapprox", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a86");
        commandMap.put("lessdot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22d6");
        commandMap.put("gtrdot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22d7");
        commandMap.put("llless", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22d8");
        commandMap.put("gggtr", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22d9");
        commandMap.put("lessgtr", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2276");
        commandMap.put("gtrless", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2277");
        commandMap.put("lesseqgtr", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22da");
        commandMap.put("gtreqless", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22db");
        commandMap.put("prec", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-227a");
        commandMap.put("succ", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-227b");
        commandMap.put("preceq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2aaf");
        commandMap.put("succeq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2ab0");
        commandMap.put("in", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2208");
        commandMap.put("ni", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-220b");
        commandMap.put("subset", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2282");
        commandMap.put("supset", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2283");
        commandMap.put("subseteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2286");
        commandMap.put("supseteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2287");
        commandMap.put("sqsubset", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-228f");
        commandMap.put("sqsupset", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2290");
        commandMap.put("sqsubseteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2291");
        commandMap.put("sqsupseteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2292");
        commandMap.put("bowtie", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c8");
        commandMap.put("propto", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-221d");
        commandMap.put("mid", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2223");
        commandMap.put("vdash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a2");
        commandMap.put("dashv", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a3");
        commandMap.put("models", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a7");
        commandMap.put("vDash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a8");
        commandMap.put("Vdash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a9");
        commandMap.put("Vvdash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22aa");
        commandMap.put("vartriangleleft", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22b2");
        commandMap.put("vartriangleright", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22b3");
        commandMap.put("trianglelefteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22b4");
        commandMap.put("trianglerighteq", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22b5");
        commandMap.put("parallel", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2225");
        commandMap.put("perp", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-27c2");
        commandMap.put("frown", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2322");
        commandMap.put("smile", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2323");
        commandMap.put("sum", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2211");
        commandMap.put("prod", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-220f");
        commandMap.put("coprod", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2210");
        commandMap.put("int", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-222b");
        commandMap.put("oint", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-222e");
        commandMap.put("bigcap", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c2");
        commandMap.put("bigcup", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c3");
        commandMap.put("bigsqcup", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a06");
        commandMap.put("bigwedge", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c0");
        commandMap.put("bigvee", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22c1");
        commandMap.put("bigodot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a00");
        commandMap.put("bigoplus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a01");
        commandMap.put("bigotimes", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a02");
        commandMap.put("biguplus", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2a04");
        commandMap.put("aleph", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2135");
        commandMap.put("beth", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2136");
        commandMap.put("gimel", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2137");
        commandMap.put("daleth", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2138");
        commandMap.put("imath", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-1d6a5");
        commandMap.put("jmath", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-1d6a5");
        commandMap.put("complement", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2201");
        commandMap.put("ell", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2113");
        commandMap.put("eth", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00f0");
        commandMap.put("hslash", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-210f");
        commandMap.put("mho", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2127");
        commandMap.put("partial", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2202");
        commandMap.put("Finv", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2132");
        commandMap.put("wp", "org.eclipse.statet.docmlet.tex.ui/image/obj/script-u-p");
        commandMap.put("Re", "org.eclipse.statet.docmlet.tex.ui/image/obj/fraktur-u-r");
        commandMap.put("Im", "org.eclipse.statet.docmlet.tex.ui/image/obj/fraktur-u-i");
        commandMap.put("prime", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2032");
        commandMap.put("backprime", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2035");
        commandMap.put("infty", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-221e");
        commandMap.put("emptyset", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-o-emptyset");
        commandMap.put("varnothing", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-o-varnothing");
        commandMap.put("nabla", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2207");
        commandMap.put("surd", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-221a");
        commandMap.put("top", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a4");
        commandMap.put("bot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22a5");
        commandMap.put("angle", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2220");
        commandMap.put("measuredangle", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2221");
        commandMap.put("sphericalangle", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2222");
        commandMap.put("blacktriangle", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-blacktriangle");
        commandMap.put("triangle", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-triangle");
        commandMap.put("blacktriangledown", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-blacktriangledown");
        commandMap.put("triangledown", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-triangledown");
        commandMap.put("blacksquare", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-blacksquare");
        commandMap.put("square", "org.eclipse.statet.docmlet.tex.ui/image/obj/misc-g-square");
        commandMap.put("forall", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2200");
        commandMap.put("exists", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2203");
        commandMap.put("nexists", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2204");
        commandMap.put("neg", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-00ac");
        commandMap.put("flat", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-266d");
        commandMap.put("natural", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-266e");
        commandMap.put("sharp", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-266f");
        commandMap.put("spadesuit", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2660");
        commandMap.put("heartsuit", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2661");
        commandMap.put("diamondsuit", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2662");
        commandMap.put("clubsuit", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2663");
        commandMap.put("lbrack", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-lbrack");
        commandMap.put("rbrack", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rbrack");
        commandMap.put("lceil", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-lceil");
        commandMap.put("rceil", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rceil");
        commandMap.put("lfloor", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-lfloor");
        commandMap.put("rfloor", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rfloor");
        commandMap.put("lbrace", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-lbrace");
        commandMap.put("rbrace", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rbrace");
        commandMap.put("langle", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-langle");
        commandMap.put("rangle", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rangle");
        commandMap.put("leftarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-left");
        commandMap.put("rightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-right");
        commandMap.put("uparrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-up");
        commandMap.put("downarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-down");
        commandMap.put("leftrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-leftright");
        commandMap.put("nwarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-nw");
        commandMap.put("nearrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-ne");
        commandMap.put("searrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-se");
        commandMap.put("swarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-sw");
        commandMap.put("updownarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-updown");
        commandMap.put("Leftarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-left-double");
        commandMap.put("Rightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-right-double");
        commandMap.put("Uparrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-up-double");
        commandMap.put("Downarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-down-double");
        commandMap.put("Leftrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-leftright-double");
        commandMap.put("Updownarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-updown-double");
        commandMap.put("longleftarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-left");
        commandMap.put("longrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-right");
        commandMap.put("longleftrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-leftright");
        commandMap.put("Longleftarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-left-double");
        commandMap.put("Longrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-right-double");
        commandMap.put("Longleftrightarrow", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-leftright-double");
        commandMap.put("mapsto", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-right-bar");
        commandMap.put("longmapsto", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-l-right-bar");
        commandMap.put("leftharpoonup", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-h-left-up");
        commandMap.put("leftharpoondown", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-h-left-down");
        commandMap.put("rightharpoonup", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-h-right-up");
        commandMap.put("rightharpoondown", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-h-right-down");
        commandMap.put("rightleftharpoons", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-h-rightleft");
        commandMap.put("grave", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0300");
        commandMap.put("acute", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0301");
        commandMap.put("hat", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0302");
        commandMap.put("tilde", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0303");
        commandMap.put("bar", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0304");
        commandMap.put("overline", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0305");
        commandMap.put("breve", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0306");
        commandMap.put("check", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-030c");
        commandMap.put("dot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0307");
        commandMap.put("ddot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-0308");
        commandMap.put("dddot", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-20db");
        commandMap.put("vec", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-20d7");
        commandMap.put("widehat", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-hat");
        commandMap.put("widetilde", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-tilde");
        commandMap.put("sqrt", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-root");
        commandMap.put("frac", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-frac");
        StringBuilder sb = new StringBuilder();
        for (String key : commandMap.values()) {
            sb.setLength(0);
            sb.append(key, key.lastIndexOf(47) + 1, key.length());
            sb.append(".png");
            util.register(key, "obj_16", sb.toString());
        }
        commandMap.put("part", "org.eclipse.statet.docmlet.tex/image/obj/sectioning-part");
        commandMap.put("chapter", "org.eclipse.statet.docmlet.tex/image/obj/sectioning-chapter");
        commandMap.put("section", "org.eclipse.statet.docmlet.tex/image/obj/sectioning-section");
        commandMap.put("subsection", "org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsection");
        commandMap.put("subsubsection", "org.eclipse.statet.docmlet.tex/image/obj/sectioning-subsubsection");
        commandMap.put("label", "org.eclipse.statet.docmlet.tex/image/obj/label");
        commandMap.put("ref", "org.eclipse.statet.docmlet.tex/image/obj/label");
        commandMap.put("pageref", "org.eclipse.statet.docmlet.tex/image/obj/label");
        commandMap.put("nameref", "org.eclipse.statet.docmlet.tex/image/obj/label");
        commandMap.put("eqref", "org.eclipse.statet.docmlet.tex/image/obj/label");
        commandMap.put("dots", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2026");
        commandMap.put("dotsc", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2026");
        commandMap.put("dotsb", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22ef");
        commandMap.put("dotsm", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22ef");
        commandMap.put("dotsi", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-22ef");
        commandMap.put("textbullet", "org.eclipse.statet.docmlet.tex.ui/image/obj/binop-bullet");
        commandMap.put("textperiodcentered", "org.eclipse.statet.docmlet.tex.ui/image/obj/binop-cdot");
        commandMap.put("le", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2264");
        commandMap.put("ge", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2265");
        commandMap.put("dagger", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2020");
        commandMap.put("ddagger", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2021");
        commandMap.put("land", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2228");
        commandMap.put("lor", "org.eclipse.statet.docmlet.tex.ui/image/obj/c-2227");
        commandMap.put("{", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-lbrace");
        commandMap.put("}", "org.eclipse.statet.docmlet.tex.ui/image/obj/delim-b-rbrace");
        commandMap.put("gets", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-left");
        commandMap.put("to", "org.eclipse.statet.docmlet.tex.ui/image/obj/arrow-s-right");
        commandMap.put("dfrac", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-frac");
        commandMap.put("tfrac", "org.eclipse.statet.docmlet.tex.ui/image/obj/comb-frac");
        this.commandImages = commandMap;
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        if (this.editorPreferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.editorPreferenceStore;
    }

    public synchronized LtxDocumentProvider getTexDocumentProvider() {
        if (this.ltxDocumentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxDocumentProvider = new LtxDocumentProvider();
            this.disposables.add(this.ltxDocumentProvider);
        }
        return this.ltxDocumentProvider;
    }

    public TextStyleManager getLtxTextStyles() {
        if (this.ltxTextStyles == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxTextStyles = new TextStyleManager(SharedUIResources.getColors(), this.getPreferenceStore(), "org.eclipse.statet.docmlet.tex.ui/textstyle/Ltx");
            PreferencesUtil.getSettingsChangeNotifier().addManageListener((SettingsChangeNotifier.ManageListener)this.ltxTextStyles);
        }
        return this.ltxTextStyles;
    }

    public synchronized ContextTypeRegistry getLtxEditorTemplateContextTypeRegistry() {
        if (this.ltxEditorTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxEditorTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.docmlet.templates.LtxEditor");
        }
        return this.ltxEditorTemplateContextTypeRegistry;
    }

    public synchronized EnhTemplateStore getLtxEditorTemplateStore() {
        if (this.ltxEditorTemplateStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxEditorTemplateStore = new EnhTemplateStore(this.getLtxEditorTemplateContextTypeRegistry(), this.getPreferenceStore(), "editor/assist/Ltx/EditorTemplates.store");
            try {
                this.ltxEditorTemplateStore.load();
            }
            catch (IOException e) {
                TexUIPlugin.log((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.ui", 0, "An error occured when loading 'LaTeX Editor' template store.", (Throwable)e));
            }
        }
        return this.ltxEditorTemplateStore;
    }

    public synchronized ContentAssistComputerRegistry getLtxEditorContentAssistRegistry() {
        if (this.ltxEditorContentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.ltxEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.docmlet.contentTypes.Ltx", "org.eclipse.statet.docmlet.tex.ui/editor/assist/Ltx");
            this.disposables.add((Disposable)this.ltxEditorContentAssistRegistry);
        }
        return this.ltxEditorContentAssistRegistry;
    }

    public Map<String, String> getCommandImages() {
        this.getImageRegistry();
        return this.commandImages;
    }
}

