/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingManager;
import org.eclipse.statet.internal.docmlet.base.ui.DocBaseUIPlugin;
import org.eclipse.statet.internal.docmlet.base.ui.processing.DocProcessingRegistry;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class DocProcessingUI {
    public static final String PROCESS_DOC_DEFAULT_COMMAND_ID = "org.eclipse.statet.docmlet.commands.ProcessDocDefault";
    public static final String PREVIEW_DOC_DEFAULT_COMMAND_ID = "org.eclipse.statet.docmlet.commands.PreviewDocDefault";
    public static final String PROCESS_AND_PREVIEW_DOC_DEFAULT_COMMAND_ID = "org.eclipse.statet.docmlet.commands.ProcessAndPreviewDefault";
    public static final String WEAVE_STEP = "weave";
    public static final String PRODUCE_OUTPUT_STEP = "produce_output";
    public static final String PREVIEW_OUTPUT_STEP = "open_output";
    public static final String PROCESSING_STEPS_FLAG = "processing_steps";
    public static final String TOGGLE_RUN_ON_SAVE_COMMAND_ID = "org.eclipse.statet.docmlet.commands.ToggleRunDocProcessingOnSave";
    public static final String BASE_RUN_ATTR_QUALIFIER = "org.eclipse.statet.docmlet.base/run";
    public static final String CONTENT_TYPE_ID_ATTR_NAME = "org.eclipse.statet.docmlet.base/run/ContentType.id";
    public static final String RUN_STEPS_ATTR_NAME = "org.eclipse.statet.docmlet.base/run/BuildSteps.set";
    public static final String SOURCE_PATH_ATTR_NAME = "org.eclipse.statet.docmlet.base/run/DocSource.path";
    public static final String ACTIONS_RUN_CONFIG_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfig";
    public static final String ACTIONS_RUN_CONFIG_PROCESS_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigProcess";
    public static final String ACTIONS_RUN_CONFIG_STEP_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigStep";
    public static final String ACTIONS_RUN_CONFIG_PREVIEW_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsRunConfigPreview";
    public static final String ACTIONS_ACTIVATE_CONFIG_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsActivateConfig";
    public static final String ACTIONS_EDIT_CONFIG_HELP_CONTEXT_ID = "org.eclipse.statet.docmlet.doc.user.DocProcessingActionsEditConfig";

    public static @Nullable DocProcessingManager getDocProcessingManager(String contentTypeId) {
        DocProcessingRegistry registry = DocBaseUIPlugin.getInstance().getDocProcessingRegistry();
        return registry.getDocProcessingManager(contentTypeId);
    }

    public static @Nullable DocProcessingManager getDocProcessingManager(IContentType contentType, boolean inherit) {
        DocProcessingRegistry registry = DocBaseUIPlugin.getInstance().getDocProcessingRegistry();
        if (!inherit) {
            return registry.getDocProcessingManager(contentType.getId());
        }
        do {
            DocProcessingManager manager;
            if ((manager = registry.getDocProcessingManager(contentType.getId())) == null) continue;
            return manager;
        } while ((contentType = contentType.getBaseType()) != null);
        return null;
    }

    public static class CommonFlags {
        public static final ImIdentitySet<String> PROCESS_AND_PREVIEW = ImCollections.newIdentitySet();
        public static final ImIdentitySet<String> PROCESS = ImCollections.newIdentitySet((Object)"processing_steps");
        public static final ImIdentitySet<String> WEAVE = ImCollections.newIdentitySet((Object)"weave");
        public static final ImIdentitySet<String> PRODUCE_OUTPUT = ImCollections.newIdentitySet((Object)"produce_output");
        public static final ImIdentitySet<String> OPEN_OUTPUT = ImCollections.newIdentitySet((Object)"open_output");
    }
}

