/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.statet.ecommons.ui.actions.ControlServicesUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.services.IServiceLocator;

public class AutoCheckController<TElement>
implements Listener {
    private final CheckboxTableViewer viewer;
    private final IObservableSet<TElement> set;
    private int ignoreTime;

    public AutoCheckController(CheckboxTableViewer viewer, IObservableSet<TElement> set) {
        this.viewer = viewer;
        this.set = set;
        viewer.getTable().addListener(13, (Listener)this);
    }

    public IObservableSet<TElement> getChecked() {
        return this.set;
    }

    public void handleEvent(final Event event) {
        if (event.type == 13) {
            if (event.item == null) {
                return;
            }
            if (event.detail == 32) {
                this.ignoreTime = event.time;
            } else if (event.detail == 0 && event.time != this.ignoreTime && ((event.stateMask & SWT.BUTTON_MASK) == 0 || (event.stateMask & SWT.BUTTON_MASK) == 524288)) {
                event.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (event.time == AutoCheckController.this.ignoreTime) {
                            return;
                        }
                        if ((event.stateMask & SWT.MOD2) != 0) {
                            TableItem[] selection = AutoCheckController.this.viewer.getTable().getSelection();
                            ArrayList<Object> list = new ArrayList<Object>();
                            TableItem[] tableItemArray = selection;
                            int n = selection.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TableItem item = tableItemArray[n2];
                                Object element = item.getData();
                                if (element != null) {
                                    list.add(element);
                                }
                                ++n2;
                            }
                            AutoCheckController.this.set.retainAll(list);
                            if (AutoCheckController.this.set.size() != list.size()) {
                                AutoCheckController.this.set.addAll(list);
                            }
                        } else if ((event.stateMask & SWT.MOD1) != 0) {
                            Object element = event.item.getData();
                            if (element != null) {
                                AutoCheckController.this.set.add(element);
                            }
                        } else {
                            Object element = event.item.getData();
                            if (element != null) {
                                AutoCheckController.this.set.retainAll(Collections.singleton(element));
                                if (AutoCheckController.this.set.isEmpty()) {
                                    AutoCheckController.this.set.add(element);
                                }
                            }
                        }
                    }
                });
            }
            return;
        }
    }

    public void addActions(IServiceLocator serviceLocator) {
        ControlServicesUtil servicesUtil = new ControlServicesUtil(serviceLocator, String.valueOf(this.viewer.getClass().getName()) + '#' + this.hashCode(), this.viewer.getControl());
        servicesUtil.addControl(this.viewer.getControl());
        servicesUtil.activateHandler("org.eclipse.ui.edit.selectAll", (IHandler)this.createSelectAllHandler());
    }

    public IHandler2 createSelectAllHandler() {
        return new AbstractHandler(){

            public Object execute(ExecutionEvent event) throws ExecutionException {
                AutoCheckController.this.viewer.getTable().selectAll();
                AutoCheckController.this.set.addAll((Collection)((IStructuredSelection)AutoCheckController.this.viewer.getSelection()).toList());
                return null;
            }
        };
    }
}

