/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.pkgmanager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.r.core.pkgmanager.IRPkgData;
import org.eclipse.statet.r.core.pkgmanager.IRPkgSet;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.rj.renv.core.RNumVersion;
import org.eclipse.statet.rj.renv.core.RPkg;

public class RPkgResolver {
    private final IRPkgSet.Ext pkgSet;
    private final Map<String, List<RPkgAction.Install>> selected;
    private final List<String> selectedNames;
    private final Map<String, List<? extends IRPkgData>> required;
    private boolean addRequired;
    private final LinkedHashSet<String> requiredToCheck;
    private Set<String> suggested;
    private final List<IStatus> statusList;
    private IStatus status;

    private static void removeInvalid(RPkg reqPkg, List<? extends RPkg> availablePkgs) {
        RNumVersion reqVersion = reqPkg.getVersion();
        if (reqVersion.toString().startsWith(">=")) {
            Iterator<? extends RPkg> iter = availablePkgs.iterator();
            while (iter.hasNext()) {
                if (reqVersion.isSatisfiedBy(iter.next().getVersion())) continue;
                iter.remove();
            }
        }
    }

    public RPkgResolver(IRPkgSet.Ext pkgSet, Map<String, List<RPkgAction.Install>> pkgs) {
        this.pkgSet = pkgSet;
        this.selected = pkgs;
        Object[] names = pkgs.keySet().toArray(new String[pkgs.size()]);
        Arrays.sort(names);
        this.selectedNames = ImCollections.newList((Object[])names);
        this.required = new IdentityHashMap<String, List<? extends IRPkgData>>();
        this.addRequired = true;
        this.requiredToCheck = new LinkedHashSet(16);
        this.statusList = new ArrayList<IStatus>();
    }

    public void setAddSuggested(boolean enabled) {
        if (this.status != null) {
            throw new IllegalStateException();
        }
        this.suggested = enabled ? new HashSet(8) : null;
    }

    public void setAddRequired(boolean enabled) {
        if (this.status != null) {
            throw new IllegalStateException();
        }
        this.addRequired = enabled;
    }

    public IStatus run() {
        this.resolve();
        this.status = this.statusList.isEmpty() ? Status.OK_STATUS : new MultiStatus("org.eclipse.statet.r.core", 0, this.statusList.toArray(new IStatus[this.statusList.size()]), "Cannot install the selected packages.", null);
        return this.status;
    }

    public IStatus getStatus() {
        if (this.status == null) {
            throw new IllegalStateException();
        }
        return this.status;
    }

    public String getReason(RPkg pkg) {
        String name = pkg.getName();
        if (this.selected.containsKey(name)) {
            return "selected";
        }
        if (this.suggested != null && this.suggested.contains(name)) {
            return "suggested";
        }
        if (this.required.containsKey(name)) {
            return "required";
        }
        return null;
    }

    private void resolve() {
        Context main = new Context();
        if (this.addRequired) {
            for (String name : this.selectedNames) {
                List<RPkgAction.Install> list = this.selected.get(name);
                for (RPkgAction.Install action : list) {
                    IRPkgData pkg = action.getPkg();
                    this.check(pkg, "selected", "depends on", pkg.getDepends(), main);
                    this.check(pkg, "selected", "imports", pkg.getImports(), main);
                    this.check(pkg, "selected", "is linking to", pkg.getLinkingTo(), main);
                }
            }
            if (!this.statusList.isEmpty()) {
                return;
            }
            this.checkRequired(main);
            if (!this.statusList.isEmpty()) {
                return;
            }
            TmpContext tmp = new TmpContext();
            if (this.suggested != null) {
                for (String name : this.selectedNames) {
                    List<RPkgAction.Install> list = this.selected.get(name);
                    for (RPkgAction.Install action : list) {
                        block13: {
                            IRPkgData pkg = action.getPkg();
                            try {
                                try {
                                    this.check(pkg, "selected", "suggests", pkg.getSuggests(), tmp);
                                    this.checkRequired(tmp);
                                    this.suggested.addAll(tmp.getTmpNames());
                                    tmp.merge();
                                }
                                catch (OperationCanceledException operationCanceledException) {
                                    this.requiredToCheck.clear();
                                    break block13;
                                }
                            }
                            catch (Throwable throwable) {
                                this.requiredToCheck.clear();
                                throw throwable;
                            }
                            this.requiredToCheck.clear();
                        }
                        tmp.reset();
                    }
                }
            }
        }
    }

    private void checkRequired(Context context) {
        Iterator iter = this.requiredToCheck.iterator();
        while (iter.hasNext()) {
            String pkgName = (String)iter.next();
            iter.remove();
            List<? extends IRPkgData> list = context.getRequired(pkgName);
            if (list == null || list.isEmpty()) continue;
            IRPkgData pkg = list.get(0);
            this.check(pkg, "required", "depends on", pkg.getDepends(), context);
            this.check(pkg, "required", "imports", pkg.getImports(), context);
            this.check(pkg, "required", "is linking to", pkg.getLinkingTo(), context);
            iter = this.requiredToCheck.iterator();
        }
    }

    private void check(RPkg pkg, String pkgLabel, String reqLabel, List<? extends RPkg> reqList, Context context) {
        if (pkg.getName().equals("R")) {
            return;
        }
        for (RPkg rPkg : reqList) {
            IRPkgData old;
            List list;
            String reqName = rPkg.getName();
            RNumVersion reqVersion = rPkg.getVersion();
            if (reqName.equals("R")) continue;
            List<RPkgAction.Install> selected = this.selected.get(reqName);
            if (selected != null) {
                if (reqVersion == RNumVersion.NONE || reqVersion.isSatisfiedByAny((Iterator)new RPkgActionVersionIterator(selected))) continue;
                context.handleProblem(4, NLS.bind((String)(pkgLabel == "selected" ? "The selected packages ''{1}'' ({2}) and ''{3}'' ({4}) are not compatible, ''{1}'' {5} version {6} of ''{3}''." : "The {0} package ''{1}'' ({2}) and the selected package ''{3}'' ({4}) are not compatible, ''{1}'' {5} version {6} of ''{3}''."), (Object[])new Object[]{pkgLabel, pkg.getName(), pkg.getVersion(), reqName, selected.get(0).getPkg().getVersion(), reqLabel, reqVersion}), new String[0]);
                continue;
            }
            if (this.isReqInstalled(reqName, reqVersion) || (list = context.getRequired(reqName)) != null && list.isEmpty()) continue;
            if (list == null) {
                list = this.pkgSet.getAvailable().get(reqName);
                old = null;
            } else {
                old = list.get(0);
            }
            if (list == null || list.isEmpty()) {
                context.setRequiredMissing(reqName);
                context.handleProblem(4, NLS.bind((String)"The {0} package ''{1}'' ({2}) {4} package ''{3}'', but no version of ''{3}'' can be found.", (Object[])new Object[]{pkgLabel, pkg.getName(), pkg.getVersion(), reqName, reqLabel}), new String[0]);
                continue;
            }
            RPkgResolver.removeInvalid(rPkg, list);
            if (list.isEmpty()) {
                context.setRequiredMissing(reqName);
                if (old != null) {
                    this.requiredToCheck.remove(reqName);
                }
                context.handleProblem(4, NLS.bind((String)"The {0} package ''{1}'' ({2}) {4} version {5} of package ''{3}'', but no compatible version of ''{3}'' can be found.", (Object[])new Object[]{pkgLabel, pkg.getName(), pkg.getVersion(), reqName, reqLabel, reqVersion}), new String[0]);
                continue;
            }
            context.setRequired(reqName, list);
            if (old == list.get(0)) continue;
            this.requiredToCheck.add(reqName);
        }
    }

    private boolean isReqInstalled(String reqName, RNumVersion reqVersion) {
        List list = this.pkgSet.getInstalled().get(reqName);
        return !list.isEmpty() && (reqVersion == RNumVersion.NONE || reqVersion.isSatisfiedByAny((Iterator)new RPkgVersionIterator(list)));
    }

    public List<RPkgAction.Install> createActions() {
        ActionCollector collector = new ActionCollector();
        collector.run();
        return collector.getActions();
    }

    private class ActionCollector {
        private final Set<String> visited;
        private final List<RPkgAction.Install> ordered;

        public ActionCollector() {
            int count = RPkgResolver.this.selected.size() + RPkgResolver.this.required.size();
            this.visited = new HashSet<String>(count);
            this.ordered = new ArrayList<RPkgAction.Install>(count);
        }

        public void run() {
            for (String name : RPkgResolver.this.selectedNames) {
                this.addPkg(name);
            }
            Set keySet = RPkgResolver.this.required.keySet();
            Object[] names = keySet.toArray(new String[keySet.size()]);
            Arrays.sort(names);
            Object[] objectArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                Object name = objectArray[n2];
                this.addPkg((String)name);
                ++n2;
            }
        }

        private List<RPkgAction.Install> getFinal(String name) {
            List selected = (List)RPkgResolver.this.selected.get(name);
            if (selected != null) {
                return selected;
            }
            List list = (List)RPkgResolver.this.required.get(name);
            if (list != null && !list.isEmpty()) {
                return Collections.singletonList(new RPkgAction.Install((IRPkgData)list.get(0), null, null));
            }
            return Collections.emptyList();
        }

        private void addPkg(String pkgName) {
            if (this.visited.add(pkgName)) {
                List<RPkgAction.Install> actions = this.getFinal(pkgName);
                for (RPkgAction.Install action : actions) {
                    IRPkgData pkg = action.getPkg();
                    this.addReqPkgs(pkg.getDepends());
                    this.addReqPkgs(pkg.getImports());
                    this.addReqPkgs(pkg.getLinkingTo());
                    this.ordered.add(action);
                }
            }
        }

        private void addReqPkgs(List<? extends RPkg> pkgs) {
            for (RPkg rPkg : pkgs) {
                if (RPkgResolver.this.isReqInstalled(rPkg.getName(), rPkg.getVersion())) continue;
                this.addPkg(rPkg.getName());
            }
        }

        public List<RPkgAction.Install> getActions() {
            return this.ordered;
        }
    }

    private class Context {
        Context() {
        }

        List<? extends IRPkgData> getRequired(String name) {
            return (List)RPkgResolver.this.required.get(name);
        }

        void setRequired(String name, List<? extends IRPkgData> list) {
            RPkgResolver.this.required.put(name, list);
        }

        void setRequiredMissing(String name) {
            this.setRequired(name, Collections.emptyList());
        }

        void handleProblem(int severity, String message, String ... args) {
            RPkgResolver.this.statusList.add(new Status(severity, "org.eclipse.statet.r.core", args != null && args.length > 0 ? NLS.bind((String)message, (Object[])args) : message));
        }
    }

    private static class RPkgActionVersionIterator
    implements Iterator<RNumVersion> {
        private final List<? extends RPkgAction> list;
        private int idx = 0;

        public RPkgActionVersionIterator(List<? extends RPkgAction> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public RNumVersion next() {
            return this.list.get(this.idx++).getPkg().getVersion();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class RPkgVersionIterator
    implements Iterator<RNumVersion> {
        private final List<? extends RPkg> list;
        private int idx = 0;

        public RPkgVersionIterator(List<? extends RPkg> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.idx < this.list.size();
        }

        @Override
        public RNumVersion next() {
            return this.list.get(this.idx++).getVersion();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TmpContext
    extends Context {
        private final Map<String, List<? extends IRPkgData>> tmpRequired = new HashMap<String, List<? extends IRPkgData>>();

        TmpContext() {
        }

        @Override
        List<? extends IRPkgData> getRequired(String name) {
            List<? extends IRPkgData> list = this.tmpRequired.get(name);
            return list != null ? list : super.getRequired(name);
        }

        @Override
        void setRequired(String name, List<? extends IRPkgData> list) {
            this.tmpRequired.put(name, list);
        }

        @Override
        void handleProblem(int severity, String message, String ... args) {
            throw new OperationCanceledException();
        }

        Set<String> getTmpNames() {
            return this.tmpRequired.keySet();
        }

        void merge() {
            RPkgResolver.this.required.putAll(this.tmpRequired);
        }

        void reset() {
            this.tmpRequired.clear();
        }
    }
}

