/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.jface.text.quickassist.IQuickFixableAnnotation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationPresentation;
import org.eclipse.jface.text.source.ImageUtilities;
import org.eclipse.statet.ltk.issues.core.Problem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;

public class SourceProblemAnnotation
extends Annotation
implements IAnnotationPresentation,
IQuickFixableAnnotation {
    public static final String TASK_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.task";
    public static final String SPELLING_ANNOTATION_TYPE = "org.eclipse.ui.workbench.texteditor.spelling";
    public static final PresentationConfig ERROR_CONFIG = new PresentationConfig("org.eclipse.ui.workbench.texteditor.error", 1);
    public static final PresentationConfig WARNING_CONFIG = new PresentationConfig("org.eclipse.ui.workbench.texteditor.warning", 1);
    public static final PresentationConfig INFO_CONFIG = new PresentationConfig("org.eclipse.ui.workbench.texteditor.info", 1);
    private final Problem problem;
    private boolean isQuickFixable = false;
    private boolean isQuickFixableStateSet = false;
    private final PresentationConfig config;

    public SourceProblemAnnotation(String type, Problem problem, PresentationConfig config) {
        super(type, false, null);
        this.problem = problem;
        this.config = config;
    }

    public String getText() {
        return this.problem.getMessage();
    }

    public Problem getProblem() {
        return this.problem;
    }

    public int getLayer() {
        return this.config.getLevel();
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Image image = this.config.getImage();
        if (image != null) {
            ImageUtilities.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000, (int)128);
        }
    }

    public void setQuickFixable(boolean state) {
        this.isQuickFixable = state;
        this.isQuickFixableStateSet = true;
    }

    public boolean isQuickFixableStateSet() {
        return this.isQuickFixableStateSet;
    }

    public boolean isQuickFixable() {
        return this.isQuickFixable;
    }

    public static class PresentationConfig {
        private final int level;
        private String imageKey;
        private Image image;

        private PresentationConfig(String referenceType, int levelDiff) {
            String symbolicImageName;
            AnnotationPreference preference = EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(referenceType);
            this.level = levelDiff != Integer.MIN_VALUE ? (preference != null ? preference.getPresentationLayer() : 0) + levelDiff : 0;
            if (preference != null && (symbolicImageName = preference.getSymbolicImageName()) != null) {
                this.imageKey = DefaultMarkerAnnotationAccess.getSharedImageName((String)preference.getSymbolicImageName());
            }
        }

        public final int getLevel() {
            return this.level;
        }

        public final Image getImage() {
            if (this.image == null && this.imageKey != null) {
                this.image = PlatformUI.getWorkbench().getSharedImages().getImage(this.imageKey);
            }
            return this.image;
        }
    }
}

