/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import java.io.PrintStream;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.status.Status;

@NonNullByDefault
public class CommonsRuntime {
    private static @Nullable AppEnvironment environment;

    public static void init(AppEnvironment environment) {
        if (CommonsRuntime.environment != null) {
            throw new IllegalStateException(String.format("Already initialized by '%1$s'.", CommonsRuntime.environment.getBundleId()));
        }
        CommonsRuntime.environment = environment;
    }

    public static AppEnvironment getEnvironment() {
        return environment;
    }

    public static void log(Status status) {
        AppEnvironment environment = CommonsRuntime.environment;
        if (environment != null) {
            environment.log(status);
        } else {
            PrintStream out;
            switch (status.getSeverity()) {
                case 0: 
                case 1: {
                    out = System.out;
                    break;
                }
                default: {
                    out = System.err;
                }
            }
            out.print(status.toString());
        }
    }

    private CommonsRuntime() {
    }
}

