/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.wizards;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.databinding.core.util.DirtyTracker;
import org.eclipse.statet.ecommons.databinding.core.workspace.RelativePathValidator;
import org.eclipse.statet.ecommons.databinding.core.workspace.StringToPathConverter;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.wizards.Messages;
import org.eclipse.statet.internal.r.ui.wizards.NewRProjectWizardPage;
import org.eclipse.statet.ltk.core.util.UserInfo;
import org.eclipse.statet.r.core.rlang.RPkgNameValidator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RPkgProjectWizardPage
extends WizardPage {
    private static final String AUTHOR_HISTORY = "RPkgAuthor.history";
    private static final String MAINTAINER_HISTORY = "RPkgMaintainer.history";
    private final NewRProjectWizardPage projectPage;
    private Text pkgFolderControl;
    private Text pkgNameControl;
    private Combo pkgAuthorControl;
    private Combo pkgMaintainerControl;
    private DataBindingContext dbc;
    private IObservableValue<IPath> pkgFolderValue;
    private RelativePathValidator pkgFolderValidator;
    private IObservableValue<String> pkgNameValue;
    private IObservableValue<String> pkgAuthorValue;
    private IObservableValue<String> pkgMaintainerValue;
    private boolean wasVisible;
    private DirtyTracker pkgUserChanged;

    public RPkgProjectWizardPage(NewRProjectWizardPage projectPage) {
        super("RPkgWizardPage");
        this.setTitle(Messages.RPkgWizardPage_title);
        this.setDescription(Messages.RPkgWizardPage_description);
        this.projectPage = projectPage;
    }

    public void createControl(Composite parent) {
        Realm realm = Realm.getDefault();
        this.pkgFolderValue = new WritableValue(realm, (Object)Path.EMPTY, IPath.class);
        this.pkgNameValue = new WritableValue(realm, (Object)"", String.class);
        this.pkgAuthorValue = new WritableValue(realm, (Object)"", String.class);
        this.pkgMaintainerValue = new WritableValue(realm, (Object)"", String.class);
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newContentGrid());
        Composite group = this.createRPkgGroup(composite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group = this.createFolderGroup(composite);
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        this.dbc = new DataBindingContext(realm);
        this.addBindings(this.dbc, realm);
        this.projectPage.getProjectValue().addValueChangeListener(this::onProjectChanged);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)this.dbc);
        this.loadSettings();
    }

    protected Composite createFolderGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        Label label = new Label(composite, 0);
        label.setText("Package root folder inside project (optional): ");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.pkgFolderControl = new Text(composite, 2052);
        this.pkgFolderControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected Composite createRPkgGroup(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        composite.setText("R Package");
        Label label = new Label((Composite)composite, 0);
        label.setText("Package &name:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.pkgNameControl = new Text((Composite)composite, 18436);
        this.pkgNameControl.setFont(JFaceResources.getTextFont());
        this.pkgNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
        label = new Label((Composite)composite, 0);
        label.setText("&Author(s):");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.pkgAuthorControl = new Combo((Composite)composite, 2052);
        this.pkgAuthorControl.setFont(JFaceResources.getTextFont());
        this.pkgAuthorControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label((Composite)composite, 0);
        label.setText("&Maintainer:");
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.pkgMaintainerControl = new Combo((Composite)composite, 2052);
        this.pkgMaintainerControl.setFont(JFaceResources.getTextFont());
        this.pkgMaintainerControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected void addBindings(DataBindingContext dbc, Realm realm) {
        this.pkgUserChanged = new DirtyTracker();
        Binding binding = dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.pkgNameControl), this.pkgNameValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new RPkgNameValidator()), null);
        this.pkgUserChanged.add(binding);
        dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.pkgAuthorControl), this.pkgAuthorValue);
        dbc.bindValue((IObservableValue)WidgetProperties.text().observe((Widget)this.pkgMaintainerControl), this.pkgMaintainerValue);
        this.pkgFolderValidator = new RelativePathValidator(2, null, "package root folder");
        dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.pkgFolderControl), this.pkgFolderValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.pkgFolderValidator).setConverter((IConverter)new StringToPathConverter()), null);
    }

    private void onProjectChanged(ValueChangeEvent<? extends IProject> event) {
        boolean pkgUserDirty = this.pkgUserChanged.isDirty();
        IProject project = (IProject)event.diff.getNewValue();
        this.pkgFolderValidator.setBaseContainer((IContainer)project);
        if (!pkgUserDirty) {
            this.pkgNameControl.setText(project.getName());
        }
        this.dbc.updateModels();
        if (!pkgUserDirty) {
            this.pkgUserChanged.resetDirty();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            boolean firstTime = !this.wasVisible;
            this.wasVisible = true;
            if (firstTime) {
                this.setMessage(null);
                this.setErrorMessage(null);
            }
        }
    }

    protected void loadSettings() {
        UserInfo authorInfo = UserInfo.getAuthorInfo();
        IDialogSettings dialogSettings = this.getDialogSettings();
        this.initCombo(this.pkgAuthorControl, this.pkgAuthorValue, dialogSettings.getArray(AUTHOR_HISTORY), authorInfo.getName(), authorInfo.getSource());
        this.initCombo(this.pkgMaintainerControl, this.pkgMaintainerValue, dialogSettings.getArray(MAINTAINER_HISTORY), String.valueOf(authorInfo.getName()) + " <" + authorInfo.getEmail() + ">", authorInfo.getSource());
    }

    private void initCombo(Combo combo, IObservableValue<String> value, String[] history, String infoText, int infoSource) {
        history = DialogUtils.noNull((String[])history);
        String text = "";
        if (history.length > 0) {
            text = history[0];
        }
        if (infoSource <= 2) {
            history = DialogUtils.combineHistoryItems((String[])history, (String)infoText);
        }
        if (text.isEmpty()) {
            text = infoText;
        }
        combo.setItems(history);
        value.setValue((Object)text);
    }

    protected void saveSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        DialogUtils.saveHistorySettings((IDialogSettings)dialogSettings, (String)AUTHOR_HISTORY, (String)this.getPkgAuthor());
        DialogUtils.saveHistorySettings((IDialogSettings)dialogSettings, (String)MAINTAINER_HISTORY, (String)this.getPkgMaintainer());
    }

    public String getPkgName() {
        return (String)this.pkgNameValue.getValue();
    }

    public IPath getPkgFolderPath() {
        return (IPath)this.pkgFolderValue.getValue();
    }

    public String getPkgAuthor() {
        return (String)this.pkgAuthorValue.getValue();
    }

    public String getPkgMaintainer() {
        return (String)this.pkgMaintainerValue.getValue();
    }
}

