/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.editors;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.statet.internal.r.ui.editors.RKeywordCompletionProposal;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.ltk.ui.LTKUI;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IAssistCompletionProposal;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class RoxygenCompletionComputer
implements IContentAssistComputer {
    private static final List<String> TAG_COMMANDS;

    static {
        String[] tags = new String[]{"docType", "export", "exportClass", "exportMethod", "exportPattern", "import", "importFrom", "importClassesFrom", "importMethodsFrom", "name", "aliases", "title", "usage", "references", "note", "include", "slot", "param", "return", "returnType", "seealso", "example", "examples", "author", "concept", "keywords", "method", "prototype", "S3method", "S3class", "listObject", "attributeObject", "environmentObject", "noRd", "useDynLib", "rdname", "template", "section", "description", "details", "family", "inheritParams", "format", "source", "encoding", "describeIn", "field"};
        Object[] commands = new String[tags.length];
        int i = 0;
        while (i < commands.length) {
            commands[i] = String.valueOf('@') + tags[i];
            ++i;
        }
        TAG_COMMANDS = ImCollections.newList((Object[])commands);
    }

    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
    }

    public void sessionEnded() {
    }

    public IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        String tagPrefix = this.getTagPrefix(context);
        if (tagPrefix != null) {
            this.doComputeTagProposals(context, tagPrefix, proposals, monitor);
        }
        return Status.OK_STATUS;
    }

    public IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector proposals, IProgressMonitor monitor) {
        return null;
    }

    private String getTagPrefix(AssistInvocationContext context) {
        try {
            int last;
            IDocument document = context.getSourceViewer().getDocument();
            int start = Math.max(context.getInvocationOffset() - 20, 0);
            String s = document.get(start, context.getInvocationOffset() - start);
            int i = last = s.length() - 1;
            while (i >= 0) {
                char c = s.charAt(i);
                if (c == '@') {
                    return s.substring(i);
                }
                if (!this.isRoxygenTagChar(c)) {
                    return i == last ? "" : null;
                }
                --i;
            }
            return null;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private boolean isRoxygenTagChar(int c) {
        if (c >= 65 && c <= 90 || c >= 97 && c <= 122) {
            return true;
        }
        int type = Character.getType(c);
        return type > 0 && (type < 12 || type > 19);
    }

    private void doComputeTagProposals(AssistInvocationContext context, String prefix, AssistProposalCollector proposals, IProgressMonitor monitor) {
        int offset = context.getInvocationOffset() - prefix.length();
        List<String> keywords = TAG_COMMANDS;
        for (String keyword : keywords) {
            if (!keyword.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
            proposals.add((IAssistCompletionProposal)new TagProposal(context, keyword, offset));
        }
    }

    private static class TagProposal
    extends RKeywordCompletionProposal {
        public TagProposal(AssistInvocationContext context, String keyword, int replacementOffset) {
            super(context, keyword, replacementOffset);
        }

        @Override
        public Image getImage() {
            return LTKUI.getImages().get("org.eclipse.statet.ltk.ui/image/obj/text.at_tag");
        }

        protected int computeReplacementLength(int replacementOffset, Point selection, int caretOffset, boolean overwrite) throws BadLocationException {
            int end = Math.max(caretOffset, selection.x + selection.y);
            if (overwrite) {
                IDocument document = this.getInvocationContext().getSourceViewer().getDocument();
                while (end < document.getLength()) {
                    if (!Character.isLetterOrDigit(document.getChar(end))) break;
                    ++end;
                }
            }
            return end - replacementOffset;
        }

        protected void doApply(char trigger, int stateMask, int caretOffset, int replacementOffset, int replacementLength) throws BadLocationException {
            AssistInvocationContext context = this.getInvocationContext();
            SourceViewer viewer = context.getSourceViewer();
            IDocument document = viewer.getDocument();
            try {
                String replacementString = this.getReplacementString();
                int newCaretOffset = replacementOffset + replacementString.length() + 1;
                if (replacementOffset + replacementLength == document.getLength() || document.getChar(replacementOffset + replacementLength) != ' ') {
                    replacementString = String.valueOf(replacementString) + ' ';
                }
                document.replace(replacementOffset, replacementLength, replacementString);
                this.setCursorPosition(newCaretOffset);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

