/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableVariable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RObject;

public final class RDataTableContentDescription {
    private static final IRDataTableVariable[] NO_COLUMNS_ARRAY = new IRDataTableVariable[0];
    private final RElementName fElementName;
    private final RObject fStruct;
    private final String fLabel;
    private final Tool fRHandle;
    private List<RDataTableColumn> fColumnHeaderRows = Collections.emptyList();
    private List<RDataTableColumn> fRowHeaderColumns = Collections.emptyList();
    private List<RDataTableColumn> fDataColumns = Collections.emptyList();
    private IRDataTableVariable[] fDataVariables = NO_COLUMNS_ARRAY;
    private RDataFormatter fDefaultDataFormat;

    public RDataTableContentDescription(RElementName elementName, RObject struct, Tool rHandle) {
        if (elementName == null) {
            throw new NullPointerException("elementName");
        }
        if (struct == null) {
            throw new NullPointerException("struct");
        }
        this.fElementName = elementName;
        this.fStruct = struct;
        this.fLabel = elementName.getDisplayName();
        this.fRHandle = rHandle;
    }

    public RElementName getElementName() {
        return this.fElementName;
    }

    public RObject getRElementStruct() {
        return this.fStruct;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public Tool getRHandle() {
        return this.fRHandle;
    }

    void setColumnHeaderRows(RDataTableColumn ... dataColumns) {
        this.fColumnHeaderRows = ImCollections.newList((Object[])dataColumns);
    }

    void setRowHeaderColumns(RDataTableColumn ... dataColumns) {
        this.fRowHeaderColumns = ImCollections.newList((Object[])dataColumns);
    }

    void setDataColumns(RDataTableColumn ... dataColumns) {
        this.fDataColumns = ImCollections.newList((Object[])dataColumns);
    }

    void setVariables(IRDataTableVariable ... variables) {
        this.fDataVariables = variables;
    }

    void setDefaultDataFormat(RDataFormatter format) {
        this.fDefaultDataFormat = format;
    }

    public List<RDataTableColumn> getColumnHeaderRows() {
        return this.fColumnHeaderRows;
    }

    public List<RDataTableColumn> getRowHeaderColumns() {
        return this.fRowHeaderColumns;
    }

    public List<RDataTableColumn> getDataColumns() {
        return this.fDataColumns;
    }

    IRDataTableVariable[] getVariables() {
        return this.fDataVariables;
    }

    public RDataFormatter getDefaultDataFormat() {
        return this.fDefaultDataFormat;
    }

    public int hashCode() {
        return 986986;
    }

    public boolean equals(Object obj) {
        return obj instanceof RDataTableContentDescription;
    }
}

