/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.AbstractEditorOutlinePage;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.LRangeList;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.dataeditor.FTableVariable;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataEditor;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataLabelProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableListener;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableVariable;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RDataEditorOutlinePage
extends AbstractEditorOutlinePage {
    private final RDataEditor fEditor;
    private RDataTableContentDescription fDescription;

    public RDataEditorOutlinePage(RDataEditor editor) {
        super("org.eclipse.statet.r.menu.RDataOutlineViewContextMenu");
        this.fEditor = editor;
    }

    public RDataEditor getDataEditor() {
        return this.fEditor;
    }

    protected IDialogSettings getDialogSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"RDataOutlineView");
    }

    protected void configureViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setContentProvider((IContentProvider)new RDataContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new RDataLabelProvider());
        viewer.setInput((Object)this);
    }

    protected void init() {
        super.init();
        this.fEditor.getRDataTable().addTableListener(new IRDataTableListener(){

            @Override
            public void inputChanged(IRDataTableInput input, RDataTableContentDescription description) {
                boolean isNew = description != null && (RDataEditorOutlinePage.this.fDescription == null || RDataEditorOutlinePage.this.fDescription.getVariables().length != description.getVariables().length);
                RDataEditorOutlinePage.this.fDescription = description;
                TreeViewer viewer = RDataEditorOutlinePage.this.getViewer();
                if (UIAccess.isOkToUse((Viewer)viewer)) {
                    viewer.refresh();
                    if (isNew && RDataEditorOutlinePage.this.fDescription != null) {
                        viewer.expandToLevel(3);
                    }
                }
            }
        });
    }

    protected void selectInEditor(ISelection selection) {
        Object element;
        IStructuredSelection structuredSelection;
        if (selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof RDataTableColumn) {
            this.fEditor.getRDataTable().revealColumn(((RDataTableColumn)element).getIndex());
        }
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        IStructuredSelection selection = (IStructuredSelection)this.getViewer().getSelection();
        for (Object element : selection) {
            if (element instanceof RDataTableColumn) continue;
            return;
        }
        m.add((IContributionItem)new SimpleContributionItem("Select Column", "S"){

            protected void execute() throws ExecutionException {
                IStructuredSelection selection = (IStructuredSelection)RDataEditorOutlinePage.this.getViewer().getSelection();
                LRangeList columnIndexes = new LRangeList();
                for (Object element : selection) {
                    if (element instanceof RDataTableColumn) {
                        columnIndexes.values().add(((RDataTableColumn)element).getIndex());
                        continue;
                    }
                    return;
                }
                RDataEditorOutlinePage.this.fEditor.getRDataTable().selectColumns((Collection<LRange>)columnIndexes);
            }
        });
        m.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            m.add((IContributionItem)new SimpleContributionItem("Sort Increasing by Column", "I", SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/sort.alpha"), null){

                protected void execute() throws ExecutionException {
                    IStructuredSelection selection = (IStructuredSelection)RDataEditorOutlinePage.this.getViewer().getSelection();
                    Object element = selection.getFirstElement();
                    if (selection.size() == 1 && element instanceof RDataTableColumn) {
                        RDataTableColumn column = (RDataTableColumn)element;
                        RDataEditorOutlinePage.this.fEditor.getRDataTable().sortByColumn(column.getIndex(), true);
                    }
                }
            });
            m.add((IContributionItem)new SimpleContributionItem("Sort Decreasing by Column", "I"){

                protected void execute() throws ExecutionException {
                    IStructuredSelection selection = (IStructuredSelection)RDataEditorOutlinePage.this.getViewer().getSelection();
                    Object element = selection.getFirstElement();
                    if (selection.size() == 1 && element instanceof RDataTableColumn) {
                        RDataTableColumn column = (RDataTableColumn)element;
                        RDataEditorOutlinePage.this.fEditor.getRDataTable().sortByColumn(column.getIndex(), false);
                    }
                }
            });
        }
        m.add((IContributionItem)new SimpleContributionItem("Clear All Sorting", "O"){

            protected void execute() throws ExecutionException {
                RDataEditorOutlinePage.this.fEditor.getRDataTable().clearSorting();
            }
        });
    }

    private static class FTableFactorLevels
    extends VariablePropertyItem {
        public FTableFactorLevels(FTableVariable variable) {
            super(variable);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Object[] getChildren() {
            RStore data = ((FTableVariable)this.fVariable).getLevelStore();
            return data.toArray();
        }

        @Override
        public String getName() {
            return "Levels";
        }

        @Override
        public int getCount() {
            RStore data = ((FTableVariable)this.fVariable).getLevelStore();
            return (int)data.getLength();
        }
    }

    private static class FactorLevels
    extends VariablePropertyItem {
        public FactorLevels(RDataTableColumn column) {
            super(column);
        }

        @Override
        public boolean hasChildren() {
            return true;
        }

        @Override
        public Object[] getChildren() {
            RFactorStore data = (RFactorStore)((RDataTableColumn)this.fVariable).getDataStore();
            return data.getLevels().toArray();
        }

        @Override
        public String getName() {
            return "Factor Levels";
        }

        @Override
        public int getCount() {
            RFactorStore data = (RFactorStore)((RDataTableColumn)this.fVariable).getDataStore();
            return data.getLevelCount();
        }
    }

    private class RDataContentProvider
    implements ITreeContentProvider {
        private RDataContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (RDataEditorOutlinePage.this.fDescription != null) {
                return new Object[]{RDataEditorOutlinePage.this.fDescription};
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof RDataTableColumn) {
                return RDataEditorOutlinePage.this.fDescription;
            }
            if (element instanceof VariablePropertyItem) {
                return ((VariablePropertyItem)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element == RDataEditorOutlinePage.this.fDescription) {
                return RDataEditorOutlinePage.this.fDescription.getVariables().length > 0;
            }
            if (element instanceof RDataTableColumn) {
                RDataTableColumn column = (RDataTableColumn)element;
                return column.getVarType() == 10;
            }
            if (element instanceof FTableVariable) {
                return true;
            }
            if (element instanceof VariablePropertyItem) {
                VariablePropertyItem item = (VariablePropertyItem)element;
                return item.hasChildren();
            }
            return false;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] columns;
            if (parentElement == RDataEditorOutlinePage.this.fDescription && (columns = RDataEditorOutlinePage.this.fDescription.getVariables()).length <= 2500) {
                return columns;
            }
            if (parentElement instanceof RDataTableColumn) {
                RDataTableColumn column = (RDataTableColumn)parentElement;
                if (column.getVarType() == 10) {
                    return new Object[]{new FactorLevels(column)};
                }
            } else {
                if (parentElement instanceof FTableVariable) {
                    return new Object[]{new FTableFactorLevels((FTableVariable)parentElement)};
                }
                if (parentElement instanceof VariablePropertyItem) {
                    VariablePropertyItem item = (VariablePropertyItem)parentElement;
                    return item.getChildren();
                }
            }
            return new Object[0];
        }

        public void dispose() {
        }
    }

    static abstract class VariablePropertyItem {
        protected final IRDataTableVariable fVariable;

        public VariablePropertyItem(IRDataTableVariable column) {
            this.fVariable = column;
        }

        public Object getParent() {
            return this.fVariable;
        }

        public boolean hasChildren() {
            return false;
        }

        public Object[] getChildren() {
            return new Object[0];
        }

        public abstract String getName();

        public int getCount() {
            return -1;
        }

        public int hashCode() {
            return this.getName().hashCode() * this.fVariable.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof VariablePropertyItem)) {
                return false;
            }
            VariablePropertyItem other = (VariablePropertyItem)obj;
            return this.getName() == other.getName() && this.fVariable.equals(other.fVariable);
        }
    }
}

