/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.api.control;

import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.control.SiriusUncontrolCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.sirius.viewpoint.provider.SiriusEditPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class SiriusUncontrolHandler
extends AbstractHandler {
    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final EObject semanticRoot = this.getSelectedEObject(event);
        if (semanticRoot != null) {
            try {
                new ProgressMonitorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell()).run(false, false, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                        try {
                            monitor.beginTask(Messages.SiriusUncontrolHandler_uncontrolTask, 1);
                            SiriusUncontrolHandler.this.performUncontrol(HandlerUtil.getActiveShell((ExecutionEvent)event), semanticRoot, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        finally {
                            monitor.done();
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
            catch (InterruptedException e) {
                SiriusEditPlugin.getPlugin().getLog().log((IStatus)new Status(4, "org.eclipse.sirius.ui", e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return null;
    }

    public void performUncontrol(Shell shell, EObject semanticRoot, IProgressMonitor monitor) {
        Session session = SessionManager.INSTANCE.getSession(semanticRoot);
        if (session != null) {
            boolean uncontrolRepresentations = this.shouldUncontrolRepresentations(shell);
            SiriusUncontrolCommand vuc = new SiriusUncontrolCommand(semanticRoot, uncontrolRepresentations, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            TransactionUtil.getEditingDomain((EObject)semanticRoot).getCommandStack().execute((Command)vuc);
            session.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (uncontrolRepresentations) {
                IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
                for (DialectEditor editor : uiSession.getEditors()) {
                    if (!(editor instanceof IReusableEditor)) continue;
                    IReusableEditor iReusableEditor = (IReusableEditor)editor;
                    DRepresentation representation = editor.getRepresentation();
                    URI repDescURI = Optional.ofNullable(editor.getEditorInput()).filter(SessionEditorInput.class::isInstance).map(SessionEditorInput.class::cast).map(SessionEditorInput::getRepDescUri).orElse(null);
                    SessionEditorInput updatedEditorInput = new SessionEditorInput(EcoreUtil.getURI((EObject)representation), repDescURI, representation.getName(), session);
                    iReusableEditor.setInput((IEditorInput)updatedEditorInput);
                }
            }
        }
    }

    protected boolean shouldUncontrolRepresentations(Shell shell) {
        return MessageDialog.openQuestion((Shell)shell, (String)Messages.SiriusUncontrolHandler_uncontrolRepresentationsTitle, (String)Messages.SiriusUncontrolHandler_uncontrolRepresentationsMessage);
    }

    private EObject getSelectedEObject(ExecutionEvent event) {
        IStructuredSelection iss;
        Object obj;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection && (obj = (iss = (IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return (EObject)obj;
        }
        return null;
    }
}

