/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.services.graphql.api;

import graphql.ExecutionInput;
import graphql.ExecutionResult;
import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.services.graphql.api.ISiriusGraphQLQueryResult;
import org.eclipse.sirius.services.graphql.common.api.SiriusGraphQLContext;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLMessages;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLPlugin;
import org.eclipse.sirius.services.graphql.internal.SiriusGraphQLQueryResult;
import org.eclipse.sirius.services.graphql.internal.schema.SiriusGraphQLSchemaProvider;

public class SiriusGraphQLInterpreter {
    private static final String MAX_COST = "org.eclipse.sirius.services.graphql.cost";
    private static final int DEFAULT_MAX_COST = 100;
    private GraphQLSchema schema;

    public SiriusGraphQLInterpreter() {
        this(new SiriusGraphQLSchemaProvider().getSchema());
    }

    public SiriusGraphQLInterpreter(GraphQLSchema schema) {
        this.schema = schema;
    }

    public ISiriusGraphQLQueryResult execute(String query, Map<String, Object> variables, String operationName, Object context) {
        ExecutionInput executionInput = ExecutionInput.newExecutionInput().query(query).variables(variables).operationName(operationName).context((Object)new SiriusGraphQLContext(this.getMaxCost())).build();
        GraphQL graphQL = GraphQL.newGraphQL((GraphQLSchema)this.schema).build();
        ExecutionResult executionResult = graphQL.execute(executionInput);
        return new SiriusGraphQLQueryResult(executionResult);
    }

    private int getMaxCost() {
        int value = 100;
        String propertyValue = System.getProperty(MAX_COST);
        if (propertyValue != null && propertyValue.length() > 0) {
            try {
                value = Integer.parseInt(propertyValue);
            }
            catch (NumberFormatException exception) {
                String message = String.format(SiriusGraphQLMessages.SiriusGraphQLInterpreter_wrongPropertyTypeWarning, propertyValue, 100);
                Status status = new Status(4, "org.eclipse.sirius.services.graphql", message, (Throwable)exception);
                SiriusGraphQLPlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return value;
    }
}

